/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.component.cep;

import com.ebmwebsourcing.easiergov.client.impl.soap.DataManagerClientImplSOAP;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.component.cep.CepAssigner;
import com.ebmwebsourcing.easyesb.component.cep.ExpressionEvaluator;
import com.ebmwebsourcing.easyschema.xsd2xml.XSD2XML;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.UpdateListener;
import com.espertech.esper.event.map.MapEventBean;
import com.espertech.esper.event.xml.XMLEventBean;
import com.petalslink.data_api._1.GetElement;
import com.petalslink.data_api._1.GetElementResponse;
import easybox.org.w3._2001.xmlschema.EJaxbSchema;
import easyesb.ebmwebsourcing.com.data.ceprules.EJaxbAction;
import easyesb.ebmwebsourcing.com.data.ceprules.EJaxbEventAction;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.DOMBuilder;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Document;

public class EventListener
implements UpdateListener {
    private static final Logger LOG = Logger.getLogger(EventListener.class.getName());
    private List<EJaxbAction> actions = null;
    private String producerAddress;
    private SOAPSender sender = new SOAPSender();
    private DataManagerClientImplSOAP easierGovClient;

    public EventListener(String producerAddress, List<EJaxbAction> actions, DataManagerClientImplSOAP easierGovClient) {
        this.actions = actions;
        this.producerAddress = producerAddress;
        this.easierGovClient = easierGovClient;
    }

    public void update(EventBean[] newEvents, EventBean[] oldEvents) {
        LOG.finest("CEP RULES TRIGERRED: new = " + newEvents[0] + " old = " + oldEvents);
        MapEventBean ev = (MapEventBean)newEvents[0];
        for (EJaxbAction a : this.actions) {
            if (a.getType().equals("event")) {
                try {
                    QName resultEvent = a.getEventAction().getName();
                    GetElement request = new GetElement();
                    request.setIdElement(resultEvent);
                    GetElementResponse response = this.easierGovClient.getElement(request);
                    Document doc = null;
                    if (response.getAny() instanceof EJaxbSchema) {
                        doc = SOAJAXBContext.getInstance().unmarshallAnyElement(response.getAny());
                    } else if (response.getAny() instanceof org.w3c.dom.Element) {
                        doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                        doc.appendChild(doc.adoptNode((org.w3c.dom.Element)response.getAny()));
                    }
                    Schema schema = (Schema)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)DefaultFramework.getInstance()).get()).readDocument(doc, Schema.class);
                    com.ebmwebsourcing.easyschema10.api.element.Element elmt = schema.getElementByName(resultEvent.getLocalPart());
                    Element jelmt = XSD2XML.newInstance().generateElement(elmt, (XmlObject)schema, null);
                    ExpressionEvaluator exp = new ExpressionEvaluator();
                    ArrayList<Namespace> nss = new ArrayList<Namespace>();
                    for (EJaxbEventAction.Assigners.NamespaceContext.NamespacePrefix ns : a.getEventAction().getAssigners().getNamespaceContext().getNamespacePrefix()) {
                        nss.add(Namespace.getNamespace((String)ns.getPrefix(), (String)ns.getNamespace()));
                    }
                    for (EJaxbEventAction.Assigners.Assigner e : a.getEventAction().getAssigners().getAssigner()) {
                        HashMap<String, Element> varContext = new HashMap<String, Element>();
                        if (e.getLeft().indexOf("/") > 0) {
                            varContext.put(e.getLeft().substring(0, e.getLeft().indexOf("/")).replace("$", ""), jelmt);
                        } else {
                            varContext.put(e.getLeft().replace("$", ""), jelmt);
                        }
                        for (Map.Entry entryProperty : ev.getProperties().entrySet()) {
                            XMLEventBean bean = (XMLEventBean)entryProperty.getValue();
                            LOG.finest("under = " + bean.getUnderlying());
                            varContext.put((String)entryProperty.getKey(), new DOMBuilder().build((org.w3c.dom.Element)bean.getUnderlying()));
                        }
                        LOG.finest("varContext = " + varContext);
                        Object source = exp.evaluateAsNode(varContext, e.getRight(), nss);
                        Object destination = exp.evaluateAsNode(varContext, e.getLeft(), nss);
                        new CepAssigner().affect(destination, source);
                    }
                    doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(new XMLOutputter().outputString(jelmt).getBytes()));
                    for (QName topicUsed : a.getEventAction().getTopic()) {
                        for (String publisher : a.getEventAction().getPublishDestination()) {
                            Notify notify = WSNHelper.createNotification((String)publisher, (String)this.producerAddress, (QName)topicUsed, (Object)doc);
                            Document requestResultEvent = SOAPSender.createSOAPMessageRequest((Document)Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify));
                            LOG.finest("************ SEND COMPLEX EVENT FROM CEP: \n" + XMLPrettyPrinter.prettyPrint((Document)requestResultEvent));
                            this.sender.sendSoapRequest(requestResultEvent, publisher, null);
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
            }
            LOG.severe("Type of action do not taken account: " + a.getType());
        }
    }
}

