/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.rules;

import com.izforge.izpack.adaptator.IXMLElement;
import com.izforge.izpack.rules.Condition;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.Debug;

public class OrCondition
extends Condition {
    private static final long serialVersionUID = 8341350377205144199L;
    protected Condition leftoperand;
    protected Condition rightoperand;

    public OrCondition() {
    }

    public OrCondition(Condition condition, Condition condition2) {
        this.leftoperand = condition;
        this.leftoperand.setInstalldata(this.installdata);
        this.rightoperand = condition2;
        this.rightoperand.setInstalldata(this.installdata);
    }

    public void readFromXML(IXMLElement iXMLElement) {
        try {
            if (iXMLElement.getChildrenCount() != 2) {
                Debug.log("or-condition needs two conditions as operands");
                return;
            }
            this.leftoperand = RulesEngine.analyzeCondition(iXMLElement.getChildAtIndex(0));
            this.rightoperand = RulesEngine.analyzeCondition(iXMLElement.getChildAtIndex(1));
        }
        catch (Exception exception) {
            Debug.log("missing element in or-condition");
        }
    }

    public boolean isTrue() {
        if (this.leftoperand == null || this.rightoperand == null) {
            Debug.trace("Operands of condition " + this.id + " not initialized correctly.");
            return false;
        }
        this.leftoperand.setInstalldata(this.installdata);
        this.rightoperand.setInstalldata(this.installdata);
        return this.leftoperand.isTrue() || this.rightoperand.isTrue();
    }

    public String getDependenciesDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.id);
        stringBuffer.append(" depends on:<ul><li>");
        stringBuffer.append(this.leftoperand.getDependenciesDetails());
        stringBuffer.append("</li> OR <li>");
        stringBuffer.append(this.rightoperand.getDependenciesDetails());
        stringBuffer.append("</li></ul>");
        return stringBuffer.toString();
    }

    public void makeXMLData(IXMLElement iXMLElement) {
        IXMLElement iXMLElement2 = RulesEngine.createConditionElement(this.leftoperand, iXMLElement);
        this.leftoperand.makeXMLData(iXMLElement2);
        iXMLElement.addChild(iXMLElement2);
        IXMLElement iXMLElement3 = RulesEngine.createConditionElement(this.rightoperand, iXMLElement);
        this.rightoperand.makeXMLData(iXMLElement3);
        iXMLElement.addChild(iXMLElement3);
    }
}

