/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter.noise;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;
import org.jvnet.substance.painter.noise.NoiseFilter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.PerlinNoiseGenerator;
import org.jvnet.substance.utils.SubstanceColorUtilities;

public class NoiseFactory {
    public static BufferedImage getNoiseImage(SubstanceTheme theme1, SubstanceTheme theme2, int width, int height, double xFactor, double yFactor, boolean hasConstantZ, NoiseFilter noiseFilter, boolean toBlur, boolean isPreview) {
        Color c1_1 = SubstanceColorUtilities.getWatermarkDarkColor(theme1);
        Color c2_1 = SubstanceColorUtilities.getWatermarkStampColor(theme1);
        Color c3_1 = SubstanceColorUtilities.getWatermarkLightColor(theme1);
        Color c1_2 = SubstanceColorUtilities.getWatermarkDarkColor(theme2);
        Color c2_2 = SubstanceColorUtilities.getWatermarkStampColor(theme2);
        Color c3_2 = SubstanceColorUtilities.getWatermarkLightColor(theme2);
        Color c1 = SubstanceColorUtilities.getInterpolatedColor(c1_1, c1_2, 0.1);
        Color c2 = SubstanceColorUtilities.getInterpolatedColor(c2_1, c2_2, 0.5);
        Color c3 = SubstanceColorUtilities.getInterpolatedColor(c3_1, c3_2, 0.9);
        if (isPreview) {
            c1 = SubstanceColorUtilities.getAlphaColor(c1, 255);
            c2 = SubstanceColorUtilities.getAlphaColor(c2, 255);
            c3 = SubstanceColorUtilities.getAlphaColor(c3, 255);
        }
        BufferedImage dst = new BufferedImage(width, height, 2);
        int[] dstBuffer = ((DataBufferInt)dst.getRaster().getDataBuffer()).getData();
        double m2 = xFactor * (double)width * xFactor * (double)width + yFactor * (double)height * yFactor * (double)height;
        int pos = 0;
        for (int j = 0; j < height; ++j) {
            double jj = yFactor * (double)j;
            for (int i = 0; i < width; ++i) {
                double ii = xFactor * (double)i;
                double z = hasConstantZ ? 1.0 : Math.sqrt(m2 - ii * ii - jj * jj);
                double noise = 0.5 + 0.5 * PerlinNoiseGenerator.noise(ii, jj, z);
                if (noiseFilter != null) {
                    noise = noiseFilter.apply(i, j, z, noise);
                }
                dstBuffer[pos++] = SubstanceColorUtilities.getInterpolatedRGB(c3, c1, 2.0 * noise);
            }
        }
        if (toBlur) {
            ConvolveOp convolve = new ConvolveOp(new Kernel(3, 3, new float[]{0.08f, 0.08f, 0.08f, 0.08f, 0.38f, 0.08f, 0.08f, 0.08f, 0.08f}), 1, null);
            dst = convolve.filter(dst, null);
        }
        return dst;
    }
}

