/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.gui;

import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.petalslink.easiestdemo.client.model.api.esb.Node;
import org.petalslink.easiestdemo.client.model.api.ws.MockBinding;
import org.petalslink.easiestdemo.client.model.api.ws.MockEndpoint;
import org.petalslink.easiestdemo.client.model.api.ws.MockOperation;
import org.petalslink.easiestdemo.client.model.api.ws.MockService;

public class TreeRegistryCellRenderer
extends DefaultTreeCellRenderer {
    private static final ImageIcon nodeIcon = TreeRegistryCellRenderer.createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/node.png"));
    private static final ImageIcon serviceIcon = TreeRegistryCellRenderer.createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/service.png"));
    private static final ImageIcon endpointIcon = TreeRegistryCellRenderer.createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/endpoint.png"));
    private static final ImageIcon interfaceIcon = TreeRegistryCellRenderer.createImageIcon(Thread.currentThread().getContextClassLoader().getResource("images/interface.png"));
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof Node) {
            Node val = (Node)value;
            this.setText(val.getQName().getLocalPart() + " (" + val.getQName().getNamespaceURI() + ")");
            this.setIcon(nodeIcon);
            this.setToolTipText("This is a node.");
        } else if (value instanceof MockService) {
            MockService val = (MockService)value;
            this.setText(val.getQName().getLocalPart() + " (" + val.getQName().getNamespaceURI() + ")");
            this.setIcon(serviceIcon);
            this.setToolTipText("This is a service.");
        } else if (value instanceof MockEndpoint) {
            this.setText(((MockEndpoint)value).getName());
            this.setIcon(endpointIcon);
            this.setToolTipText("This is a endpoint.");
        } else if (value instanceof MockBinding) {
            this.setText(((MockBinding)value).getQName().getLocalPart() + " (" + ((MockBinding)value).getQName().getNamespaceURI() + ")");
            this.setIcon(interfaceIcon);
            this.setToolTipText("This is a binding.");
        } else if (value instanceof MockOperation) {
            this.setText(((MockOperation)value).getName().toString());
        } else {
            this.setText(value.toString());
        }
        return this;
    }

    private static ImageIcon createImageIcon(URL imgURL) {
        ImageIcon img = new ImageIcon(imgURL);
        return img;
    }
}

