/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.model.impl.ws;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easywsdl11.api.element.BindingOperation;
import com.ebmwebsourcing.soapbinding11.api.SoapBindingHelper;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import javax.xml.namespace.QName;
import org.jdom.JDOMException;
import org.petalslink.easiestdemo.client.Constants;
import org.petalslink.easiestdemo.client.model.api.ws.MockBinding;
import org.petalslink.easiestdemo.client.model.api.ws.MockOperation;
import org.w3c.dom.Document;

public class MockOperationImpl
implements MockOperation {
    private org.petalslink.abslayer.service.api.BindingOperation bop;
    private MockBinding b;
    private String soapAction;
    private String request;
    private PatternType pattern;
    private static int cpt = 0;

    public MockOperationImpl(MockBinding b, org.petalslink.abslayer.service.api.BindingOperation bop) throws SOAPException {
        this.b = b;
        this.bop = bop;
        this.pattern = this.bop.getBindingOperationOutput() == null ? PatternType.IN_ONLY : PatternType.IN_OUT;
        this.soapAction = "\"" + SoapBindingHelper.getSoapOperation((BindingOperation)((BindingOperation)bop.getModel())).getSoapAction() + "\"";
        this.request = this.bop != null && this.bop.findOperation() != null && this.bop.findOperation().getInput() != null && this.bop.findOperation().getInput().getElement() != null && this.bop.findOperation().getInput().getElement().inferQName() != null && this.bop.findOperation().getInput().getElement().inferQName().equals(Constants.WS_SUBSCRIBE_ELEMENT) ? this.generateSubscribeRequest() : this.printRequest();
    }

    private String generateSubscribeRequest() {
        QName topicUsed = new QName("http://docs.oasis-open.org/wsdm/2004/12/mows/wsdm-mows-events.xml", "MetricsCapability", "res");
        Subscribe payload = null;
        String res = null;
        try {
            if (this.getBinding().getEndpoint().getName().toLowerCase().contains("wsdm")) {
                payload = WSNHelper.createSubscription((String)this.generateNotificationServerAddress(), (QName)topicUsed, (QName[])new QName[0]);
            } else {
                QName topicToDefine = new QName("http://defineTopicNamespace", "defineTopic");
                payload = WSNHelper.createSubscription((String)this.generateNotificationServerAddress(), (QName)topicToDefine, (QName[])new QName[0]);
            }
            res = XMLPrettyPrinter.prettyPrint((Document)SOAPSender.createSOAPMessageRequest((Document)Wsnb4ServUtils.getWsnbWriter().writeSubscribeAsDOM(payload)));
        }
        catch (WsnbException e) {
            e.printStackTrace();
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
        catch (JDOMException e) {
            e.printStackTrace();
        }
        return res;
    }

    private String generateNotificationServerAddress() {
        String port = String.valueOf(9800 + cpt);
        ++cpt;
        String res = "http://localhost:" + port + "/" + this.b.getEndpoint().getName();
        return res;
    }

    @Override
    public MockBinding getBinding() {
        return this.b;
    }

    @Override
    public String getName() {
        return this.bop.getName();
    }

    public String printRequest() throws SOAPException {
        Document doc = this.b.getEndpoint().getService().getSOAPMessageGenerator().generateSoapRequest(this.bop);
        return XMLPrettyPrinter.prettyPrint((Document)doc);
    }

    @Override
    public String getRequest() {
        return this.request;
    }

    @Override
    public String getSoapAction() {
        return this.soapAction;
    }

    @Override
    public void setRequest(String req) {
        this.request = req;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public PatternType getPattern() {
        return this.pattern;
    }

    @Override
    public void setPattern(PatternType pattern) {
        this.pattern = pattern;
    }
}

