/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.client.topology.menu;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAException;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImpl;
import com.petalslink.easycommons.explorer.ExplorerFrame;
import easybox.easyesb.petalslink.com.admin.model.datatype._1.EJaxbPropertyType;
import easyesb.petalslink.com.data.admin._1.AddProperties;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.logging.Logger;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.petalslink.easiestdemo.client.WSOUIClient;
import org.petalslink.easiestdemo.client.WSOUIClientException;
import org.petalslink.easiestdemo.client.model.api.Registry;
import org.petalslink.easiestdemo.client.topology.EsbG;
import org.petalslink.easiestdemo.client.topology.ExternalClientEndpointG;
import org.petalslink.easiestdemo.client.topology.ExternalProviderEndpointG;
import org.petalslink.easiestdemo.client.topology.InternalClientProxyEndpointG;
import org.petalslink.easiestdemo.client.topology.InternalProviderProxyEndpointG;
import org.petalslink.easiestdemo.client.topology.menu.action.AddNeighBourNodeFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.BindWSToNodeFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.CallWebServiceFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.ConnectMonitoring2EsbFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.CreateGovFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.CreateNodeFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.GetStateFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.ImportGovFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.ImportNodeFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.MoveEndpointToNodeFrame;
import org.petalslink.easiestdemo.client.topology.menu.action.StoreBpelFrame;

public class MenuMouseTopology
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private static Logger LOG = Logger.getLogger(MenuMouseTopology.class.getName());
    private JMenuItem jMenuItemCreateNode;
    private JMenuItem jMenuItemImportNode;
    private JMenuItem jMenuItemCreateMonitoring;
    private JMenuItem jMenuItemImportMonitoring;
    private JMenuItem jMenuItemCreateGov;
    private JMenuItem jMenuItemImportGov;
    private JMenuItem jMenuItemStoreBpel;
    private JMenuItem jMenuItemBindWSToNode;
    private JMenuItem jMenuItemMoveEndpointToNode;
    private JMenuItem jMenuItemAddNeighBourNode;
    private JMenuItem jMenuItemGetStateNode;
    private JMenuItem jMenuItemCallWebService;
    private JMenuItem jMenuItemExploreNode;
    private JMenuItem jMenuItemRefresh;
    private JMenuItem jMenuItemStopSynchronization;
    private WSOUIClient client;
    private Registry registry;
    private EsbG esbSelected = null;
    private InternalProviderProxyEndpointG internalProviderProxyEndpointSelected = null;
    private InternalClientProxyEndpointG internalClientProxyEndpointSelected = null;
    private ExternalProviderEndpointG externalProviderEndpointSelected = null;
    private ExternalClientEndpointG externalClientEndpointSelected = null;

    public MenuMouseTopology(WSOUIClient client) {
        this.initComponents();
        this.client = client;
        this.registry = this.client.getRegistry();
    }

    public void setSelectedItem(Object item) {
        this.esbSelected = null;
        this.internalProviderProxyEndpointSelected = null;
        this.internalClientProxyEndpointSelected = null;
        this.externalProviderEndpointSelected = null;
        this.externalClientEndpointSelected = null;
        if (item instanceof EsbG) {
            this.esbSelected = (EsbG)item;
        } else if (item instanceof InternalProviderProxyEndpointG) {
            this.internalProviderProxyEndpointSelected = (InternalProviderProxyEndpointG)item;
        } else if (item instanceof InternalClientProxyEndpointG) {
            this.internalClientProxyEndpointSelected = (InternalClientProxyEndpointG)item;
        } else if (item instanceof ExternalProviderEndpointG) {
            this.externalProviderEndpointSelected = (ExternalProviderEndpointG)item;
        } else if (item instanceof ExternalClientEndpointG) {
            this.externalClientEndpointSelected = (ExternalClientEndpointG)item;
        }
        this.refresh();
    }

    public void refresh() {
        this.jMenuItemCreateNode.setEnabled(false);
        this.jMenuItemImportNode.setEnabled(false);
        this.jMenuItemCreateGov.setEnabled(false);
        this.jMenuItemImportGov.setEnabled(false);
        this.jMenuItemStoreBpel.setEnabled(false);
        this.jMenuItemBindWSToNode.setEnabled(false);
        this.jMenuItemMoveEndpointToNode.setEnabled(false);
        this.jMenuItemAddNeighBourNode.setEnabled(false);
        this.jMenuItemGetStateNode.setEnabled(false);
        this.jMenuItemCallWebService.setEnabled(false);
        this.jMenuItemExploreNode.setEnabled(false);
        this.jMenuItemRefresh.setEnabled(false);
        this.jMenuItemStopSynchronization.setEnabled(false);
        if (this.esbSelected != null) {
            this.jMenuItemStoreBpel.setEnabled(true);
            this.jMenuItemAddNeighBourNode.setEnabled(true);
            this.jMenuItemGetStateNode.setEnabled(true);
            this.jMenuItemExploreNode.setEnabled(true);
            this.jMenuItemRefresh.setEnabled(true);
            if (this.esbSelected.getModel().isMonitoringNode()) {
                this.jMenuItemStopSynchronization.setEnabled(true);
            }
        } else if (this.internalProviderProxyEndpointSelected != null) {
            this.jMenuItemMoveEndpointToNode.setEnabled(true);
        } else if (this.internalClientProxyEndpointSelected != null) {
            this.jMenuItemMoveEndpointToNode.setEnabled(true);
        } else if (this.externalProviderEndpointSelected != null) {
            this.jMenuItemCallWebService.setEnabled(true);
            this.jMenuItemBindWSToNode.setEnabled(true);
        } else if (this.externalClientEndpointSelected != null) {
            this.jMenuItemCallWebService.setEnabled(true);
        } else if (this.registry.getGovNode() == null) {
            this.jMenuItemCreateGov.setEnabled(true);
            this.jMenuItemImportGov.setEnabled(true);
            this.jMenuItemCreateNode.setEnabled(true);
            this.jMenuItemImportNode.setEnabled(true);
            this.jMenuItemCreateMonitoring.setEnabled(true);
            this.jMenuItemImportMonitoring.setEnabled(true);
        } else {
            this.jMenuItemCreateNode.setEnabled(true);
            this.jMenuItemImportNode.setEnabled(true);
            this.jMenuItemCreateMonitoring.setEnabled(true);
            this.jMenuItemImportMonitoring.setEnabled(true);
        }
    }

    private void initComponents() {
        this.jMenuItemCreateNode = new JMenuItem();
        this.jMenuItemImportNode = new JMenuItem();
        this.jMenuItemCreateMonitoring = new JMenuItem();
        this.jMenuItemImportMonitoring = new JMenuItem();
        this.jMenuItemCreateGov = new JMenuItem();
        this.jMenuItemImportGov = new JMenuItem();
        this.jMenuItemStoreBpel = new JMenuItem();
        this.jMenuItemBindWSToNode = new JMenuItem();
        this.jMenuItemMoveEndpointToNode = new JMenuItem();
        this.jMenuItemAddNeighBourNode = new JMenuItem();
        this.jMenuItemGetStateNode = new JMenuItem();
        this.jMenuItemCallWebService = new JMenuItem();
        this.jMenuItemExploreNode = new JMenuItem();
        this.jMenuItemRefresh = new JMenuItem();
        this.jMenuItemStopSynchronization = new JMenuItem();
        this.setComponentPopupMenu(this);
        this.jMenuItemCreateNode.setText("Create Node");
        this.jMenuItemCreateNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuMouseTopology.this.jMenuItemCreateNodeActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemCreateNode);
        this.jMenuItemImportNode.setText("Import Node");
        this.jMenuItemImportNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuMouseTopology.this.jMenuItemImportNodeActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemImportNode);
        this.jMenuItemCreateMonitoring.setText("Create Monitoring");
        this.jMenuItemCreateMonitoring.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuMouseTopology.this.jMenuItemCreateMonitoringActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemCreateMonitoring);
        this.jMenuItemImportMonitoring.setText("Import Monitoring");
        this.jMenuItemImportMonitoring.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuMouseTopology.this.jMenuItemImportMonitoringActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemImportMonitoring);
        this.jMenuItemCreateGov.setText("Create Governance");
        this.jMenuItemCreateGov.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuMouseTopology.this.jMenuItemCreateGovActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemCreateGov);
        this.jMenuItemImportGov.setText("Import Governance");
        this.jMenuItemImportGov.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuMouseTopology.this.jMenuItemImportGovActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemImportGov);
        this.jMenuItemStoreBpel.setText("Store Bpel");
        this.jMenuItemStoreBpel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuMouseTopology.this.jMenuItemStoreBpelActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemStoreBpel);
        this.jMenuItemBindWSToNode.setText("Bind Web Service to Node");
        this.jMenuItemBindWSToNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuMouseTopology.this.jMenuItemBindWSToNodeActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemBindWSToNode);
        this.jMenuItemMoveEndpointToNode.setText("Move Endpoint to Node");
        this.jMenuItemMoveEndpointToNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuMouseTopology.this.jMenuItemMoveEndpointToNodeActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemMoveEndpointToNode);
        this.jMenuItemAddNeighBourNode.setText("Add NeighBour Node");
        this.jMenuItemAddNeighBourNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuMouseTopology.this.jMenuItemAddNeighBourNodeActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemAddNeighBourNode);
        this.jMenuItemGetStateNode.setText("Get State of Node");
        this.jMenuItemGetStateNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuMouseTopology.this.jMenuItemGetStateNodeActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemGetStateNode);
        this.jMenuItemCallWebService.setText("Call Web Service");
        this.jMenuItemCallWebService.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuMouseTopology.this.jMenuItemCallWebServiceActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemCallWebService);
        this.jMenuItemExploreNode.setText("Explore Node");
        this.jMenuItemExploreNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuMouseTopology.this.jMenuItemExploreNodeActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemExploreNode);
        this.jMenuItemRefresh.setText("Refresh node");
        this.jMenuItemRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuMouseTopology.this.jMenuItemRefreshActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemRefresh);
        this.jMenuItemStopSynchronization.setText("Stop synchronization");
        this.jMenuItemStopSynchronization.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuMouseTopology.this.jMenuItemStopSynchronizationActionPerformed(evt);
            }
        });
        this.add(this.jMenuItemStopSynchronization);
    }

    protected void jMenuItemBindWSToNodeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        BindWSToNodeFrame bindWS = new BindWSToNodeFrame(this.client, this.externalProviderEndpointSelected.getMockEndpoint());
        bindWS.setVisible(true);
    }

    protected void jMenuItemImportGovActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        ImportGovFrame importGov = new ImportGovFrame(this.client);
        importGov.setVisible(true);
    }

    protected void jMenuItemCreateGovActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        CreateGovFrame createGov = new CreateGovFrame(this.client);
        createGov.setVisible(true);
    }

    protected void jMenuItemStopSynchronizationActionPerformed(ActionEvent evt) {
        try {
            this.setVisible(false);
            AdminClientImpl monitoringClient = new AdminClientImpl(this.esbSelected.getModel().getAdministrationServiceDescription().getDocumentBaseURI().toURL().toString());
            AddProperties monitoringProperties = new AddProperties();
            EJaxbPropertyType esbConnexionProperty = new EJaxbPropertyType();
            esbConnexionProperty.setKey("esb-connection");
            esbConnexionProperty.setValue("");
            monitoringProperties.getProperty().add(esbConnexionProperty);
            monitoringClient.addProperties(monitoringProperties);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Explore Node Interrupted", 0);
        }
        catch (ManagementException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Explore Node Interrupted", 0);
        }
    }

    protected void jMenuItemRefreshActionPerformed(ActionEvent evt) {
        try {
            this.setVisible(false);
            this.registry.getStateOfNode(this.esbSelected.getModel());
            this.client.refreshAll();
        }
        catch (WSOUIClientException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Explore Node Interrupted", 0);
        }
    }

    protected void jMenuItemConnectMonitoringToEsbNodeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        ConnectMonitoring2EsbFrame connectMonitoring = new ConnectMonitoring2EsbFrame(this.client, this.esbSelected);
        connectMonitoring.setVisible(true);
    }

    protected void jMenuItemExploreNodeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        try {
            if (this.esbSelected.getModel().getModel() == null) {
                throw new SCAException("Impossible to explore an imported node, you must create a node");
            }
            ExplorerFrame exploreFrame = new ExplorerFrame(this.esbSelected.getModel().getModel().getComponent());
            exploreFrame.setVisible(true);
        }
        catch (SCAException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Explore Node Interrupted", 0);
        }
    }

    protected void jMenuItemCallWebServiceActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        CallWebServiceFrame callWebService = new CallWebServiceFrame(this.client, this.externalClientEndpointSelected);
        callWebService.setVisible(true);
    }

    protected void jMenuItemGetStateNodeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        GetStateFrame getState = new GetStateFrame(this.client, this.esbSelected);
        getState.setVisible(true);
    }

    protected void jMenuItemAddNeighBourNodeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        AddNeighBourNodeFrame addNeighBourNode = new AddNeighBourNodeFrame(this.client, this.esbSelected);
        addNeighBourNode.setVisible(true);
    }

    private void jMenuItemCreateNodeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        CreateNodeFrame createNode = new CreateNodeFrame(this.client, false);
        createNode.setVisible(true);
    }

    private void jMenuItemImportNodeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        ImportNodeFrame importNode = new ImportNodeFrame(this.client, false);
        importNode.setVisible(true);
    }

    private void jMenuItemCreateMonitoringActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        CreateNodeFrame createNode = new CreateNodeFrame(this.client, true);
        createNode.setVisible(true);
    }

    private void jMenuItemImportMonitoringActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        ImportNodeFrame importNode = new ImportNodeFrame(this.client, false);
        importNode.setVisible(true);
    }

    private void jMenuItemStoreBpelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        StoreBpelFrame storeBpel = new StoreBpelFrame(this.client, this.esbSelected);
        storeBpel.setVisible(true);
    }

    private void jMenuItemMoveEndpointToNodeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        if (this.internalProviderProxyEndpointSelected != null) {
            MoveEndpointToNodeFrame moveEndpointToNode = new MoveEndpointToNodeFrame(this.client, this.internalProviderProxyEndpointSelected);
            moveEndpointToNode.setVisible(true);
        } else if (this.internalClientProxyEndpointSelected != null) {
            MoveEndpointToNodeFrame moveEndpointToNode = new MoveEndpointToNodeFrame(this.client, this.internalClientProxyEndpointSelected);
            moveEndpointToNode.setVisible(true);
        }
    }
}

