/*
 * Decompiled with CFR 0.152.
 */
package petals.ow2.org.demo.travelagency.hotel;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.logging.LogManager;
import javax.xml.ws.Endpoint;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.easiestdemo.wsoui.core.WSOUIException;
import org.petalslink.easiestdemo.wsoui.provided.AbstractImplementationManager;
import org.petalslink.easiestdemo.wsoui.provided.ProviderConfiguration;
import petals.ow2.org.demo.travelagency.hotel.HotelImplementationManager;
import petals.ow2.org.demo.travelagency.hotel.HotelTestImplementation;
import petals.ow2.org.demo.travelagency.hotel.Hotel_ExchangeProcessor;
import petals.ow2.org.demo.travelagency.hotel.Hotel_WSOUIService;

public class Hotel_WSOUIServer {
    private static final String LOGGER_FILE = "/logger.properties";
    private Endpoint endpointFor_Hotel = null;
    private ProviderConfiguration confEndpointFor_Hotel = null;
    private AbstractImplementationManager<?> im = null;

    public ProviderConfiguration createDefaultProviderConfigurationFor_Hotel() {
        ProviderConfiguration conf = new ProviderConfiguration();
        conf.setEndpointAddress("http://localhost:3456/Hotel");
        conf.setImage(Thread.currentThread().getContextClassLoader().getResource("hotel/hotel.jpg"));
        conf.setPosition(ProviderConfiguration.PositionType.SOUTH_EAST);
        conf.setActiveGui(false);
        return conf;
    }

    public ProviderConfiguration getProviderConfigurationFor_Hotel() {
        if (this.confEndpointFor_Hotel == null) {
            this.confEndpointFor_Hotel = this.createDefaultProviderConfigurationFor_Hotel();
        }
        return this.confEndpointFor_Hotel;
    }

    public void start() throws WSOUIException {
        this.confEndpointFor_Hotel = this.getProviderConfigurationFor_Hotel();
        this.im = new HotelImplementationManager(new HotelTestImplementation(new Hotel_ExchangeProcessor()), Hotel_WSOUIService.getWSDL_LOCATION(), this.confEndpointFor_Hotel);
        this.endpointFor_Hotel = Endpoint.publish((String)this.confEndpointFor_Hotel.getEndpointAddress(), this.im);
        System.out.println("Service deploy at: " + this.confEndpointFor_Hotel.getEndpointAddress() + "?wsdl");
        System.out.println("Service Configuration: " + this.confEndpointFor_Hotel);
    }

    public void stop() {
        if (this.endpointFor_Hotel != null) {
            this.endpointFor_Hotel.stop();
        }
    }

    public Description getDescription() {
        return this.im.getDescription();
    }

    public static void main(String[] args) throws Exception {
        Hotel_WSOUIServer provider = new Hotel_WSOUIServer();
        provider.start();
        boolean gui = false;
        if (args.length > 0) {
            System.out.print("Commands args: ");
            for (int i = 0; i < args.length; ++i) {
                System.out.print(args[i]);
            }
            System.out.println();
            gui = Boolean.parseBoolean(args[0]);
            System.out.println("gui: " + gui);
        }
        provider.getProviderConfigurationFor_Hotel().setActiveGui(gui);
        System.out.println("Server ready...");
    }

    static {
        try {
            InputStream inputStream = null;
            File logger = new File("./logger.properties");
            inputStream = logger.exists() ? new FileInputStream(logger) : Hotel_WSOUIServer.class.getClass().getResourceAsStream(LOGGER_FILE);
            if (inputStream != null) {
                LogManager.getLogManager().readConfiguration(inputStream);
                inputStream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't initialize logging properly", e);
        }
    }
}

