/*
 * Decompiled with CFR 0.152.
 */
package org.petalslink.easiestdemo.sdk;

import java.io.File;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.petalslink.easiestdemo.sdk.SDKException;
import org.petalslink.easiestdemo.sdk.SDKService;
import org.petalslink.easiestdemo.sdk.core.POMGenerator;
import org.petalslink.easiestdemo.sdk.util.FileUtil;

public class SDKServiceTest {
    @Before
    public void setUp() {
        File shDir = new File("./src/main/resources/scripts");
        if (shDir.exists()) {
            File[] files = shDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().endsWith(".sh")) continue;
                System.out.println(files[i].getAbsolutePath() + " set Executable...");
                files[i].setExecutable(true);
            }
        }
    }

    @Test
    public void createNewProject() throws SDKException {
        SDKService sdk = new SDKService();
        sdk.createNewProject("http://www.petalslink.org", "MyBpelProcess", new File("./target/test"), true);
        Assert.assertTrue((boolean)new File("./target/test/mybpelprocess/pom.xml").exists());
    }

    @Test
    public void createProjectFromExistingBpel() throws Exception {
        SDKService sdk = new SDKService();
        sdk.createProjectFromBpel(new File("src/test/resources/nrbc/nrbc.bpel").toURI().toURL(), new File("./target/test"));
        Assert.assertNotNull((Object)FileUtil.findFilesInDirectory((String)"nrbc.bpel", (File)new File("./target/test")));
        Assert.assertEquals((int)1, (int)FileUtil.findFilesInDirectory((String)"nrbc.bpel", (File)new File("./target/test")).length);
    }

    @Test
    public void createHierarchicalProjectFromExistingBpel() throws Exception {
        SDKService sdk = new SDKService();
        sdk.createProjectFromBpel(new File("src/test/resources/travelagency/travelagency.bpel").toURI().toURL(), new File("./target/test"));
        Assert.assertNotNull((Object)FileUtil.findFilesInDirectory((String)"travelagency.bpel", (File)new File("./target/test")));
        Assert.assertNotNull((Object)FileUtil.findFilesInDirectory((String)"car", (File)new File("./target/test")));
        Assert.assertEquals((int)1, (int)FileUtil.findFilesInDirectory((String)"travelagency.bpel", (File)new File("./target/test")).length);
    }

    @Test
    public void importProject() throws SDKException {
        SDKService sdk = new SDKService();
        sdk.setScriptPath("/src/main/resources/scripts");
        sdk.createNewProject("http://www.petalslink.org", "MyBpelProcess", new File("./target/test"), true);
        int res = sdk.importProjectIntoEclipse(new File("./target/test/mybpelprocess"), null);
        Assert.assertEquals((int)0, (int)res);
        Assert.assertTrue((boolean)new File("./target/test/mybpelprocess/.project").exists());
    }

    @Test
    public void compileProject() throws Exception {
        SDKService sdk = new SDKService();
        sdk.setScriptPath("/src/main/resources/scripts");
        sdk.createNewProject("http://www.petalslink.org", "MyBpelProcess", new File("./target/test"), true);
        int res = sdk.compileProject(new File("./target/test/mybpelprocess"), null);
        Assert.assertTrue((boolean)new File("./target/test/mybpelprocess/target").exists());
    }

    @Test
    public void testFindMavenWsouiVersion() {
        String mavenWsouiPluginVersion = "1.0-SNAPSHOT";
        try {
            POMGenerator pomGenerator = new POMGenerator(null, null, null, null);
            String lastVersion = pomGenerator.getVersionInInitSDKPropertiesFile();
            if (lastVersion != null) {
                mavenWsouiPluginVersion = lastVersion;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to retrieve Maven Wsoui plugin latest version ... taking 1.0-SNAPSHOT one instead.");
            Assert.fail((String)("Failed to retrieve Maven Wsoui plugin latest version ... taking 1.0-SNAPSHOT one instead. " + e.getLocalizedMessage()));
        }
        System.out.println("MAVEN WSOUI LAST VERSION : " + mavenWsouiPluginVersion);
    }
}

