/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.api;

import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easybox.api.TestRuntimeException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractXmlObjectTest {
    private static final Map<String, Map<String, Object>> EXPECTED_OBJECTS_POOLS = new HashMap<String, Map<String, Object>>();

    protected AbstractXmlObjectTest(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
    }

    protected static void addExpectedObject(String expectedObjectsPoolKey, String expectedObjectKey, Object expectedObject) {
        Map<String, Object> expectedObjectsPool;
        if (!EXPECTED_OBJECTS_POOLS.containsKey(expectedObjectsPoolKey)) {
            EXPECTED_OBJECTS_POOLS.put(expectedObjectsPoolKey, new HashMap());
        }
        if ((expectedObjectsPool = EXPECTED_OBJECTS_POOLS.get(expectedObjectsPoolKey)).containsKey(expectedObjectKey)) {
            throw new TestRuntimeException(String.format("Duplicate expected object key '%s'.", expectedObjectKey));
        }
        expectedObjectsPool.put(expectedObjectKey, expectedObject);
    }

    protected static <X> X getExpectedObject(String expectedObjectsPoolKey, Class<X> xmlObjectInterfaceClass, String key) {
        Map<String, Object> expectedObjectsPool = EXPECTED_OBJECTS_POOLS.get(expectedObjectsPoolKey);
        assert (expectedObjectsPool != null) : String.format("No such expected objects pool '%s'.", expectedObjectsPoolKey);
        return xmlObjectInterfaceClass.cast(expectedObjectsPool.get(key));
    }

    protected static <X> X[] getExpectedObjects(String expectedObjectsPoolKey, Class<X> xmlObjectInterfaceClass, String ... keys) {
        Object[] expectedXmlObjects = (Object[])Array.newInstance(xmlObjectInterfaceClass, keys.length);
        int i = 0;
        for (String key : keys) {
            expectedXmlObjects[i++] = AbstractXmlObjectTest.getExpectedObject(expectedObjectsPoolKey, xmlObjectInterfaceClass, key);
        }
        return expectedXmlObjects;
    }
}

