/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.api;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public final class XmlObjectHierarchyTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_NATURAL_CHILDREN = "expectedNaturalChildren";
    public static final String EXPECTED_ANCESTORS = "expectedAncestors";
    public static final String EXPECTED_DESCENDANTS = "expectedDescendants";
    public static final String EXPECTED_FOLLOWING = "expectedFollowing";
    public static final String EXPECTED_FOLLOWING_SIBLINGS = "expectedFollowingSiblings";
    public static final String EXPECTED_PRECEDING = "expectedPreceding";
    public static final String EXPECTED_PRECEDING_OR_ANCESTOR = "expectedPrecedingOrAncestor";
    public static final String EXPECTED_PRECEDING_SIBLINGS = "expectedPrecedingSiblings";

    public XmlObjectHierarchyTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetXmlObjectParent() {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlObject[] ancestors = (XmlObject[])this.getTestData(EXPECTED_ANCESTORS);
        XmlObject expectedParent = ancestors.length == 0 ? null : ancestors[ancestors.length - 1];
        Assert.assertEquals((Object)expectedParent, (Object)xmlObject.getXmlObjectParent());
    }

    @Test
    public void testGetXmlObjectAncestors() {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        Assert.assertArrayEquals((Object[])((XmlObjectNode[])this.getTestData(EXPECTED_ANCESTORS)), (Object[])xmlObject.getXmlObjectAncestors());
    }

    @Test
    public void testGetXmlObjectDescendants() {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        Assert.assertArrayEquals((Object[])((XmlObjectNode[])this.getTestData(EXPECTED_DESCENDANTS)), (Object[])xmlObject.getXmlObjectDescendants());
    }

    @Test
    public void testGetXmlObjectFollowing() {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        Assert.assertArrayEquals((Object[])((XmlObjectNode[])this.getTestData(EXPECTED_FOLLOWING)), (Object[])xmlObject.getXmlObjectFollowing());
    }

    @Test
    public void testGetXmlObjectFollowingSiblings() {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        Assert.assertArrayEquals((Object[])((XmlObjectNode[])this.getTestData(EXPECTED_FOLLOWING_SIBLINGS)), (Object[])xmlObject.getXmlObjectFollowingSiblings());
    }

    @Test
    public void testGetXmlObjectFollowingSibling() {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlObjectNode[] followingSiblings = (XmlObjectNode[])this.getTestData(EXPECTED_FOLLOWING_SIBLINGS);
        XmlObjectNode expectedXmlObject = followingSiblings.length == 0 ? null : followingSiblings[0];
        Assert.assertEquals((Object)expectedXmlObject, (Object)xmlObject.getXmlObjectFollowingSibling());
    }

    @Test
    public void testGetXmlObjectPrecedingSiblings() {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        Assert.assertArrayEquals((Object[])((XmlObjectNode[])this.getTestData(EXPECTED_PRECEDING_SIBLINGS)), (Object[])xmlObject.getXmlObjectPrecedingSiblings());
    }

    @Test
    public void testGetXmlObjectPrecedingSibling() {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlObjectNode[] precedingSiblings = (XmlObjectNode[])this.getTestData(EXPECTED_PRECEDING_SIBLINGS);
        XmlObjectNode expectedXmlObject = precedingSiblings.length == 0 ? null : precedingSiblings[precedingSiblings.length - 1];
        Assert.assertEquals((Object)expectedXmlObject, (Object)xmlObject.getXmlObjectPrecedingSibling());
    }

    @Test
    public void testGetXmlObjectPreceding() {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        Assert.assertArrayEquals((Object[])((XmlObjectNode[])this.getTestData(EXPECTED_PRECEDING)), (Object[])xmlObject.getXmlObjectPreceding());
    }

    @Test
    public void testGetXmlObjectPrecedingOrAncestor() {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        Assert.assertArrayEquals((Object[])((XmlObjectNode[])this.getTestData(EXPECTED_PRECEDING_OR_ANCESTOR)), (Object[])xmlObject.getXmlObjectPrecedingOrAncestor());
    }

    @Test
    public void testGetXmlObjectNaturalChildren() {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        Assert.assertArrayEquals((Object[])((XmlObjectNode[])this.getTestData(EXPECTED_NATURAL_CHILDREN)), (Object[])xmlObject.getXmlObjectNaturalChildren());
    }
}

