/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.api;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class XmlObjectReaderTestSuite
extends AbstractXmlObjectTestSuite {
    private static final int TEST_BUFFER_SIZE = 65536;

    public XmlObjectReaderTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    private XmlObject roundTripReadXmlObject(XmlObject xmlObjectUnderTest, boolean readFragment, XmlObjectReader.ReadMode readMode) throws XmlObjectReadException, XmlObjectWriteException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(65536);
        XmlObjectWriter writer = this.getXmlContext().createWriter();
        writer.writeDocument(xmlObjectUnderTest, (OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        XmlObjectReader reader = this.getXmlContext().createReader();
        reader.setReadMode(readMode);
        Class interfaceClass = (Class)this.getXmlContext().getClassMetadata().get(xmlObjectUnderTest.getClass(), "implementationClassInterface");
        XmlObject roundTrippedXmlObject = readFragment ? reader.readFragment((InputStream)bais, interfaceClass) : reader.readDocument((InputStream)bais, XmlObject.class);
        return roundTrippedXmlObject;
    }

    private boolean isPossibleDocumentRoot(XmlObject xmlObject) {
        Class modelObjectClass = (Class)this.getXmlContext().getClassMetadata().get(xmlObject.getClass(), "implementationClassModelObjectClass");
        return modelObjectClass.isAnnotationPresent(XmlRootElement.class);
    }

    @Test
    public void testReadDocumentLazily() throws XmlObjectReadException, XmlObjectWriteException {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        Assume.assumeTrue((boolean)this.isPossibleDocumentRoot(xmlObject));
        XmlObject roundTrippedXmlObject = this.roundTripReadXmlObject(xmlObject, false, XmlObjectReader.ReadMode.LAZY);
        Assert.assertEquals((Object)xmlObject, (Object)roundTrippedXmlObject);
    }

    @Test
    public void testReadDocumentFully() throws XmlObjectReadException, XmlObjectWriteException {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        Assume.assumeTrue((boolean)this.isPossibleDocumentRoot(xmlObject));
        XmlObject roundTrippedXmlObject = this.roundTripReadXmlObject(xmlObject, false, XmlObjectReader.ReadMode.FULL);
        Assert.assertEquals((Object)xmlObject, (Object)roundTrippedXmlObject);
    }

    @Test
    public void testReadFragmentLazily() throws XmlObjectReadException, XmlObjectWriteException {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        Assume.assumeTrue((boolean)this.isFragmentConsistent((XmlObjectNode)xmlObject));
        XmlObject roundTrippedXmlObject = this.roundTripReadXmlObject(xmlObject, true, XmlObjectReader.ReadMode.LAZY);
        Assert.assertEquals((Object)xmlObject, (Object)roundTrippedXmlObject);
    }

    @Test
    public void testReadFragmentFully() throws XmlObjectReadException, XmlObjectWriteException {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        Assume.assumeTrue((boolean)this.isFragmentConsistent((XmlObjectNode)xmlObject));
        XmlObject roundTrippedXmlObject = this.roundTripReadXmlObject(xmlObject, true, XmlObjectReader.ReadMode.FULL);
        Assert.assertEquals((Object)xmlObject, (Object)roundTrippedXmlObject);
    }

    private boolean isFragmentConsistent(XmlObjectNode xmlObject) {
        ArrayList<XmlObjectNode> all = new ArrayList<XmlObjectNode>();
        ArrayList<XmlObjectNode> problems = new ArrayList<XmlObjectNode>();
        this.collectFragmentObjects(xmlObject, all, problems);
        boolean result = true;
        for (XmlObjectNode problem : problems) {
            result = result && all.contains(problem);
        }
        return result;
    }

    private void collectFragmentObjects(XmlObjectNode xmlObject, List<XmlObjectNode> all, List<XmlObjectNode> referenced) {
        if (all.contains(xmlObject)) {
            return;
        }
        all.add(xmlObject);
        if (xmlObject.getXmlObjectChildren() != null) {
            for (XmlObjectNode child : xmlObject.getXmlObjectChildren()) {
                if (!xmlObject.equals(child.getXmlObjectParent())) {
                    referenced.add(child);
                    continue;
                }
                this.collectFragmentObjects(child, all, referenced);
            }
        }
    }
}

