/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.api;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectAttribute;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class XmlObjectXPathEvaluatorTestSuite
extends AbstractXmlObjectTestSuite {
    public XmlObjectXPathEvaluatorTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testSelectSingleXmlObjectNodeButNoMatch() throws Exception {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlContext xmlContext = xmlObject.getXmlContext();
        XmlObjectXPathEvaluator xpathEvaluator = xmlContext.createXPathEvaluator();
        XmlObjectNode xmlObjectNode = xpathEvaluator.selectSingleXmlObjectNode(xmlObject, "./thisdoesnotexist", XmlObjectNode.class);
        Assert.assertNull((Object)xmlObjectNode);
    }

    @Test
    public void testSelectXmlObjectNodesButNoMatch() throws Exception {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlContext xmlContext = xmlObject.getXmlContext();
        XmlObjectXPathEvaluator xpathEvaluator = xmlContext.createXPathEvaluator();
        Object[] xmlObjectNodes = xpathEvaluator.selectXmlObjectNodes(xmlObject, "./thisdoesnotexist", XmlObjectNode.class);
        Assert.assertArrayEquals((Object[])XmlObjectNode.EMPTY_ARRAY, (Object[])xmlObjectNodes);
    }

    @Test
    public void testBaseXPathFromBaseRootSelectsThis() throws Exception {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlContext xmlContext = xmlObject.getXmlContext();
        XmlObjectXPathEvaluator xpathEvaluator = xmlContext.createXPathEvaluator();
        Assert.assertEquals((Object)xmlObject, (Object)xpathEvaluator.selectSingleXmlObjectNode(xmlObject.getXmlObjectBaseRoot(), xmlObject.getXmlObjectBaseXPath(), XmlObject.class));
    }

    @Test
    public void testSelectXmlObjectNodesOnAncestorAxis() throws Exception {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlContext xmlContext = xmlObject.getXmlContext();
        XmlObjectXPathEvaluator xpathEvaluator = xmlContext.createXPathEvaluator();
        Object[] xmlObjectNodes = xpathEvaluator.selectXmlObjectNodes(xmlObject, "./ancestor::node()", XmlObjectNode.class);
        Object[] expectedXmlObjectNodes = xmlObject.getXmlObjectAncestors();
        Assert.assertArrayEquals((Object[])expectedXmlObjectNodes, (Object[])xmlObjectNodes);
    }

    @Test
    public void testSelectXmlObjectNodesOnAncestorOrSelfAxis() throws Exception {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlContext xmlContext = xmlObject.getXmlContext();
        XmlObjectXPathEvaluator xpathEvaluator = xmlContext.createXPathEvaluator();
        Object[] xmlObjectNodes = xpathEvaluator.selectXmlObjectNodes(xmlObject, "./ancestor-or-self::node()", XmlObjectNode.class);
        XmlObjectNode[] ancestors = xmlObject.getXmlObjectAncestors();
        Object[] expectedXmlObjectNodes = new XmlObjectNode[ancestors.length + 1];
        System.arraycopy(ancestors, 0, expectedXmlObjectNodes, 0, ancestors.length);
        expectedXmlObjectNodes[expectedXmlObjectNodes.length - 1] = xmlObject;
        Assert.assertArrayEquals((Object[])expectedXmlObjectNodes, (Object[])xmlObjectNodes);
    }

    @Test
    public void testSelectXmlObjectNodesOnDescendantAxis() throws Exception {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlContext xmlContext = xmlObject.getXmlContext();
        XmlObjectXPathEvaluator xpathEvaluator = xmlContext.createXPathEvaluator();
        Object[] xmlObjectNodes = xpathEvaluator.selectXmlObjectNodes(xmlObject, "./descendant::node()", XmlObjectNode.class);
        Object[] expectedXmlObjectNodes = xmlObject.getXmlObjectDescendants();
        Assert.assertArrayEquals((Object[])expectedXmlObjectNodes, (Object[])xmlObjectNodes);
    }

    @Test
    public void testSelectXmlObjectNodesOnDescendantOrSelfAxis() throws Exception {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlContext xmlContext = xmlObject.getXmlContext();
        XmlObjectXPathEvaluator xpathEvaluator = xmlContext.createXPathEvaluator();
        Object[] xmlObjectNodes = xpathEvaluator.selectXmlObjectNodes(xmlObject, "./descendant-or-self::node()", XmlObjectNode.class);
        XmlObjectNode[] descendants = xmlObject.getXmlObjectDescendants();
        Object[] expectedXmlObjectNodes = new XmlObjectNode[descendants.length + 1];
        System.arraycopy(descendants, 0, expectedXmlObjectNodes, 0, descendants.length);
        expectedXmlObjectNodes[expectedXmlObjectNodes.length - 1] = xmlObject;
        Assert.assertArrayEquals((Object[])expectedXmlObjectNodes, (Object[])xmlObjectNodes);
    }

    @Test
    public void testSelectXmlObjectNodesOnFollowingAxis() throws Exception {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlContext xmlContext = xmlObject.getXmlContext();
        XmlObjectXPathEvaluator xpathEvaluator = xmlContext.createXPathEvaluator();
        Object[] xmlObjectNodes = xpathEvaluator.selectXmlObjectNodes(xmlObject, "./following::node()", XmlObjectNode.class);
        Object[] expectedXmlObjectNodes = xmlObject.getXmlObjectFollowing();
        Assert.assertArrayEquals((Object[])expectedXmlObjectNodes, (Object[])xmlObjectNodes);
    }

    @Test
    public void testSelectXmlObjectNodesOnPrecedingAxis() throws Exception {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlContext xmlContext = xmlObject.getXmlContext();
        XmlObjectXPathEvaluator xpathEvaluator = xmlContext.createXPathEvaluator();
        Object[] xmlObjectNodes = xpathEvaluator.selectXmlObjectNodes(xmlObject, "./preceding::node()", XmlObjectNode.class);
        Object[] expectedXmlObjectNodes = xmlObject.getXmlObjectPreceding();
        Assert.assertArrayEquals((Object[])expectedXmlObjectNodes, (Object[])xmlObjectNodes);
    }

    @Test
    public void testSelectXmlObjectNodesOnFollowingSiblingAxis() throws Exception {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlContext xmlContext = xmlObject.getXmlContext();
        XmlObjectXPathEvaluator xpathEvaluator = xmlContext.createXPathEvaluator();
        Object[] xmlObjectNodes = xpathEvaluator.selectXmlObjectNodes(xmlObject, "./following-sibling::node()", XmlObjectNode.class);
        Object[] expectedXmlObjectNodes = xmlObject.getXmlObjectFollowingSiblings();
        Assert.assertArrayEquals((Object[])expectedXmlObjectNodes, (Object[])xmlObjectNodes);
    }

    @Test
    public void testSelectXmlObjectNodesOnPrecedingSiblingAxis() throws Exception {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlContext xmlContext = xmlObject.getXmlContext();
        XmlObjectXPathEvaluator xpathEvaluator = xmlContext.createXPathEvaluator();
        Object[] xmlObjectNodes = xpathEvaluator.selectXmlObjectNodes(xmlObject, "./preceding-sibling::node()", XmlObjectNode.class);
        Object[] expectedXmlObjectNodes = xmlObject.getXmlObjectPrecedingSiblings();
        Assert.assertArrayEquals((Object[])expectedXmlObjectNodes, (Object[])xmlObjectNodes);
    }

    @Test
    public void testSelectXmlObjectNodesOnParentAxis() throws Exception {
        Object[] objectArray;
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlContext xmlContext = xmlObject.getXmlContext();
        XmlObjectXPathEvaluator xpathEvaluator = xmlContext.createXPathEvaluator();
        Object[] xmlObjectNodes = xpathEvaluator.selectXmlObjectNodes(xmlObject, "./parent::node()", XmlObjectNode.class);
        XmlObject parent = xmlObject.getXmlObjectParent();
        if (parent == null) {
            objectArray = new XmlObject[]{};
        } else {
            XmlObject[] xmlObjectArray = new XmlObject[1];
            objectArray = xmlObjectArray;
            xmlObjectArray[0] = parent;
        }
        Object[] expectedXmlObjectNodes = objectArray;
        Assert.assertArrayEquals((Object[])expectedXmlObjectNodes, (Object[])xmlObjectNodes);
    }

    @Test
    public void testSelectXmlObjectNodesOnChildAxis() throws Exception {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlContext xmlContext = xmlObject.getXmlContext();
        XmlObjectXPathEvaluator xpathEvaluator = xmlContext.createXPathEvaluator();
        Object[] xmlObjectNodes = xpathEvaluator.selectXmlObjectNodes(xmlObject, "./child::node()", XmlObjectNode.class);
        Assert.assertArrayEquals((Object[])xmlObject.getXmlObjectChildren(), (Object[])xmlObjectNodes);
    }

    @Test
    public void testSelectXmlObjectNodesOnAttributeAxis() throws Exception {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlContext xmlContext = xmlObject.getXmlContext();
        XmlObjectXPathEvaluator xpathEvaluator = xmlContext.createXPathEvaluator();
        XmlObjectNode[] xmlObjectNodes = xpathEvaluator.selectXmlObjectNodes(xmlObject, "./attribute::node()", XmlObjectNode.class);
        HashMap<QName, Object> xmlObjectAttributeMap = new HashMap<QName, Object>();
        for (XmlObjectNode xmlObjectNode : xmlObjectNodes) {
            XmlObjectAttribute xmlObjectAttribute = (XmlObjectAttribute)xmlObjectNode;
            xmlObjectAttributeMap.put(xmlObjectAttribute.getXmlObjectQName(), xmlObjectAttribute.getXmlObjectValue());
        }
        Assert.assertEquals((Object)xmlObject.getXmlObjectAttributes(), xmlObjectAttributeMap);
    }

    @Test
    public void testSelectSingleXmlObjectNodeOnParent() throws Exception {
        XmlObject xmlObject = (XmlObject)this.newXmlObjectUnderTest();
        XmlContext xmlContext = xmlObject.getXmlContext();
        XmlObjectXPathEvaluator xpathEvaluator = xmlContext.createXPathEvaluator();
        XmlObjectNode xmlObjectNode = xpathEvaluator.selectSingleXmlObjectNode(xmlObject, "..", XmlObjectNode.class);
        XmlObject parent = xmlObject.getXmlObjectParent();
        XmlObject expectedXmlObjectNode = parent == null ? null : parent;
        Assert.assertEquals((Object)expectedXmlObjectNode, (Object)xmlObjectNode);
    }
}

