/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.api.analysis;

import com.ebmwebsourcing.easybox.api.DummyModelObject;
import com.ebmwebsourcing.easybox.api.DummyXmlObjectBinding;
import com.ebmwebsourcing.easybox.api.DummyXmlObjectNode;
import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectBinding;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.analysis.Analyzer;
import com.ebmwebsourcing.easybox.api.analysis.AnalyzerException;
import com.ebmwebsourcing.easybox.api.analysis.ClassMetadata;
import com.ebmwebsourcing.easybox.api.analysis.ImplementationClassConstructorException;
import com.ebmwebsourcing.easybox.api.analysis.InterfaceClassMustBePublicException;
import com.ebmwebsourcing.easybox.api.analysis.MultipleInterfacesImplementedException;
import com.ebmwebsourcing.easybox.api.analysis.UnexpectedImplementationKindException;
import com.ebmwebsourcing.easybox.api.analysis.UnexpectedPublicImplementationException;
import java.net.URI;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;

public class AnalyzerTest {
    @Test(expected=UnexpectedImplementationKindException.class)
    public void testUnexpectedImplementationKindException() throws AnalyzerException {
        ClassMetadata classMetadata = new ClassMetadata();
        Analyzer analyzer = new Analyzer(null, classMetadata);
        analyzer.analyzeClass(TestInterface0.class);
    }

    @Test(expected=UnexpectedPublicImplementationException.class)
    public void testUnexpectedPublicImplementationException() throws AnalyzerException {
        ClassMetadata classMetadata = new ClassMetadata();
        Analyzer analyzer = new Analyzer(null, classMetadata);
        analyzer.analyzeClass(TestClass0.class);
    }

    @Test(expected=MultipleInterfacesImplementedException.class)
    public void testMultipleInterfacesImplementedException() throws AnalyzerException {
        ClassMetadata classMetadata = new ClassMetadata();
        Analyzer analyzer = new Analyzer(null, classMetadata);
        analyzer.analyzeClass(TestClass1.class);
    }

    @Test(expected=InterfaceClassMustBePublicException.class)
    public void testInterfaceClassMustBePublicException() throws AnalyzerException {
        ClassMetadata classMetadata = new ClassMetadata();
        Analyzer analyzer = new Analyzer(null, classMetadata);
        analyzer.analyzeClass(TestClass2.class);
    }

    @Test(expected=ImplementationClassConstructorException.class)
    public void testImplementationClassConstructorException0() throws AnalyzerException {
        ClassMetadata classMetadata = new ClassMetadata();
        Analyzer analyzer = new Analyzer(null, classMetadata);
        analyzer.analyzeClass(TestClass3.class);
    }

    @Test(expected=ImplementationClassConstructorException.class)
    public void testImplementationClassConstructorException1() throws AnalyzerException {
        ClassMetadata classMetadata = new ClassMetadata();
        Analyzer analyzer = new Analyzer(null, classMetadata);
        analyzer.analyzeClass(TestClass4.class);
    }

    @Test
    public void testSuccessfulAnalysis() throws AnalyzerException {
        ClassMetadata classMetadata = new ClassMetadata();
        TestBinding0 binding0 = new TestBinding0();
        Analyzer analyzer = new Analyzer((XmlObjectBinding)binding0, classMetadata);
        analyzer.analyze();
        Assert.assertEquals(TestInterface2.class, (Object)classMetadata.get(TestClass5.class, "implementationClassInterface"));
        Assert.assertEquals((Object)binding0, (Object)classMetadata.get(TestClass5.class, "implementationClassBinding"));
        Assert.assertEquals(TestClass5.class, (Object)classMetadata.get(TestInterface2.class, "interfaceClassImplementationClass"));
        Assert.assertEquals(TestModelObjectClass0.class, (Object)classMetadata.get(TestClass5.class, "implementationClassModelObjectClass"));
        Assert.assertEquals(TestClass5.class.getDeclaredConstructors()[0], (Object)classMetadata.get(TestClass5.class, "implementationClassConstructor"));
    }

    static final class TestBinding0
    extends DummyXmlObjectBinding {
        TestBinding0() {
        }

        @Override
        public Class<? extends XmlObjectNode>[] getFactorableClasses() {
            return new Class[]{TestClass5.class};
        }
    }

    static final class TestClass5
    extends DummyXmlObjectNode
    implements TestInterface2 {
        public TestClass5(XmlContext xmlContext, TestModelObjectClass0 modelObject) {
        }
    }

    private static class TestModelObjectClass0
    extends DummyModelObject {
        private TestModelObjectClass0() {
        }
    }

    static final class TestClass4
    extends DummyXmlObjectNode
    implements TestInterface2 {
        public TestClass4(XmlContext xmlContext, int wronglyTypedArg) {
        }
    }

    static final class TestClass3
    extends DummyXmlObjectNode
    implements TestInterface2 {
        public TestClass3(XmlContext xmlContext, ModelObject modelObject, int unexpectedExtraArg) {
        }
    }

    static final class TestClass2
    implements TestInterface3 {
        TestClass2() {
        }

        public XmlObject getXmlObjectParent() {
            return null;
        }

        public XmlObjectNode[] getXmlObjectChildren() {
            return null;
        }

        public String getXmlObjectTextContent() {
            return null;
        }

        public String getXmlObjectValue() {
            return null;
        }

        public QName getXmlObjectQName() {
            return null;
        }

        public String getXmlObjectBaseXPath() {
            return null;
        }

        public Integer[] getXmlObjectBaseIndexes() {
            return null;
        }

        public int getXmlObjectIndex() {
            return 0;
        }

        public XmlObjectNode getXmlObjectFollowingSibling() {
            return null;
        }

        public XmlObjectNode getXmlObjectPrecedingSibling() {
            return null;
        }

        public XmlObjectNode[] getXmlObjectAncestors() {
            return null;
        }

        public XmlObjectNode[] getXmlObjectFollowing() {
            return null;
        }

        public XmlObjectNode[] getXmlObjectFollowingSiblings() {
            return null;
        }

        public XmlObjectNode[] getXmlObjectPrecedingSiblings() {
            return null;
        }

        public XmlObjectNode[] getXmlObjectPreceding() {
            return null;
        }

        public XmlObjectNode[] getXmlObjectPrecedingOrAncestor() {
            return null;
        }

        public XmlObject getXmlObjectRoot() {
            return null;
        }

        public XmlObjectNode[] getXmlObjectDescendants() {
            return null;
        }

        public URI getXmlObjectBaseURI() {
            return null;
        }

        public XmlObject getXmlObjectBaseRoot() {
            return null;
        }

        public int compareTo(XmlObjectNode o) {
            return 0;
        }

        public Object getUserData() {
            return null;
        }

        public boolean hasUserData() {
            return false;
        }

        public void setUserData(Object userData) {
        }
    }

    private static interface TestInterface3
    extends XmlObjectNode {
    }

    static final class TestClass1
    extends DummyXmlObjectNode
    implements TestInterface1,
    TestInterface2 {
        TestClass1() {
        }
    }

    public static interface TestInterface2
    extends XmlObjectNode {
    }

    public static class TestClass0
    extends DummyXmlObjectNode
    implements TestInterface1 {
    }

    public static interface TestInterface1
    extends XmlObjectNode {
    }

    public static interface TestInterface0
    extends XmlObjectNode {
    }
}

