/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.cli;

import com.ebmwebsourcing.easybox.api.XQueryValidationProfile;
import com.ebmwebsourcing.easybox.api.XQueryValidationRule;
import com.ebmwebsourcing.easybox.cli.XQueryValidationProfileParsingException;
import com.ebmwebsourcing.easybox.cli.XQueryValidationRuleInputStreamBuilder;
import com.ebmwebsourcing.easybox.cli.XQueryValidationRuleParsingException;
import com.ebmwebsourcing.easycommons.io.IOHelper;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.logging.Logger;

public final class XQueryValidationProfileDirBuilder {
    private static Logger LOG = Logger.getLogger(XQueryValidationProfileDirBuilder.class.getName());
    private final File xqueryValidationProfileDir;

    public XQueryValidationProfileDirBuilder(File xqueryValidationProfileDir) {
        assert (xqueryValidationProfileDir != null);
        this.xqueryValidationProfileDir = xqueryValidationProfileDir;
    }

    public XQueryValidationProfile build() throws XQueryValidationProfileParsingException {
        if (!this.xqueryValidationProfileDir.isDirectory()) {
            throw new XQueryValidationProfileParsingException(String.format("Cannot create a validation profile from '%s'. Not a directory.", this.xqueryValidationProfileDir.getAbsolutePath()));
        }
        XQueryValidationProfile validationProfile = new XQueryValidationProfile(this.xqueryValidationProfileDir.getName());
        for (File f : this.xqueryValidationProfileDir.listFiles()) {
            try {
                XQueryValidationRule rule = this.buildRule(f);
                validationProfile.addRule(rule);
                LOG.info(String.format("Added rule '%s' to profile '%s'.", rule.getName(), validationProfile.getName()));
            }
            catch (XQueryValidationRuleParsingException xvrpe) {
                LOG.warning(String.format("Cannot parse '%s' as a validation rule file. Skipping it.", f.getAbsolutePath()));
            }
        }
        return validationProfile;
    }

    private final XQueryValidationRule buildRule(File ruleFile) throws XQueryValidationRuleParsingException {
        XQueryValidationRule xQueryValidationRule;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(ruleFile);
            XQueryValidationRuleInputStreamBuilder ruleBuilder = new XQueryValidationRuleInputStreamBuilder(fis);
            xQueryValidationRule = ruleBuilder.build();
        }
        catch (FileNotFoundException fnfe) {
            try {
                throw new XQueryValidationRuleParsingException("Problem while building validation rule.", fnfe);
            }
            catch (Throwable throwable) {
                IOHelper.close(fis);
                throw throwable;
            }
        }
        IOHelper.close((Closeable)fis);
        return xQueryValidationRule;
    }
}

