/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.cli;

import com.ebmwebsourcing.easybox.api.XQueryValidationRule;
import com.ebmwebsourcing.easybox.cli.XQueryValidationRuleParsingException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class XQueryValidationRuleInputStreamBuilder {
    private static final String RULE_NAME_MARKER = "name:";
    private static final String RULE_DESCRIPTION_MARKER = "description:";
    private final InputStream xqueryRuleInputStream;

    public XQueryValidationRuleInputStreamBuilder(InputStream xqueryRuleInputStream) {
        this.xqueryRuleInputStream = xqueryRuleInputStream;
    }

    public XQueryValidationRule build() throws XQueryValidationRuleParsingException {
        BufferedReader br = new BufferedReader(new InputStreamReader(this.xqueryRuleInputStream));
        String line = null;
        String ruleName = null;
        String ruleDescription = null;
        StringBuffer ruleXQuery = new StringBuffer();
        try {
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith(RULE_NAME_MARKER)) {
                    ruleName = line.substring(line.indexOf(RULE_NAME_MARKER) + RULE_NAME_MARKER.length()).trim();
                } else if (line.startsWith(RULE_DESCRIPTION_MARKER)) {
                    ruleDescription = line.substring(line.indexOf(RULE_DESCRIPTION_MARKER) + RULE_DESCRIPTION_MARKER.length()).trim();
                }
                if (line.isEmpty()) continue;
                ruleXQuery.append(line).append("\n");
            }
        }
        catch (IOException e) {
            throw new XQueryValidationRuleParsingException("Unexpected error while parsing XQuery validation rule.", e);
        }
        if (ruleName == null || ruleName.isEmpty()) {
            throw new XQueryValidationRuleParsingException("No rule name found. Did you specify a 'name : ...' in the header comment ?");
        }
        if (ruleDescription == null || ruleDescription.isEmpty()) {
            throw new XQueryValidationRuleParsingException("No rule description found. Did you specify a 'description : ...' in the header comment ?");
        }
        if (ruleXQuery.length() == 0) {
            throw new XQueryValidationRuleParsingException("No rule XQuery found.");
        }
        return new XQueryValidationRule(ruleName, ruleDescription, ruleXQuery.toString());
    }
}

