/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybox.impl;

import com.ebmwebsourcing.easybox.api.ModelObject;
import com.ebmwebsourcing.easybox.impl.AbstractModelObject;
import com.ebmwebsourcing.easybox.impl.JaxbDuplicator;
import com.ebmwebsourcing.easybox.impl.JaxbReflector;
import com.ebmwebsourcing.easybox.impl.ModelObjectComparator;
import java.net.URI;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@XmlTransient
public abstract class AbstractJaxbModelObject
extends AbstractModelObject {
    @XmlTransient
    private URI baseURI = null;
    @XmlTransient
    private Binder<Node> binder = null;
    @XmlTransient
    private JAXBElement<?> jaxbElement = null;
    @XmlTransient
    private Object naturalParent = null;
    @XmlTransient
    private Object adoptiveParent;

    public final int hashCode() {
        return 0;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractJaxbModelObject)) {
            return false;
        }
        AbstractJaxbModelObject ajo = (AbstractJaxbModelObject)obj;
        if (this.getClass() != ajo.getClass()) {
            ajo = JaxbDuplicator.duplicateAs(ajo, this.getClass());
        }
        return ModelObjectComparator.areEquals(this, ajo);
    }

    public URI getBaseURI() {
        URI uri = null;
        for (AbstractJaxbModelObject current = this; current != null; current = current.getNaturalParent()) {
            uri = current.baseURI;
            if (uri == null) continue;
            return uri;
        }
        return uri;
    }

    final Binder<Node> getBinder() {
        return this.binder;
    }

    final JAXBElement<?> getJAXBElement() {
        return this.jaxbElement;
    }

    String getOriginatingNamespaceURI() {
        return this.getClass().getPackage().getAnnotation(XmlSchema.class).namespace();
    }

    public final AbstractJaxbModelObject getNaturalParent() {
        if (this.naturalParent instanceof JAXBElement) {
            return (AbstractJaxbModelObject)((JAXBElement)this.naturalParent).getValue();
        }
        return (AbstractJaxbModelObject)this.naturalParent;
    }

    public final AbstractJaxbModelObject getAdoptiveParent() {
        if (this.adoptiveParent instanceof JAXBElement) {
            return (AbstractJaxbModelObject)((JAXBElement)this.adoptiveParent).getValue();
        }
        return (AbstractJaxbModelObject)this.adoptiveParent;
    }

    final QName getQName() {
        if (this.getClass().isAnnotationPresent(XmlRootElement.class)) {
            String namespaceURI = this.getOriginatingNamespaceURI();
            return new QName(namespaceURI, this.getClass().getAnnotation(XmlRootElement.class).name());
        }
        if (this.jaxbElement != null) {
            return this.jaxbElement.getName();
        }
        if (this.binder != null) {
            Node node = (Node)this.binder.getXMLNode((Object)this);
            assert (node instanceof Element);
            if (node.getPrefix() == null) {
                return new QName(node.getNamespaceURI(), node.getLocalName());
            }
            return new QName(node.getNamespaceURI(), node.getLocalName(), node.getPrefix());
        }
        return JaxbReflector.guessQNameFromParent(this, this.getNaturalParent());
    }

    public void setBaseURI(URI baseUri) {
        this.baseURI = baseUri;
    }

    public final Node getDOMNode() {
        return (Node)this.getBinder().getXMLNode((Object)this);
    }

    final void setBinder(Binder<Node> binder) {
        this.binder = binder;
        Node node = this.getDOMNode();
        assert (node != null);
        node.setUserData("modelObject", this, null);
    }

    final void setJaxbElement(JAXBElement<?> jaxbElement) {
        this.jaxbElement = jaxbElement;
    }

    @Override
    protected final void setNaturalParent(ModelObject naturalParent) {
        this.naturalParent = naturalParent;
    }

    @Override
    protected final void setAdoptiveParent(ModelObject adoptiveParent) {
        this.adoptiveParent = adoptiveParent;
    }

    public final ModelObject duplicate() {
        return JaxbDuplicator.duplicate(this);
    }

    public final <X extends ModelObject> X duplicateAs(Class<X> targetClass) {
        return JaxbDuplicator.duplicateAs(this, targetClass);
    }
}

