/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.extended.service.activity.impl;

import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfiguration;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfigurationException;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.ExtendedActivityConfigurationList;
import com.ebmwebsourcing.easybpel.extended.activities.configure.api.inout.ExtendedActivityConfigurationListReader;
import com.ebmwebsourcing.easybpel.extended.activities.configure.impl.inout.ExtendedActivityConfigurationListReaderImpl;
import com.ebmwebsourcing.easybpel.extended.service.activity.api.ExtendedActivityService;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.extension.ExtendedActivity;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.ExtendedBehaviourServiceImpl;
import com.ebmwebsourcing.easyviper.extended.service.behaviour.impl.util.jarLoader.JarException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class ExtendedActivityServiceImpl
extends ExtendedBehaviourServiceImpl
implements ExtendedActivityService {
    private Logger log = Logger.getLogger(ExtendedActivityServiceImpl.class.getName());
    private List<ExtendedActivityConfiguration> extendedActivitiesInits = Collections.synchronizedList(new ArrayList());
    private ExtendedActivityConfigurationListReader reader;
    private ExtendedActivityConfigurationException initEx = null;

    public ExtendedActivityServiceImpl(Engine engine) {
        super(engine);
        try {
            this.reader = new ExtendedActivityConfigurationListReaderImpl();
        }
        catch (ExtendedActivityConfigurationException e) {
            this.initEx = e;
        }
    }

    public void run() {
        try {
            Thread.sleep(this.getRefreshFrequency());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.severe("BPELError in auto trash service: " + e.getMessage());
        }
    }

    @Override
    public ExtendedActivityConfigurationList loadExtendedActivitiesConfigure(URL url) throws ExtendedActivityConfigurationException {
        ExtendedActivityConfigurationList res = null;
        if (url == null) {
            throw new ExtendedActivityConfigurationException("url cannot be null!!!");
        }
        if (this.initEx != null) {
            throw this.initEx;
        }
        try {
            res = this.reader.read(url.toURI());
            this.extendedActivitiesInits.addAll(res.getExtendedActivityConf());
        }
        catch (URISyntaxException e) {
            throw new ExtendedActivityConfigurationException((Throwable)e);
        }
        return res;
    }

    @Override
    public List<ExtendedActivityConfiguration> getAllExtendedActivitiesInit() {
        return this.extendedActivitiesInits;
    }

    @Override
    public ExtendedActivityConfiguration findExtendedActivity(QName tag) {
        ExtendedActivityConfiguration res = null;
        for (ExtendedActivityConfiguration init : this.extendedActivitiesInits) {
            if (!init.getTag().getLocalPart().equals(tag.getLocalPart()) || !init.getTag().getNamespaceURI().equals(tag.getNamespaceURI())) continue;
            res = init;
            break;
        }
        return res;
    }

    @Override
    public List<ExtendedActivityConfigurationList> getExtendedActivitiesConfiguresInJar(URL jarUrl) throws ExtendedActivityConfigurationException {
        ArrayList<ExtendedActivityConfigurationList> res = new ArrayList<ExtendedActivityConfigurationList>();
        try {
            this.getExtendedBehaviourInJar(jarUrl);
            List xmlFiles = (List)this.classLoader.getResources().get("xml");
            if (xmlFiles != null) {
                for (String file : xmlFiles) {
                    URL url = this.classLoader.getResource(file);
                    if (url == null) continue;
                    try {
                        res.add(this.loadExtendedActivitiesConfigure(url));
                    }
                    catch (ExtendedActivityConfigurationException e) {}
                }
            }
            List ext = this.getClassInJar(this.classLoader, ExtendedActivity.class);
        }
        catch (JarException e) {
            throw new ExtendedActivityConfigurationException((Throwable)e);
        }
        return res;
    }
}

