/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.extended.activities._package.debug.test;

import com.ebmwebsourcing.easybpel.extended.service.activity.api.ExtendedActivityService;
import com.ebmwebsourcing.easybpel.extended.service.activity.impl.ExtendedActivityServiceImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.message.BPELExternalMessage;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELExternalMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.DefaultBPELMessageConverter;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessContextDefinitionImpl;
import com.ebmwebsourcing.easyviper.environment.test.CoreParentTest;
import com.ebmwebsourcing.easyviper.environment.test.env.ExecutionEnvironmentTestFactory;
import com.ebmwebsourcing.easyviper.environment.test.env.TestSenderImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ClientEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import javax.xml.namespace.QName;
import org.jdom.JDOMException;

public class DebugProcessTest
extends CoreParentTest {
    public DebugProcessTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDebug() throws CoreException, URISyntaxException, BPELException, InterruptedException, JDOMException, IOException {
        boolean explorer = false;
        ExecutionEnvironmentTest env = ExecutionEnvironmentTestFactory.newInstance().newEnvironment("TestEnvironnement", false);
        Core core = BPELFactoryImpl.getInstance().newBPELEngine(DefaultBPELMessageConverter.get(), 1, MemoryReceiverImpl.class, 1, TestSenderImpl.class);
        ExtendedActivityService service = (ExtendedActivityService)core.getEngine().getServiceManager().getService(ExtendedActivityServiceImpl.class);
        service.loadExtendedActivitiesConfigure(Thread.currentThread().getContextClassLoader().getResource("DebugActivitiesPackageConfiguration.xml"));
        env.setCore(core);
        ClientEndpoint client = env.createClientEndpoint("client");
        core.getModel().getRegistry().storeProcessDefinition(new URI("./src/test/resources/DebugProcess.bpel"), (ProcessContextDefinition)new ProcessContextDefinitionImpl());
        BPELExternalMessageImpl message = new BPELExternalMessageImpl();
        message.setService(new QName("http://com.ebmwebsourcing.easybpel/debug", "DebugService"));
        message.setEndpoint("DebugPort");
        message.setOperationName("process");
        message.setMessage("<deb:DebugProcessRequest xmlns:deb=\"http://com.ebmwebsourcing.easybpel/debug\">         <deb:input>1</deb:input></deb:DebugProcessRequest>");
        client.send((ExternalMessage)message);
        Process process = null;
        while (core.getEngine().getProcessInstanceRegistry().getProcessInstances().size() == 0) {
            System.out.println("Wait the creation of process");
        }
        process = (Process)core.getEngine().getProcessInstanceRegistry().getProcessInstances().get(0);
        while (process.getParentExecution() == null) {
            System.out.println("Wait that the process start");
        }
        long start = Calendar.getInstance().getTimeInMillis();
        long end = Calendar.getInstance().getTimeInMillis();
        while (!process.getState().equals((Object)Process.State.PROCESS_ENDED) && end - start < 20000L) {
            System.out.println("Wait that the end of process");
            Thread.sleep(200L);
        }
        BPELExternalMessage response = (BPELExternalMessage)client.getResponse();
        BPELExternalMessageImpl expectedResponse = new BPELExternalMessageImpl();
        expectedResponse.setMessage("<tns:DebugProcessResponse xmlns:tns=\"http://com.ebmwebsourcing.easybpel/debug\">  <tns:result xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"int\">2</tns:result></tns:DebugProcessResponse>");
        DebugProcessTest.assertTrue((boolean)XMLComparator.isEquivalent((String)expectedResponse.toString(), (String)response.toString()));
    }
}

