/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.usecase.contractnet.contractor;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELExternalMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.DefaultBPELMessageConverter;
import com.ebmwebsourcing.easybpel.usecase.contractnet.contractor.ContractorImplService;
import com.ebmwebsourcing.easybpel.usecase.contractnet.contractor.ContractorImplService2;
import com.ebmwebsourcing.easybpel.usecase.contractnet.contractor.ManagerService;
import com.ebmwebsourcing.easybpel.usecase.contractnet.contractor.ManagerService2;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessContextDefinitionImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.ExecutionEnvironmentTestFactory;
import com.ebmwebsourcing.easyviper.environment.test.env.TestSenderImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ClientEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ProviderEndpoint;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jdom.JDOMException;
import org.junit.Test;

public class ContractorProcessTest {
    private Logger log = Logger.getLogger(ContractorProcessTest.class.getName());

    @Test
    public void testcontractNet() throws CoreException, URISyntaxException, BPELException, InterruptedException, JDOMException, IOException {
        boolean explorer = false;
        ExecutionEnvironmentTest env = ExecutionEnvironmentTestFactory.newInstance().newEnvironment("TestEnvironnement", false);
        Core core = BPELFactoryImpl.getInstance().newBPELEngine(DefaultBPELMessageConverter.get(), 1, MemoryReceiverImpl.class, 1, TestSenderImpl.class);
        env.setCore(core);
        ClientEndpoint client = env.createClientEndpoint("client");
        ClientEndpoint manager = env.createClientEndpoint("manager");
        ProviderEndpoint contractorImplProvider = env.createProviderEndpoint("ContractorImplInterfacePort", ContractorImplService.class);
        ProviderEndpoint managerProvider = env.createProviderEndpoint("ManagerInterfacePort", ManagerService.class);
        core.getModel().getRegistry().storeProcessDefinition(new URI("./src/test/resources/contractor/ContractorProcess.bpel"), (ProcessContextDefinition)new ProcessContextDefinitionImpl());
        BPELExternalMessageImpl message = new BPELExternalMessageImpl();
        message.setService(new QName("http://irit.contractnet.org/contractor", "ContractorService"));
        message.setEndpoint("ContractorInterfacePort");
        message.setOperationName("receiveCFP");
        message.setMessage("<ns2:receiveCFP xmlns:ns2=\"http://irit.contractnet.org/contractor\">\t<ns2:ReceiveCFPRequest>\t\t<ns2:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</ns2:CallForProposalId>       <ns2:ContractorEndpoint>\t\t\t<ns2:EndpointReference xmlns:ctn=\"http://irit.contractnet.org\" xmlns:tns=\"http://www.w3.org/2005/08/addressing\" ctn:type=\"tns:EndpointReferenceType\">\t\t\t\t<tns:Address tns:type=\"tns:AttributedURIType\">ContractorImplInterfacePort</tns:Address>\t\t\t\t<tns:ReferenceParameters tns:type=\"tns:ReferenceParametersType\" />\t\t\t\t<tns:Metadata tns:type=\"tns:MetadataType\" />\t\t\t</ns2:EndpointReference>       </ns2:ContractorEndpoint> \t\t<ns2:CallForProposal>\t\t\t<ns2:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</ns2:CallForProposalId>\t\t\t<ns2:ManagerId>f4f7776b-49fe-43df-9047-dad6b5e9c7d0</ns2:ManagerId>\t\t\t<ns2:ManagerDescription>Cellule de crise</ns2:ManagerDescription>\t\t\t<ns2:taskDescription>10 lits</ns2:taskDescription>    \t    <ns2:contractorSelectionCriterion>Rapide</ns2:contractorSelectionCriterion>   \t    <ns2:bidSelectionCriterion>Respect delai</ns2:bidSelectionCriterion>    \t\t<ns2:taskDeadline>2009-07-20T17:30:00.000+02:00</ns2:taskDeadline>\t\t\t<ns2:cfpDeadline>2019-07-17T17:30:00.000+02:00</ns2:cfpDeadline>\t\t\t<ns2:cfpState>created</ns2:cfpState>\t\t</ns2:CallForProposal>\t</ns2:ReceiveCFPRequest></ns2:receiveCFP>");
        client.send((ExternalMessage)message);
        Process process = null;
        while (core.getEngine().getProcessInstanceRegistry().getProcessInstances().size() == 0) {
            System.out.println("Wait the creation of process");
            Thread.sleep(1000L);
        }
        process = (Process)core.getEngine().getProcessInstanceRegistry().getProcessInstances().get(0);
        while (process.getParentExecution() == null) {
            System.out.println("Wait that the process start");
            Thread.sleep(1000L);
        }
        while (process.getParentExecution().getState() != Execution.State.SUSPENDED) {
            System.out.println("Wait that the process arrive on the second receive");
            Thread.sleep(1000L);
        }
        boolean isContract = false;
        if (isContract) {
            BPELExternalMessageImpl receiveContractMessage = new BPELExternalMessageImpl();
            receiveContractMessage.setService(new QName("http://irit.contractnet.org/contractor", "ContractorService"));
            receiveContractMessage.setEndpoint("ContractorInterfacePort");
            receiveContractMessage.setOperationName("receiveContract");
            receiveContractMessage.setMessage("<irit:receiveContract xmlns:irit=\"http://irit.contractnet.org/contractor\">\t<irit:ReceiveContractRequest>\t\t<irit:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</irit:CallForProposalId>\t\t<irit:BidId>2222</irit:BidId>\t\t<irit:Contract>\t\t\t<irit:ContractId>1998fb57-b0b1-40fd-a22b-90988ae844f6</irit:ContractId>\t\t\t<irit:ManagerId>f4f7776b-49fe-43df-9047-dad6b5e9c7d0</irit:ManagerId>\t\t\t<irit:ManagerDescription>Cellule de crise</irit:ManagerDescription>\t\t\t<irit:ContractorId>&lt;?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>&lt;EndpointReference xmlns=\"http://www.w3.org/2005/08/addressing\">&lt;Address>ContractorImplInterfacePort&lt;/Address>&lt;/EndpointReference></irit:ContractorId>\t\t\t<irit:ContractorDescription>Contractant 2</irit:ContractorDescription>\t\t\t<irit:BidId>2222</irit:BidId>\t\t\t<irit:contractDescription>Mon contrat Signataire : Contractant 1</irit:contractDescription>\t\t\t<irit:contractState>accepted</irit:contractState>\t\t</irit:Contract>\t</irit:ReceiveContractRequest></irit:receiveContract>");
            manager.send((ExternalMessage)receiveContractMessage);
        } else {
            BPELExternalMessageImpl receiveBidRejectMessage = new BPELExternalMessageImpl();
            receiveBidRejectMessage.setService(new QName("http://irit.contractnet.org/contractor", "ContractorService"));
            receiveBidRejectMessage.setEndpoint("ContractorInterfacePort");
            receiveBidRejectMessage.setOperationName("receiveBidReject");
            receiveBidRejectMessage.setMessage("<irit:receiveBidReject xmlns:irit=\"http://irit.contractnet.org/contractor\">\t<irit:ReceiveBidRejectRequest>\t\t<irit:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</irit:CallForProposalId>\t\t<irit:BidId>1111</irit:BidId>\t\t<irit:Bid>\t\t\t<tns:BidId xmlns:tns=\"http://irit.contractnet.org\">1111</tns:BidId>\t\t\t<tns:ContractorId xmlns:tns=\"http://irit.contractnet.org\">&lt;?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>&lt;EndpointReference xmlns=\"http://www.w3.org/2005/08/addressing\">&lt;Address>ContractorImplInterfacePort&lt;/Address>&lt;/EndpointReference></tns:ContractorId>\t\t\t<tns:ContractorDescription xmlns:tns=\"http://irit.contractnet.org\">Contractant 1</tns:ContractorDescription>\t\t\t<tns:CallForProposalId xmlns:tns=\"http://irit.contractnet.org\">a3b6faf1-8be6-478a-9127-40f8d1dc70b9</tns:CallForProposalId>\t\t\t<tns:ManagerId xmlns:tns=\"http://irit.contractnet.org\">f4f7776b-49fe-43df-9047-dad6b5e9c7d0</tns:ManagerId>\t\t\t<tns:answerCriterionCFP xmlns:tns=\"http://irit.contractnet.org\">Mon offre</tns:answerCriterionCFP>\t\t\t<tns:answerTaskDeadline xmlns:tns=\"http://irit.contractnet.org\">2009-09-20T17:00:00.000+02:00</tns:answerTaskDeadline>\t\t\t<tns:eligibilityBid xmlns:tns=\"http://irit.contractnet.org\">false</tns:eligibilityBid>\t\t\t<tns:rowBid xmlns:tns=\"http://irit.contractnet.org\">0</tns:rowBid>\t\t\t<tns:bidState xmlns:tns=\"http://irit.contractnet.org\">rejected</tns:bidState>\t\t</irit:Bid>\t</irit:ReceiveBidRejectRequest></irit:receiveBidReject>");
            manager.send((ExternalMessage)receiveBidRejectMessage);
        }
        for (int cpt = 10; process.getParentExecution().getState() != Execution.State.ENDED && cpt > 0; --cpt) {
            System.out.println("Waiting for the end of the process");
            Thread.sleep(1000L);
        }
    }

    @Test
    public void testcontractNet2() throws CoreException, URISyntaxException, BPELException, InterruptedException, JDOMException, IOException {
        boolean first;
        boolean explorer = false;
        ExecutionEnvironmentTest env = ExecutionEnvironmentTestFactory.newInstance().newEnvironment("TestEnvironnement", false);
        Core core = BPELFactoryImpl.getInstance().newBPELEngine(DefaultBPELMessageConverter.get(), 1, MemoryReceiverImpl.class, 1, TestSenderImpl.class);
        env.setCore(core);
        ClientEndpoint client1 = env.createClientEndpoint("client");
        ClientEndpoint client2 = env.createClientEndpoint("client");
        ClientEndpoint manager = env.createClientEndpoint("manager");
        ProviderEndpoint contractorImplProvider = env.createProviderEndpoint("ContractorImplInterfacePort", ContractorImplService.class);
        ProviderEndpoint contractorImplProvider2 = env.createProviderEndpoint("ContractorImplInterfacePort2", ContractorImplService2.class);
        ProviderEndpoint managerProvider = env.createProviderEndpoint("ManagerInterfacePort", ManagerService2.class);
        core.getModel().getRegistry().storeProcessDefinition(new URI("./src/test/resources/contractor/ContractorProcess.bpel"), (ProcessContextDefinition)new ProcessContextDefinitionImpl());
        BPELExternalMessageImpl message1 = new BPELExternalMessageImpl();
        message1.setService(new QName("http://irit.contractnet.org/contractor", "ContractorService"));
        message1.setEndpoint("ContractorInterfacePort");
        message1.setOperationName("receiveCFP");
        BPELExternalMessageImpl message2 = new BPELExternalMessageImpl();
        message2.setService(new QName("http://irit.contractnet.org/contractor", "ContractorService"));
        message2.setEndpoint("ContractorInterfacePort");
        message2.setOperationName("receiveCFP");
        message1.setMessage("<ns2:receiveCFP xmlns:ns2=\"http://irit.contractnet.org/contractor\">\t<ns2:ReceiveCFPRequest>\t\t<ns2:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</ns2:CallForProposalId>       <ns2:ContractorEndpoint>\t\t\t<ns2:EndpointReference xmlns:ctn=\"http://irit.contractnet.org\" xmlns:tns=\"http://www.w3.org/2005/08/addressing\" ctn:type=\"tns:EndpointReferenceType\">\t\t\t\t<tns:Address tns:type=\"tns:AttributedURIType\">ContractorImplInterfacePort</tns:Address>\t\t\t\t<tns:ReferenceParameters tns:type=\"tns:ReferenceParametersType\" />\t\t\t\t<tns:Metadata tns:type=\"tns:MetadataType\" />\t\t\t</ns2:EndpointReference>       </ns2:ContractorEndpoint> \t\t<ns2:CallForProposal>\t\t\t<ns2:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</ns2:CallForProposalId>\t\t\t<ns2:ManagerId>f4f7776b-49fe-43df-9047-dad6b5e9c7d0</ns2:ManagerId>\t\t\t<ns2:ManagerDescription>Cellule de crise</ns2:ManagerDescription>\t\t\t<ns2:taskDescription>10 lits</ns2:taskDescription>    \t    <ns2:contractorSelectionCriterion>Rapide</ns2:contractorSelectionCriterion>   \t    <ns2:bidSelectionCriterion>Respect delai</ns2:bidSelectionCriterion>    \t\t<ns2:taskDeadline>2009-07-20T17:30:00.000+02:00</ns2:taskDeadline>\t\t\t<ns2:cfpDeadline>2019-07-17T17:30:00.000+02:00</ns2:cfpDeadline>\t\t\t<ns2:cfpState>created</ns2:cfpState>\t\t</ns2:CallForProposal>\t</ns2:ReceiveCFPRequest></ns2:receiveCFP>");
        client1.send((ExternalMessage)message1);
        Process process1 = (Process)core.getEngine().getProcessInstanceRegistry().getProcessInstances().get(0);
        while (process1.getParentExecution().getState() != Execution.State.ACTIVE) {
            first = true;
            if (first) {
                System.out.println("testcontractNet2 : Wait for process 1 to leave leaves the first receive");
                first = false;
            }
            Thread.sleep(100L);
        }
        while (process1.getParentExecution().getState() != Execution.State.SUSPENDED) {
            first = true;
            if (first) {
                System.out.println("testcontractNet2 : Wait for process 1 to arrive on the second receive");
                first = false;
            }
            Thread.sleep(100L);
        }
        message2.setMessage("<ns2:receiveCFP xmlns:ns2=\"http://irit.contractnet.org/contractor\">\t<ns2:ReceiveCFPRequest>\t\t<ns2:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</ns2:CallForProposalId>       <ns2:ContractorEndpoint>\t\t\t<ns2:EndpointReference xmlns:ctn=\"http://irit.contractnet.org\" xmlns:tns=\"http://www.w3.org/2005/08/addressing\" ctn:type=\"tns:EndpointReferenceType\">\t\t\t\t<tns:Address tns:type=\"tns:AttributedURIType\">ContractorImplInterfacePort2</tns:Address>\t\t\t\t<tns:ReferenceParameters tns:type=\"tns:ReferenceParametersType\" />\t\t\t\t<tns:Metadata tns:type=\"tns:MetadataType\" />\t\t\t</ns2:EndpointReference>       </ns2:ContractorEndpoint> \t\t<ns2:CallForProposal>\t\t\t<ns2:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</ns2:CallForProposalId>\t\t\t<ns2:ManagerId>f4f7776b-49fe-43df-9047-dad6b5e9c7d0</ns2:ManagerId>\t\t\t<ns2:ManagerDescription>Cellule de crise</ns2:ManagerDescription>\t\t\t<ns2:taskDescription>10 lits</ns2:taskDescription>    \t    <ns2:contractorSelectionCriterion>Rapide</ns2:contractorSelectionCriterion>   \t    <ns2:bidSelectionCriterion>Respect delai</ns2:bidSelectionCriterion>    \t\t<ns2:taskDeadline>2009-07-20T17:30:00.000+02:00</ns2:taskDeadline>\t\t\t<ns2:cfpDeadline>2019-07-17T17:30:00.000+02:00</ns2:cfpDeadline>\t\t\t<ns2:cfpState>created</ns2:cfpState>\t\t</ns2:CallForProposal>\t</ns2:ReceiveCFPRequest></ns2:receiveCFP>");
        client2.send((ExternalMessage)message2);
        Process process2 = null;
        while (core.getEngine().getProcessInstanceRegistry().getProcessInstances().size() == 1) {
            System.out.println("Wait the creation of process 2");
        }
        process2 = (Process)core.getEngine().getProcessInstanceRegistry().getProcessInstances().get(1);
        while (process2.getParentExecution() == null) {
            System.out.println("Wait that the process 2 start");
        }
        while (process2.getParentExecution().getState() != Execution.State.SUSPENDED) {
            System.out.println("Wait that the process 2 arrive on the second receive");
            Thread.sleep(500L);
        }
        BPELExternalMessageImpl receiveBidRejectMessage = new BPELExternalMessageImpl();
        receiveBidRejectMessage.setService(new QName("http://irit.contractnet.org/contractor", "ContractorService"));
        receiveBidRejectMessage.setEndpoint("ContractorInterfacePort");
        receiveBidRejectMessage.setOperationName("receiveBidReject");
        receiveBidRejectMessage.setMessage("<irit:receiveBidReject xmlns:irit=\"http://irit.contractnet.org/contractor\">\t<irit:ReceiveBidRejectRequest>\t\t<irit:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</irit:CallForProposalId>\t\t<irit:BidId>1111</irit:BidId>\t\t<irit:Bid>\t\t\t<tns:BidId xmlns:tns=\"http://irit.contractnet.org\">1111</tns:BidId>\t\t\t<tns:ContractorId xmlns:tns=\"http://irit.contractnet.org\">&lt;?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>&lt;EndpointReference xmlns=\"http://www.w3.org/2005/08/addressing\">&lt;Address>ContractorImplInterfacePort&lt;/Address>&lt;/EndpointReference></tns:ContractorId>\t\t\t<tns:ContractorDescription xmlns:tns=\"http://irit.contractnet.org\">Contractant 1</tns:ContractorDescription>\t\t\t<tns:CallForProposalId xmlns:tns=\"http://irit.contractnet.org\">a3b6faf1-8be6-478a-9127-40f8d1dc70b9</tns:CallForProposalId>\t\t\t<tns:ManagerId xmlns:tns=\"http://irit.contractnet.org\">f4f7776b-49fe-43df-9047-dad6b5e9c7d0</tns:ManagerId>\t\t\t<tns:answerCriterionCFP xmlns:tns=\"http://irit.contractnet.org\">Mon offre</tns:answerCriterionCFP>\t\t\t<tns:answerTaskDeadline xmlns:tns=\"http://irit.contractnet.org\">2009-09-20T17:00:00.000+02:00</tns:answerTaskDeadline>\t\t\t<tns:eligibilityBid xmlns:tns=\"http://irit.contractnet.org\">false</tns:eligibilityBid>\t\t\t<tns:rowBid xmlns:tns=\"http://irit.contractnet.org\">0</tns:rowBid>\t\t\t<tns:bidState xmlns:tns=\"http://irit.contractnet.org\">rejected</tns:bidState>\t\t</irit:Bid>\t</irit:ReceiveBidRejectRequest></irit:receiveBidReject>");
        manager.send((ExternalMessage)receiveBidRejectMessage);
        while (process1.getParentExecution().getState() != Execution.State.ENDED) {
            System.out.println("Waiting for the end of the process 1: " + process1.getName());
            Thread.sleep(500L);
        }
        this.log.finest("process1 " + process1.getName() + " is finished");
        BPELExternalMessageImpl receiveContractMessage = new BPELExternalMessageImpl();
        receiveContractMessage.setService(new QName("http://irit.contractnet.org/contractor", "ContractorService"));
        receiveContractMessage.setEndpoint("ContractorInterfacePort");
        receiveContractMessage.setOperationName("receiveContract");
        receiveContractMessage.setMessage("<irit:receiveContract xmlns:irit=\"http://irit.contractnet.org/contractor\">\t<irit:ReceiveContractRequest>\t\t<irit:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</irit:CallForProposalId>\t\t<irit:BidId>2222</irit:BidId>\t\t<irit:Contract>\t\t\t<irit:ContractId>1998fb57-b0b1-40fd-a22b-90988ae844f6</irit:ContractId>\t\t\t<irit:ManagerId>f4f7776b-49fe-43df-9047-dad6b5e9c7d0</irit:ManagerId>\t\t\t<irit:ManagerDescription>Cellule de crise</irit:ManagerDescription>\t\t\t<irit:ContractorId>&lt;?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>&lt;EndpointReference xmlns=\"http://www.w3.org/2005/08/addressing\">&lt;Address>ContractorImplInterfacePort&lt;/Address>&lt;/EndpointReference></irit:ContractorId>\t\t\t<irit:ContractorDescription>Contractant 2</irit:ContractorDescription>\t\t\t<irit:BidId>2222</irit:BidId>\t\t\t<irit:contractDescription>Mon contrat Signataire : Contractant 1</irit:contractDescription>\t\t\t<irit:contractState>accepted</irit:contractState>\t\t</irit:Contract>\t</irit:ReceiveContractRequest></irit:receiveContract>");
        manager.send((ExternalMessage)receiveContractMessage);
        for (int cpt = 10; process2.getParentExecution().getState() != Execution.State.ENDED && cpt > 0; --cpt) {
            System.out.println("Waiting for the end of the process 2: " + process2.getName());
            Thread.sleep(500L);
        }
        this.log.finest("process2 " + process2.getName() + " is finished");
    }

    @Test
    public void testcontractNet2_alternance() throws CoreException, URISyntaxException, BPELException, InterruptedException, JDOMException, IOException {
        boolean first;
        boolean first2;
        boolean explorer = false;
        ExecutionEnvironmentTest env = ExecutionEnvironmentTestFactory.newInstance().newEnvironment("TestEnvironnement", false);
        Core core = BPELFactoryImpl.getInstance().newBPELEngine(DefaultBPELMessageConverter.get(), 1, MemoryReceiverImpl.class, 1, TestSenderImpl.class);
        env.setCore(core);
        ClientEndpoint client1 = env.createClientEndpoint("client");
        ClientEndpoint client2 = env.createClientEndpoint("client");
        ClientEndpoint manager = env.createClientEndpoint("manager");
        ProviderEndpoint contractorImplProvider = env.createProviderEndpoint("ContractorImplInterfacePort", ContractorImplService.class);
        ProviderEndpoint contractorImplProvider2 = env.createProviderEndpoint("ContractorImplInterfacePort2", ContractorImplService2.class);
        ProviderEndpoint managerProvider = env.createProviderEndpoint("ManagerInterfacePort", ManagerService2.class);
        core.getModel().getRegistry().storeProcessDefinition(new URI("./src/test/resources/contractor/ContractorProcess.bpel"), (ProcessContextDefinition)new ProcessContextDefinitionImpl());
        BPELExternalMessageImpl message1 = new BPELExternalMessageImpl();
        message1.setService(new QName("http://irit.contractnet.org/contractor", "ContractorService"));
        message1.setEndpoint("ContractorInterfacePort");
        message1.setOperationName("receiveCFP");
        BPELExternalMessageImpl message2 = new BPELExternalMessageImpl();
        message2.setService(new QName("http://irit.contractnet.org/contractor", "ContractorService"));
        message2.setEndpoint("ContractorInterfacePort");
        message2.setOperationName("receiveCFP");
        message1.setMessage("<ns2:receiveCFP xmlns:ns2=\"http://irit.contractnet.org/contractor\">\t<ns2:ReceiveCFPRequest>\t\t<ns2:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</ns2:CallForProposalId>       <ns2:ContractorEndpoint>\t\t\t<ns2:EndpointReference xmlns:ctn=\"http://irit.contractnet.org\" xmlns:tns=\"http://www.w3.org/2005/08/addressing\" ctn:type=\"tns:EndpointReferenceType\">\t\t\t\t<tns:Address tns:type=\"tns:AttributedURIType\">ContractorImplInterfacePort</tns:Address>\t\t\t\t<tns:ReferenceParameters tns:type=\"tns:ReferenceParametersType\" />\t\t\t\t<tns:Metadata tns:type=\"tns:MetadataType\" />\t\t\t</ns2:EndpointReference>       </ns2:ContractorEndpoint> \t\t<ns2:CallForProposal>\t\t\t<ns2:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</ns2:CallForProposalId>\t\t\t<ns2:ManagerId>f4f7776b-49fe-43df-9047-dad6b5e9c7d0</ns2:ManagerId>\t\t\t<ns2:ManagerDescription>Cellule de crise</ns2:ManagerDescription>\t\t\t<ns2:taskDescription>10 lits</ns2:taskDescription>    \t    <ns2:contractorSelectionCriterion>Rapide</ns2:contractorSelectionCriterion>   \t    <ns2:bidSelectionCriterion>Respect delai</ns2:bidSelectionCriterion>    \t\t<ns2:taskDeadline>2009-07-20T17:30:00.000+02:00</ns2:taskDeadline>\t\t\t<ns2:cfpDeadline>2019-07-17T17:30:00.000+02:00</ns2:cfpDeadline>\t\t\t<ns2:cfpState>created</ns2:cfpState>\t\t</ns2:CallForProposal>\t</ns2:ReceiveCFPRequest></ns2:receiveCFP>");
        client1.send((ExternalMessage)message1);
        Process process1 = (Process)core.getEngine().getProcessInstanceRegistry().getProcessInstances().get(0);
        while (process1.getParentExecution().getState() != Execution.State.ACTIVE) {
            first2 = true;
            if (first2) {
                System.out.println("testcontractNet2_alternance : Wait for process 1 to leave leaves the first receive");
                first2 = false;
            }
            Thread.sleep(100L);
        }
        while (process1.getParentExecution().getState() != Execution.State.SUSPENDED) {
            first2 = true;
            if (first2) {
                System.out.println("testcontractNet2_alternance : Wait for process 1 to arrive on the second receive");
                first2 = false;
            }
            Thread.sleep(100L);
        }
        message2.setMessage("<ns2:receiveCFP xmlns:ns2=\"http://irit.contractnet.org/contractor\">\t<ns2:ReceiveCFPRequest>\t\t<ns2:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</ns2:CallForProposalId>       <ns2:ContractorEndpoint>\t\t\t<ns2:EndpointReference xmlns:ctn=\"http://irit.contractnet.org\" xmlns:tns=\"http://www.w3.org/2005/08/addressing\" ctn:type=\"tns:EndpointReferenceType\">\t\t\t\t<tns:Address tns:type=\"tns:AttributedURIType\">ContractorImplInterfacePort2</tns:Address>\t\t\t\t<tns:ReferenceParameters tns:type=\"tns:ReferenceParametersType\" />\t\t\t\t<tns:Metadata tns:type=\"tns:MetadataType\" />\t\t\t</ns2:EndpointReference>       </ns2:ContractorEndpoint> \t\t<ns2:CallForProposal>\t\t\t<ns2:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</ns2:CallForProposalId>\t\t\t<ns2:ManagerId>f4f7776b-49fe-43df-9047-dad6b5e9c7d0</ns2:ManagerId>\t\t\t<ns2:ManagerDescription>Cellule de crise</ns2:ManagerDescription>\t\t\t<ns2:taskDescription>10 lits</ns2:taskDescription>    \t    <ns2:contractorSelectionCriterion>Rapide</ns2:contractorSelectionCriterion>   \t    <ns2:bidSelectionCriterion>Respect delai</ns2:bidSelectionCriterion>    \t\t<ns2:taskDeadline>2009-07-20T17:30:00.000+02:00</ns2:taskDeadline>\t\t\t<ns2:cfpDeadline>2019-07-17T17:30:00.000+02:00</ns2:cfpDeadline>\t\t\t<ns2:cfpState>created</ns2:cfpState>\t\t</ns2:CallForProposal>\t</ns2:ReceiveCFPRequest></ns2:receiveCFP>");
        client2.send((ExternalMessage)message2);
        Process process2 = null;
        while (core.getEngine().getProcessInstanceRegistry().getProcessInstances().size() == 1) {
            System.out.println("Wait the creation of process 2");
        }
        process2 = (Process)core.getEngine().getProcessInstanceRegistry().getProcessInstances().get(1);
        while (process2.getParentExecution() == null) {
            System.out.println("Wait that the process 2 start");
        }
        while (process2.getParentExecution().getState() != Execution.State.SUSPENDED) {
            System.out.println("Wait that the process 2 arrive on the second receive");
            Thread.sleep(500L);
        }
        BPELExternalMessageImpl receiveBidRejectMessage = new BPELExternalMessageImpl();
        receiveBidRejectMessage.setService(new QName("http://irit.contractnet.org/contractor", "ContractorService"));
        receiveBidRejectMessage.setEndpoint("ContractorInterfacePort");
        receiveBidRejectMessage.setOperationName("receiveBidReject");
        receiveBidRejectMessage.setMessage("<irit:receiveBidReject xmlns:irit=\"http://irit.contractnet.org/contractor\">\t<irit:ReceiveBidRejectRequest>\t\t<irit:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</irit:CallForProposalId>\t\t<irit:BidId>1111</irit:BidId>\t\t<irit:Bid>\t\t\t<tns:BidId xmlns:tns=\"http://irit.contractnet.org\">1111</tns:BidId>\t\t\t<tns:ContractorId xmlns:tns=\"http://irit.contractnet.org\">&lt;?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>&lt;EndpointReference xmlns=\"http://www.w3.org/2005/08/addressing\">&lt;Address>ContractorImplInterfacePort&lt;/Address>&lt;/EndpointReference></tns:ContractorId>\t\t\t<tns:ContractorDescription xmlns:tns=\"http://irit.contractnet.org\">Contractant 1</tns:ContractorDescription>\t\t\t<tns:CallForProposalId xmlns:tns=\"http://irit.contractnet.org\">a3b6faf1-8be6-478a-9127-40f8d1dc70b9</tns:CallForProposalId>\t\t\t<tns:ManagerId xmlns:tns=\"http://irit.contractnet.org\">f4f7776b-49fe-43df-9047-dad6b5e9c7d0</tns:ManagerId>\t\t\t<tns:answerCriterionCFP xmlns:tns=\"http://irit.contractnet.org\">Mon offre</tns:answerCriterionCFP>\t\t\t<tns:answerTaskDeadline xmlns:tns=\"http://irit.contractnet.org\">2009-09-20T17:00:00.000+02:00</tns:answerTaskDeadline>\t\t\t<tns:eligibilityBid xmlns:tns=\"http://irit.contractnet.org\">false</tns:eligibilityBid>\t\t\t<tns:rowBid xmlns:tns=\"http://irit.contractnet.org\">0</tns:rowBid>\t\t\t<tns:bidState xmlns:tns=\"http://irit.contractnet.org\">rejected</tns:bidState>\t\t</irit:Bid>\t</irit:ReceiveBidRejectRequest></irit:receiveBidReject>");
        manager.send((ExternalMessage)receiveBidRejectMessage);
        while (process1.getParentExecution().getState() != Execution.State.ENDED) {
            System.out.println("Waiting for the end of the process 1 (1): " + process1.getName());
            Thread.sleep(500L);
        }
        this.log.finest("process1 " + process1.getName() + " is finished");
        BPELExternalMessageImpl receiveContractMessage = new BPELExternalMessageImpl();
        receiveContractMessage.setService(new QName("http://irit.contractnet.org/contractor", "ContractorService"));
        receiveContractMessage.setEndpoint("ContractorInterfacePort");
        receiveContractMessage.setOperationName("receiveContract");
        receiveContractMessage.setMessage("<irit:receiveContract xmlns:irit=\"http://irit.contractnet.org/contractor\">\t<irit:ReceiveContractRequest>\t\t<irit:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</irit:CallForProposalId>\t\t<irit:BidId>2222</irit:BidId>\t\t<irit:Contract>\t\t\t<irit:ContractId>1998fb57-b0b1-40fd-a22b-90988ae844f6</irit:ContractId>\t\t\t<irit:ManagerId>f4f7776b-49fe-43df-9047-dad6b5e9c7d0</irit:ManagerId>\t\t\t<irit:ManagerDescription>Cellule de crise</irit:ManagerDescription>\t\t\t<irit:ContractorId>&lt;?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>&lt;EndpointReference xmlns=\"http://www.w3.org/2005/08/addressing\">&lt;Address>ContractorImplInterfacePort&lt;/Address>&lt;/EndpointReference></irit:ContractorId>\t\t\t<irit:ContractorDescription>Contractant 2</irit:ContractorDescription>\t\t\t<irit:BidId>2222</irit:BidId>\t\t\t<irit:contractDescription>Mon contrat Signataire : Contractant 1</irit:contractDescription>\t\t\t<irit:contractState>accepted</irit:contractState>\t\t</irit:Contract>\t</irit:ReceiveContractRequest></irit:receiveContract>");
        manager.send((ExternalMessage)receiveContractMessage);
        while (process2.getParentExecution().getState() != Execution.State.ENDED) {
            System.out.println("Waiting for the end of the process 2: " + process2.getName());
            Thread.sleep(500L);
        }
        this.log.finest("process2 " + process2.getName() + " is finished");
        message1.setMessage("<ns2:receiveCFP xmlns:ns2=\"http://irit.contractnet.org/contractor\">\t<ns2:ReceiveCFPRequest>\t\t<ns2:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</ns2:CallForProposalId>       <ns2:ContractorEndpoint>\t\t\t<ns2:EndpointReference xmlns:ctn=\"http://irit.contractnet.org\" xmlns:tns=\"http://www.w3.org/2005/08/addressing\" ctn:type=\"tns:EndpointReferenceType\">\t\t\t\t<tns:Address tns:type=\"tns:AttributedURIType\">ContractorImplInterfacePort</tns:Address>\t\t\t\t<tns:ReferenceParameters tns:type=\"tns:ReferenceParametersType\" />\t\t\t\t<tns:Metadata tns:type=\"tns:MetadataType\" />\t\t\t</ns2:EndpointReference>       </ns2:ContractorEndpoint> \t\t<ns2:CallForProposal>\t\t\t<ns2:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</ns2:CallForProposalId>\t\t\t<ns2:ManagerId>f4f7776b-49fe-43df-9047-dad6b5e9c7d0</ns2:ManagerId>\t\t\t<ns2:ManagerDescription>Cellule de crise</ns2:ManagerDescription>\t\t\t<ns2:taskDescription>10 lits</ns2:taskDescription>    \t    <ns2:contractorSelectionCriterion>Rapide</ns2:contractorSelectionCriterion>   \t    <ns2:bidSelectionCriterion>Respect delai</ns2:bidSelectionCriterion>    \t\t<ns2:taskDeadline>2009-07-20T17:30:00.000+02:00</ns2:taskDeadline>\t\t\t<ns2:cfpDeadline>2019-07-17T17:30:00.000+02:00</ns2:cfpDeadline>\t\t\t<ns2:cfpState>created</ns2:cfpState>\t\t</ns2:CallForProposal>\t</ns2:ReceiveCFPRequest></ns2:receiveCFP>");
        client1.send((ExternalMessage)message1);
        while (process1.getParentExecution() == null) {
            System.out.println("Wait that the process 1 start");
        }
        while (process1.getParentExecution().getState() != Execution.State.ACTIVE) {
            first = true;
            if (first) {
                System.out.println("testcontractNet2_alternance BIS : Wait for process 1 to leave the first receive");
                first = false;
            }
            Thread.sleep(100L);
        }
        while (process1.getParentExecution().getState() != Execution.State.SUSPENDED) {
            first = true;
            if (first) {
                System.out.println("testcontractNet2_alternance BIS : Wait that the process 1 arrive on the second receive");
                first = false;
            }
            Thread.sleep(100L);
        }
        message2.setMessage("<ns2:receiveCFP xmlns:ns2=\"http://irit.contractnet.org/contractor\">\t<ns2:ReceiveCFPRequest>\t\t<ns2:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</ns2:CallForProposalId>       <ns2:ContractorEndpoint>\t\t\t<ns2:EndpointReference xmlns:ctn=\"http://irit.contractnet.org\" xmlns:tns=\"http://www.w3.org/2005/08/addressing\" ctn:type=\"tns:EndpointReferenceType\">\t\t\t\t<tns:Address tns:type=\"tns:AttributedURIType\">ContractorImplInterfacePort2</tns:Address>\t\t\t\t<tns:ReferenceParameters tns:type=\"tns:ReferenceParametersType\" />\t\t\t\t<tns:Metadata tns:type=\"tns:MetadataType\" />\t\t\t</ns2:EndpointReference>       </ns2:ContractorEndpoint> \t\t<ns2:CallForProposal>\t\t\t<ns2:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</ns2:CallForProposalId>\t\t\t<ns2:ManagerId>f4f7776b-49fe-43df-9047-dad6b5e9c7d0</ns2:ManagerId>\t\t\t<ns2:ManagerDescription>Cellule de crise</ns2:ManagerDescription>\t\t\t<ns2:taskDescription>10 lits</ns2:taskDescription>    \t    <ns2:contractorSelectionCriterion>Rapide</ns2:contractorSelectionCriterion>   \t    <ns2:bidSelectionCriterion>Respect delai</ns2:bidSelectionCriterion>    \t\t<ns2:taskDeadline>2009-07-20T17:30:00.000+02:00</ns2:taskDeadline>\t\t\t<ns2:cfpDeadline>2019-07-17T17:30:00.000+02:00</ns2:cfpDeadline>\t\t\t<ns2:cfpState>created</ns2:cfpState>\t\t</ns2:CallForProposal>\t</ns2:ReceiveCFPRequest></ns2:receiveCFP>");
        client2.send((ExternalMessage)message2);
        while (process2.getParentExecution() == null) {
            System.out.println("Wait that the process 2 start");
        }
        while (process2.getParentExecution().getState() != Execution.State.SUSPENDED) {
            System.out.println("Wait that the process 2 arrive on the second receive");
            Thread.sleep(500L);
        }
        receiveBidRejectMessage = new BPELExternalMessageImpl();
        receiveBidRejectMessage.setService(new QName("http://irit.contractnet.org/contractor", "ContractorService"));
        receiveBidRejectMessage.setEndpoint("ContractorInterfacePort");
        receiveBidRejectMessage.setOperationName("receiveBidReject");
        receiveBidRejectMessage.setMessage("<irit:receiveBidReject xmlns:irit=\"http://irit.contractnet.org/contractor\">\t<irit:ReceiveBidRejectRequest>\t\t<irit:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</irit:CallForProposalId>\t\t<irit:BidId>1111</irit:BidId>\t\t<irit:Bid>\t\t\t<tns:BidId xmlns:tns=\"http://irit.contractnet.org\">1111</tns:BidId>\t\t\t<tns:ContractorId xmlns:tns=\"http://irit.contractnet.org\">&lt;?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>&lt;EndpointReference xmlns=\"http://www.w3.org/2005/08/addressing\">&lt;Address>ContractorImplInterfacePort&lt;/Address>&lt;/EndpointReference></tns:ContractorId>\t\t\t<tns:ContractorDescription xmlns:tns=\"http://irit.contractnet.org\">Contractant 1</tns:ContractorDescription>\t\t\t<tns:CallForProposalId xmlns:tns=\"http://irit.contractnet.org\">a3b6faf1-8be6-478a-9127-40f8d1dc70b9</tns:CallForProposalId>\t\t\t<tns:ManagerId xmlns:tns=\"http://irit.contractnet.org\">f4f7776b-49fe-43df-9047-dad6b5e9c7d0</tns:ManagerId>\t\t\t<tns:answerCriterionCFP xmlns:tns=\"http://irit.contractnet.org\">Mon offre</tns:answerCriterionCFP>\t\t\t<tns:answerTaskDeadline xmlns:tns=\"http://irit.contractnet.org\">2009-09-20T17:00:00.000+02:00</tns:answerTaskDeadline>\t\t\t<tns:eligibilityBid xmlns:tns=\"http://irit.contractnet.org\">false</tns:eligibilityBid>\t\t\t<tns:rowBid xmlns:tns=\"http://irit.contractnet.org\">0</tns:rowBid>\t\t\t<tns:bidState xmlns:tns=\"http://irit.contractnet.org\">rejected</tns:bidState>\t\t</irit:Bid>\t</irit:ReceiveBidRejectRequest></irit:receiveBidReject>");
        manager.send((ExternalMessage)receiveBidRejectMessage);
        while (process1.getParentExecution().getState() != Execution.State.ENDED) {
            System.out.println("Waiting for the end of the process 1 (2): " + process1.getName());
            Thread.sleep(500L);
        }
        this.log.finest("process1 " + process1.getName() + " is finished");
        receiveContractMessage = new BPELExternalMessageImpl();
        receiveContractMessage.setService(new QName("http://irit.contractnet.org/contractor", "ContractorService"));
        receiveContractMessage.setEndpoint("ContractorInterfacePort");
        receiveContractMessage.setOperationName("receiveContract");
        receiveContractMessage.setMessage("<irit:receiveContract xmlns:irit=\"http://irit.contractnet.org/contractor\">\t<irit:ReceiveContractRequest>\t\t<irit:CallForProposalId>a3b6faf1-8be6-478a-9127-40f8d1dc70b9</irit:CallForProposalId>\t\t<irit:BidId>2222</irit:BidId>\t\t<irit:Contract>\t\t\t<irit:ContractId>1998fb57-b0b1-40fd-a22b-90988ae844f6</irit:ContractId>\t\t\t<irit:ManagerId>f4f7776b-49fe-43df-9047-dad6b5e9c7d0</irit:ManagerId>\t\t\t<irit:ManagerDescription>Cellule de crise</irit:ManagerDescription>\t\t\t<irit:ContractorId>&lt;?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>&lt;EndpointReference xmlns=\"http://www.w3.org/2005/08/addressing\">&lt;Address>ContractorImplInterfacePort&lt;/Address>&lt;/EndpointReference></irit:ContractorId>\t\t\t<irit:ContractorDescription>Contractant 2</irit:ContractorDescription>\t\t\t<irit:BidId>2222</irit:BidId>\t\t\t<irit:contractDescription>Mon contrat Signataire : Contractant 1</irit:contractDescription>\t\t\t<irit:contractState>accepted</irit:contractState>\t\t</irit:Contract>\t</irit:ReceiveContractRequest></irit:receiveContract>");
        manager.send((ExternalMessage)receiveContractMessage);
        while (process2.getParentExecution().getState() != Execution.State.ENDED) {
            System.out.println("Waiting for the end of the process 2: " + process2.getName());
            Thread.sleep(500L);
        }
        this.log.finest("process2 " + process2.getName() + " is finished");
    }
}

