/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.usecase.securemail;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELFactoryImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.BPELExternalMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.message.DefaultBPELMessageConverter;
import com.ebmwebsourcing.easybpel.usecase.securemail.AuthService;
import com.ebmwebsourcing.easybpel.usecase.securemail.MailService;
import com.ebmwebsourcing.easycommons.xml.XMLComparator;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.model.registry.definition.ProcessContextDefinition;
import com.ebmwebsourcing.easyviper.core.api.soa.message.ExternalMessage;
import com.ebmwebsourcing.easyviper.core.impl.model.registry.ProcessContextDefinitionImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.ExecutionEnvironmentTestFactory;
import com.ebmwebsourcing.easyviper.environment.test.env.TestSenderImpl;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ClientEndpoint;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ExecutionEnvironmentTest;
import com.ebmwebsourcing.easyviper.environment.test.env.api.ProviderEndpoint;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import org.jdom.JDOMException;
import org.junit.Assert;
import org.junit.Test;

public class SecureMailTest {
    @Test
    public void testSecureMail() throws CoreException, URISyntaxException, BPELException, InterruptedException, JDOMException, IOException {
        boolean explorer = false;
        ExecutionEnvironmentTest env = ExecutionEnvironmentTestFactory.newInstance().newEnvironment("TestEnvironnement", false);
        Core core = BPELFactoryImpl.getInstance().newBPELEngine(DefaultBPELMessageConverter.get(), 1, MemoryReceiverImpl.class, 1, TestSenderImpl.class);
        env.setCore(core);
        ClientEndpoint client = env.createClientEndpoint("client");
        ProviderEndpoint authentificationProvider = env.createProviderEndpoint("AuthImpl", AuthService.class);
        ProviderEndpoint serviceProvider = env.createProviderEndpoint("ServiceMailPort", MailService.class);
        core.getModel().getRegistry().storeProcessDefinition(new URI("./src/test/resources/process.bpel"), (ProcessContextDefinition)new ProcessContextDefinitionImpl());
        BPELExternalMessageImpl message = new BPELExternalMessageImpl();
        message.setService(new QName("http://test", "ServiceMailSecuriseImpl"));
        message.setEndpoint("ServiceMailSecuriseImplEndpoint");
        message.setOperationName("getMailByUID");
        message.setMessage(" <ns0:getMailByUID xmlns:ns0=\"http://test\" >    <payload >       <ns0:uid>adrien_login</ns0:uid>       <ns0:password>adrien_pwd</ns0:password>    </payload> </ns0:getMailByUID>");
        ExternalMessage response = client.sendSync((ExternalMessage)message);
        BPELExternalMessageImpl expectedResponse = new BPELExternalMessageImpl();
        expectedResponse.setMessage("<tns:getMailByUIDResponse xmlns:tns=\"http://test\">  <payload xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"tns:ServiceMailSecuriseResponse\">    <tns:email xsi:type=\"string\">adrien@ebm</tns:email>  </payload></tns:getMailByUIDResponse>");
        Assert.assertTrue((boolean)XMLComparator.isEquivalent((String)expectedResponse.toString(), (String)response.toString()));
    }
}

