/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer;

import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.Expression;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.Node;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.analyzer.SimpleNode;

public class ExpressionNode
extends SimpleNode {
    private String image;

    public ExpressionNode(int i) {
        super(i);
    }

    public ExpressionNode(Expression p, int i) {
        super(p, i);
    }

    public static Node jjtCreate(int id) {
        return new ExpressionNode(id);
    }

    public static Node jjtCreate(Expression p, int id) {
        return new ExpressionNode(p, id);
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public static Multiplicative getMultiplicative(String image) {
        Multiplicative res = null;
        if ("*".equals(image)) {
            res = Multiplicative.MULT;
        } else if ("/".equals(image)) {
            res = Multiplicative.DIV;
        } else if ("%".equals(image)) {
            res = Multiplicative.MOD;
        }
        return res;
    }

    public static Inequality getInequality(String image) {
        Inequality res = null;
        if ("<".equals(image)) {
            res = Inequality.INFERIOR;
        } else if ("<=".equals(image)) {
            res = Inequality.INFERIOR_EQUALS;
        } else if (">".equals(image)) {
            res = Inequality.SUPERIOR;
        } else if (">=".equals(image)) {
            res = Inequality.SUPERIOR_EQUALS;
        }
        return res;
    }

    public static Equality getEquality(String image) {
        Equality res = null;
        if ("=".equals(image)) {
            res = Equality.EQUAL;
        } else if ("!=".equals(image)) {
            res = Equality.DIFFERENT;
        }
        return res;
    }

    public static boolean isPlus(String image) {
        boolean res = false;
        if (image.equals("+")) {
            res = true;
        }
        return res;
    }

    public static boolean isEqual(String image) {
        boolean res = false;
        if (image.equals("==")) {
            res = true;
        }
        return res;
    }

    public static boolean getBoolean(String image) {
        return Boolean.valueOf(image);
    }

    public static String getCharacter(String image) {
        return image.replaceAll("'", "");
    }

    public static Float getFloat(String image) {
        return Float.valueOf(Float.parseFloat(image));
    }

    public static Integer getInteger(String image) {
        return Integer.parseInt(image);
    }

    public static String getString(String image) {
        return image.substring(1, image.length() - 1);
    }

    public static String getAttributeName(String image) {
        return image.substring(1, image.length());
    }

    public static enum Multiplicative {
        MULT("*"),
        DIV("/"),
        MOD("%");

        private String value = "";

        private Multiplicative(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(String val) {
            return this.value().equals(val);
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Inequality {
        INFERIOR("<"),
        SUPERIOR(">"),
        INFERIOR_EQUALS("<="),
        SUPERIOR_EQUALS(">=");

        private String value = "";

        private Inequality(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(String val) {
            return this.value().equals(val);
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum Equality {
        EQUAL("="),
        DIFFERENT("!=");

        private String value = "";

        private Equality(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public boolean equals(String val) {
            return this.value().equals(val);
        }

        public String toString() {
            return this.value;
        }
    }
}

