/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn20.impl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectValidationException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Lane;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.xpath.XPathExpressionException;
import junit.framework.Assert;
import org.junit.Test;

public class SampleIOTest {
    @Test
    public void test() throws XmlObjectReadException, XmlObjectValidationException, BPMNException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("Definitions.xml");
        com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions defs = (com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions)context.createReader().readDocument(url, com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        URL url2 = Thread.currentThread().getContextClassLoader().getResource("A.wsdl");
        Definitions wsdlDefs = (Definitions)context.createReader().readDocument(url2, Definitions.class);
        context.createValidator().failFastValidate((XmlObject)wsdlDefs);
        Assert.assertTrue((boolean)defs.hasImport());
        Assert.assertEquals((int)1, (int)defs.getImports().length);
        Import i = defs.getImports()[0];
        Assert.assertTrue((boolean)i.isWSDL11Import());
        Definitions readWsdlDefs = i.getWSDL11Definitions();
        context.createValidator().failFastValidate((XmlObject)readWsdlDefs);
        System.out.println(defs);
    }

    @Test
    public void testLaneElements() throws XmlObjectReadException, XmlObjectValidationException, BPMNException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("Definitions.xml");
        com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions defs = (com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions)context.createReader().readDocument(url, com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        Lane lane = (Lane)DefinitionsHelper.findObjectInDefinitions((com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions)defs, (String)"FlightBookingClerc", Lane.class);
        Assert.assertNotNull((Object)lane);
        Assert.assertTrue((boolean)lane.hasFlowNodeRef());
        Assert.assertEquals((int)3, (int)lane.getFlowNodeRef().length);
    }

    @Test
    public void testOMG() throws XmlObjectReadException, XmlObjectValidationException, XmlObjectWriteException, URISyntaxException, MalformedURLException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("omg");
        File dir = new File(url.toURI());
        for (File child : dir.listFiles()) {
            System.out.println(child.getName());
            if (!child.getName().endsWith(".bpmn")) continue;
            com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions defs = (com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions)context.createReader().readDocument(child.toURI().toURL(), com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions.class);
            context.createValidator().failFastValidate((XmlObject)defs);
            context.createWriter().writeDocument((XmlObject)defs, (OutputStream)new ByteArrayOutputStream());
        }
    }

    @Test
    public void testSimple() throws XmlObjectReadException, XmlObjectValidationException, XmlObjectWriteException, XPathExpressionException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("SimpleProcessDefinitions.xml");
        com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions defs = (com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions)context.createReader().readDocument(url, com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        context.createWriter().writeDocument((XmlObject)defs, (OutputStream)new ByteArrayOutputStream());
    }

    @Test
    public void testTriso() throws XmlObjectReadException, XmlObjectValidationException, XmlObjectWriteException {
        XmlContext context = new XmlContextFactory().newContext();
        URL url = Thread.currentThread().getContextClassLoader().getResource("triso.bpmn");
        com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions defs = (com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions)context.createReader().readDocument(url, com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions.class);
        context.createValidator().failFastValidate((XmlObject)defs);
        context.createWriter().writeDocument((XmlObject)defs, (OutputStream)new ByteArrayOutputStream());
    }
}

