/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn20diagram.api;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNEdge;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNPlane;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNShape;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.DiagramElement;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class BPMNPlaneChildrenTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_NUMBER_DIAGRAMELEMENT = "numberOfDiagramElement";
    public static final String EXPECTED_NUMBER_BPMNSHAPE = "numberOfBPMNShapes";
    public static final String EXPECTED_NUMBER_BPMNEDGE = "numberOfBPMNEdges";

    public BPMNPlaneChildrenTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetChildren() {
        BPMNPlane identifiedObject = (BPMNPlane)this.newXmlObjectUnderTest();
        Assert.assertEquals((Object)this.getTestData(EXPECTED_NUMBER_DIAGRAMELEMENT), (Object)identifiedObject.getDiagramElement().length);
        int countShape = 0;
        int countEdge = 0;
        int countPlane = 0;
        for (DiagramElement de : identifiedObject.getDiagramElement()) {
            if (de instanceof BPMNShape) {
                ++countShape;
                continue;
            }
            if (de instanceof BPMNEdge) {
                ++countEdge;
                continue;
            }
            if (!(de instanceof BPMNPlane)) continue;
            ++countPlane;
        }
        Assert.assertEquals((Object)this.getTestData(EXPECTED_NUMBER_BPMNEDGE), (Object)countEdge);
        Assert.assertEquals((Object)this.getTestData(EXPECTED_NUMBER_BPMNSHAPE), (Object)countShape);
        Assert.assertEquals((Object)this.getTestData(EXPECTED_NUMBER_BPMNEDGE), (Object)identifiedObject.getBPMNEdges().length);
        Assert.assertEquals((Object)this.getTestData(EXPECTED_NUMBER_BPMNSHAPE), (Object)identifiedObject.getBPMNShapes().length);
    }

    @Test
    public void testRemoveChild() {
        BPMNPlane identifiedObject = (BPMNPlane)this.newXmlObjectUnderTest();
        DiagramElement[] diagramElements = identifiedObject.getDiagramElement();
        junit.framework.Assert.assertNotNull((Object)diagramElements);
        int length = diagramElements.length;
        for (int i = 0; i < length; ++i) {
            identifiedObject.removeDiagramElement(diagramElements[0]);
            diagramElements = identifiedObject.getDiagramElement();
            junit.framework.Assert.assertNotNull((Object)diagramElements);
            junit.framework.Assert.assertEquals((int)((Integer)this.getTestData(EXPECTED_NUMBER_DIAGRAMELEMENT) - i - 1), (int)diagramElements.length);
        }
        diagramElements = identifiedObject.getDiagramElement();
        junit.framework.Assert.assertNotNull((Object)diagramElements);
        junit.framework.Assert.assertEquals((int)0, (int)diagramElements.length);
    }

    @Test
    public void testAddChild() {
        BPMNPlane identifiedObject = (BPMNPlane)this.newXmlObjectUnderTest();
        DiagramElement[] diagramElements = identifiedObject.getDiagramElement();
        junit.framework.Assert.assertNotNull((Object)diagramElements);
        identifiedObject.addDiagramElement((DiagramElement)this.getXmlContext().getXmlObjectFactory().create(BPMNShape.class));
        junit.framework.Assert.assertTrue((boolean)identifiedObject.hasDiagramElement());
        diagramElements = identifiedObject.getDiagramElement();
        junit.framework.Assert.assertNotNull((Object)diagramElements);
        junit.framework.Assert.assertEquals((int)((Integer)this.getTestData(EXPECTED_NUMBER_DIAGRAMELEMENT) + 1), (int)diagramElements.length);
        identifiedObject.addDiagramElement((DiagramElement)this.getXmlContext().getXmlObjectFactory().create(BPMNEdge.class));
        junit.framework.Assert.assertTrue((boolean)identifiedObject.hasDiagramElement());
        diagramElements = identifiedObject.getDiagramElement();
        junit.framework.Assert.assertNotNull((Object)diagramElements);
        junit.framework.Assert.assertEquals((int)((Integer)this.getTestData(EXPECTED_NUMBER_DIAGRAMELEMENT) + 2), (int)diagramElements.length);
    }

    @Test
    public void testUnsetAllChildren() {
        BPMNPlane identifiedObject = (BPMNPlane)this.newXmlObjectUnderTest();
        identifiedObject.unsetDiagramElement();
        junit.framework.Assert.assertFalse((boolean)identifiedObject.hasDiagramElement());
    }
}

