/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn20diagram.api;

import com.ebmwebsourcing.easybox.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNDiagram;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNLabelStyle;
import com.ebmwebsourcing.easybpmn.bpmn20diagram.api.element.BPMNPlane;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class BPMNDiagramChildrenTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_DOC = "expectedDOC";
    public static final String EXPECTED_RESOLUTION = "expectedResolution";
    public static final String EXPECTED_PLANE_ID = "planeId";
    public static final String EXPECTED_NUMBER_BPMNLABELSTYLE = "numberOfBPMNLabelStyle";

    public BPMNDiagramChildrenTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testGetChildren() {
        BPMNDiagram diagram = (BPMNDiagram)this.newObjectUnderTest();
        if (this.getTestData(EXPECTED_PLANE_ID) != null) {
            BPMNPlane plane = diagram.getBPMNPlane();
            Assert.assertNotNull((Object)plane);
            Assert.assertEquals((Object)this.getTestData(EXPECTED_PLANE_ID), (Object)plane.getId());
        }
        BPMNLabelStyle[] styles = diagram.getBPMNLabelStyle();
        Assert.assertNotNull((Object)styles);
        Assert.assertEquals((Object)this.getTestData(EXPECTED_NUMBER_BPMNLABELSTYLE), (Object)styles.length);
        if (this.getTestData(EXPECTED_DOC) != null) {
            Assert.assertEquals((Object)this.getTestData(EXPECTED_DOC), (Object)diagram.getDocumentation());
        }
        if (this.getTestData(EXPECTED_RESOLUTION) != null) {
            Assert.assertEquals((Object)this.getTestData(EXPECTED_RESOLUTION), (Object)diagram.getResolution());
        }
    }

    @Test
    public void testSetPlane() {
        BPMNDiagram diagram = (BPMNDiagram)this.newObjectUnderTest();
        BPMNPlane newPlane = (BPMNPlane)this.getXmlContext().getXmlObjectFactory().create(BPMNPlane.class);
        newPlane.setBpmnElement(new QName("newlocalpart"));
        newPlane.setId("newId");
        diagram.setBPMNPlane(newPlane);
        Assert.assertTrue((boolean)diagram.hasBPMNPlane());
        BPMNPlane plane = diagram.getBPMNPlane();
        Assert.assertNotNull((Object)plane);
        Assert.assertEquals((String)"newId", (String)plane.getId());
        Assert.assertEquals((String)"newlocalpart", (String)plane.getBpmnElement().toString());
    }

    @Test
    public void testRemoveChildStyle() {
        BPMNDiagram identifiedObject = (BPMNDiagram)this.newXmlObjectUnderTest();
        BPMNLabelStyle[] styles = identifiedObject.getBPMNLabelStyle();
        Assert.assertNotNull((Object)styles);
        if (styles.length > 0) {
            identifiedObject.removeBPMNLabelStyle(styles[0]);
            styles = identifiedObject.getBPMNLabelStyle();
            Assert.assertEquals((int)((Integer)this.getTestData(EXPECTED_NUMBER_BPMNLABELSTYLE) - 1), (int)styles.length);
        }
    }

    @Test
    public void testAddChildStyle() {
        BPMNDiagram identifiedObject = (BPMNDiagram)this.newXmlObjectUnderTest();
        BPMNLabelStyle[] styles = identifiedObject.getBPMNLabelStyle();
        Assert.assertNotNull((Object)styles);
        Assert.assertEquals((Object)this.getTestData(EXPECTED_NUMBER_BPMNLABELSTYLE), (Object)styles.length);
        identifiedObject.addBPMNLabelStyle((BPMNLabelStyle)this.getXmlContext().getXmlObjectFactory().create(BPMNLabelStyle.class));
        Assert.assertTrue((boolean)identifiedObject.hasBPMNLabelStyle());
        styles = identifiedObject.getBPMNLabelStyle();
        Assert.assertNotNull((Object)styles);
        Assert.assertEquals((int)((Integer)this.getTestData(EXPECTED_NUMBER_BPMNLABELSTYLE) + 1), (int)styles.length);
    }

    @Test
    public void testUnsetAllChildren() {
        BPMNDiagram identifiedObject = (BPMNDiagram)this.newXmlObjectUnderTest();
        identifiedObject.unsetBPMNLabelStyle();
        identifiedObject.unsetResolution();
        Assert.assertFalse((boolean)identifiedObject.hasBPMNLabelStyle());
        Assert.assertFalse((boolean)identifiedObject.hasResolution());
    }

    @Test
    public void testSettters() {
        BPMNDiagram identifiedObject = (BPMNDiagram)this.newXmlObjectUnderTest();
        identifiedObject.setDocumentation("newDoc");
        identifiedObject.setResolution(123456.0);
        Assert.assertTrue((boolean)identifiedObject.hasDocumentation());
        Assert.assertTrue((boolean)identifiedObject.hasResolution());
        Assert.assertEquals((String)"newDoc", (String)identifiedObject.getDocumentation());
        Assert.assertEquals((Object)123456.0, (Object)identifiedObject.getResolution());
    }
}

