/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn2bpel;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.DefinitionsHelper;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Collaboration;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EventBasedGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.EventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ExclusiveGateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowElement;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.FlowNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Gateway;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.MessageEventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Operation;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Process;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SendTask;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.SequenceFlow;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithEventDefinition;
import com.ebmwebsourcing.easybpmn.bpmn20.api.with.WithFlowElements;
import com.ebmwebsourcing.easyplnk20.api.element.PartnerLinkType;
import com.ebmwebsourcing.easyplnk20.api.element.Role;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class BPELGeneratorHelper {
    private static String VARNAME_SUFFIX = "Variable";

    public static Map<Gateway, Set<SequenceFlow>> findLoopDivergers(WithFlowElements wfe, Collection<? extends FlowElement> starts) {
        HashMap<Gateway, Set<SequenceFlow>> result = new HashMap<Gateway, Set<SequenceFlow>>();
        ArrayList<List<FlowElement>> loops = new ArrayList<List<FlowElement>>();
        for (FlowElement flowElement : starts) {
            ArrayList<FlowElement> visited = new ArrayList<FlowElement>();
            BPELGeneratorHelper.followPath(flowElement, visited, loops);
        }
        for (List list : loops) {
            Gateway diverger = null;
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof ExclusiveGateway) && !(list.get(i) instanceof EventBasedGateway) || ((FlowNode)list.get(i)).getOutgoingFlowNodes().size() <= 1) continue;
                diverger = (Gateway)list.get(i);
                break;
            }
            FlowElement next = null;
            int index = list.indexOf(diverger);
            next = index == list.size() - 1 ? (FlowElement)list.get(0) : (FlowElement)list.get(index + 1);
            SequenceFlow outgoer = null;
            for (SequenceFlow sf : wfe.getFlowElementsByClass(SequenceFlow.class)) {
                if (!sf.getSourceRef().getId().equals(diverger.getId()) || !sf.getTargetRef().getId().equals(next.getId())) continue;
                outgoer = sf;
                break;
            }
            if (!result.containsKey(diverger)) {
                result.put(diverger, new HashSet());
            }
            ((Set)result.get(diverger)).add(outgoer);
        }
        return result;
    }

    private static void followPath(FlowElement fe, List<FlowElement> visited, List<List<FlowElement>> loops) {
        if (visited.contains(fe)) {
            int index = visited.indexOf(fe);
            List<FlowElement> l = visited.subList(index, visited.size());
            loops.add(l);
        } else {
            FlowNode fn;
            ArrayList<FlowElement> l = new ArrayList<FlowElement>(visited);
            l.add(fe);
            if (fe instanceof FlowNode && (fn = (FlowNode)fe).getOutgoing() != null) {
                for (FlowNode next : fn.getOutgoingFlowNodes()) {
                    BPELGeneratorHelper.followPath((FlowElement)next, l, loops);
                }
            }
        }
    }

    public static PartnerLink findPartnerLinkFromInterface(QName itf, BPELProcess process, Set<PartnerLinkType> plts) throws BPELException {
        ArrayList<PartnerLinkType> validPLT = new ArrayList<PartnerLinkType>();
        for (PartnerLinkType plt : plts) {
            for (Role r : plt.getRoles()) {
                if (!r.getPortType().equals(itf)) continue;
                validPLT.add(plt);
            }
        }
        for (PartnerLinkType plt : validPLT) {
            String pltNS = BPELGeneratorHelper.getPartnerLinkTypeNS(plt);
            for (PartnerLink pl : process.getPartnerLinks()) {
                if (!pl.getPartnerLinkType().getNamespaceURI().equals(pltNS) || !pl.getPartnerLinkType().getLocalPart().equals(plt.getName())) continue;
                return pl;
            }
        }
        return null;
    }

    public static String getPartnerLinkTypeNS(PartnerLinkType plt) {
        return ((Definitions)plt.getXmlObjectParent()).getTargetNamespace();
    }

    public static Set<FlowNode> getAllStartingNodes(Process proc) {
        HashSet<FlowNode> startingNodes = new HashSet<FlowNode>();
        HashSet<FlowNode> alreadyVisitedNodes = new HashSet<FlowNode>();
        for (FlowNode fn : proc.getFlowNode()) {
            BPELGeneratorHelper.followPathBackWards(fn, startingNodes, alreadyVisitedNodes);
        }
        return startingNodes;
    }

    private static void followPathBackWards(FlowNode fn, Set<FlowNode> startingNodes, Set<FlowNode> alreadyVisitedNodes) {
        if (alreadyVisitedNodes.contains(fn)) {
            return;
        }
        List incoming = fn.getIncomingFlowNodes();
        if (incoming.isEmpty()) {
            startingNodes.add(fn);
        } else {
            alreadyVisitedNodes.add(fn);
            for (FlowNode preceding : incoming) {
                BPELGeneratorHelper.followPathBackWards(preceding, startingNodes, alreadyVisitedNodes);
            }
        }
    }

    public static String getFileNameFromImportLocation(String location) {
        int index = location.lastIndexOf("/");
        if (index != -1) {
            if (index == location.length() - 1) {
                return BPELGeneratorHelper.getFileNameFromImportLocation(location.substring(0, index));
            }
            return location.substring(index + 1);
        }
        return location;
    }

    public static void addDefaultExternalParticipant(com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions defs) {
        for (Collaboration coll : defs.getCollaborations()) {
            ArrayList<QName> referencedInterfaces = new ArrayList<QName>();
            for (Participant p : coll.getParticipant()) {
                for (QName itfRef : p.getInterfaceRef()) {
                    referencedInterfaces.add(itfRef);
                }
            }
            ArrayList<QName> notReferencedInterfaces = new ArrayList<QName>();
            for (Interface itf : defs.getInterfaces()) {
                QName itfQname = new QName(itf.getId());
                if (referencedInterfaces.contains(itfQname)) continue;
                notReferencedInterfaces.add(itfQname);
            }
            if (notReferencedInterfaces.isEmpty()) continue;
            Participant p = (Participant)defs.getXmlContext().getXmlObjectFactory().create(Participant.class);
            p.setId("defaultParticipant");
            p.setName("defaultParticipant");
            for (QName itfRef : notReferencedInterfaces) {
                p.addInterfaceRef(itfRef);
            }
            coll.addParticipant(p);
        }
    }

    public static String getBPELProcessName(Process bpmnProcess) {
        return bpmnProcess.hasName() && !bpmnProcess.getName().isEmpty() ? bpmnProcess.getName().replace(" ", "") : bpmnProcess.getId();
    }

    public static String getVariableName(String prefix) {
        return prefix + VARNAME_SUFFIX;
    }

    public static boolean isReply(SendTask st, Participant participant, com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions defs) throws BPMNException {
        return BPELGeneratorHelper.isOperationExposed(st.getOperationRef(), participant, defs);
    }

    public static boolean isReply(MessageEventDefinition ed, Participant participant, com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions defs) throws BPMNException {
        return BPELGeneratorHelper.isOperationExposed(ed.getOperationRef(), participant, defs);
    }

    private static boolean isOperationExposed(QName operationRef, Participant participant, com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions defs) throws BPMNException {
        Operation op = (Operation)DefinitionsHelper.findBPMNObject((com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions)defs, (QName)operationRef, Operation.class);
        Interface itf = (Interface)op.getXmlObjectParent();
        if (participant.hasInterfaceRef()) {
            for (QName itfRef : participant.getInterfaceRef()) {
                if (!itf.equals(DefinitionsHelper.findBPMNObject((com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions)defs, (QName)itfRef, Interface.class))) continue;
                return true;
            }
        }
        return false;
    }

    public static EventDefinition getEventDefinition(WithEventDefinition wed, com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions defs) throws BPMNException {
        if (wed.hasEventDefinition()) {
            return wed.getEventDefinition()[0];
        }
        if (wed.hasEventDefinitionRef()) {
            return (EventDefinition)DefinitionsHelper.findBPMNObject((com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions)defs, (QName)wed.getEventDefinitionRef()[0], EventDefinition.class);
        }
        return null;
    }
}

