/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.bpmn2bpel.wsdl;

import com.ebmwebsourcing.easybox.api.XmlContext;
import com.ebmwebsourcing.easybox.api.XmlContextFactory;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybpmn.bpmn20.api.BPMNException;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Interface;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.Participant;
import com.ebmwebsourcing.easyschema10.api.element.Import;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class WSDLGeneratorHelper {
    public static final String PLTSuffix = "PLT";
    private static Map<Interface, Definitions> definitions;
    private static XmlContext context;

    public static void init() {
        definitions = new HashMap<Interface, Definitions>();
    }

    public static Definitions getOrCreateDefinitions(Interface itf) {
        if (definitions.containsKey(itf)) {
            return definitions.get(itf);
        }
        Definitions res = (Definitions)context.getXmlObjectFactory().create(Definitions.class);
        definitions.put(itf, res);
        return res;
    }

    public static Collection<Definitions> getAllDefinitions() {
        return definitions.values();
    }

    public static String getArtefactNamespace(String targetNamespace) {
        String artefactNS = null;
        artefactNS = targetNamespace.endsWith("/") ? targetNamespace + "artefacts" : targetNamespace + "/artefacts";
        return artefactNS;
    }

    public static Definitions findDefinitionsContainingInterfaceInImports(QName itfQname, com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions bpmnDefinitions) throws BPMNException {
        for (com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import impt : bpmnDefinitions.getImports()) {
            Definitions defs;
            PortType pt;
            if (!impt.getNamespace().equals(itfQname.getNamespaceURI()) || !impt.isWSDL11Import() || (pt = (defs = impt.getWSDL11Definitions()).getPortTypeByName(itfQname.getLocalPart())) == null) continue;
            return defs;
        }
        return null;
    }

    public static String getPartnerLinkTypeName(Participant participant, Interface itf) {
        return participant.getName() + "_" + itf.getName() + PLTSuffix;
    }

    public static Port findPortInImports(QName portQname, com.ebmwebsourcing.easybpmn.bpmn20.api.element.Definitions bpmnDefinitions) throws BPMNException {
        for (com.ebmwebsourcing.easybpmn.bpmn20.api.element.Import impt : bpmnDefinitions.getImports()) {
            if (!impt.getNamespace().equals(portQname.getNamespaceURI()) || !impt.isWSDL11Import()) continue;
            Definitions defs = impt.getWSDL11Definitions();
            for (Service service : defs.getServices()) {
                Port port = service.getPortByName(portQname.getLocalPart());
                if (port == null) continue;
                return port;
            }
        }
        return null;
    }

    public static Map<String, Schema> findImportedSchemas(Schema parent) {
        HashMap<String, Schema> res = new HashMap<String, Schema>();
        HashSet<String> alreadyImportedSchemas = new HashSet<String>();
        res.putAll(WSDLGeneratorHelper.findImportedSchemas(parent, alreadyImportedSchemas, 0));
        return res;
    }

    private static Map<String, Schema> findImportedSchemas(Schema parent, Set<String> alreadyImportedSchemas, int cpt) {
        HashMap<String, Schema> res = new HashMap<String, Schema>();
        for (Import impt : parent.getImports()) {
            if (alreadyImportedSchemas.contains(impt.getNamespace()) || !WSDLGeneratorHelper.isRelativeUrl(impt.getSchemaLocation())) continue;
            for (XmlObjectNode child : impt.getXmlObjectAdoptedChildren()) {
                if (!(child instanceof Schema)) continue;
                String importName = impt.getSchemaLocation().substring(impt.getSchemaLocation().lastIndexOf("/") + 1);
                if (res.containsKey(importName)) {
                    importName = importName + "_" + cpt++;
                }
                impt.setSchemaLocation(importName);
                res.put(importName, (Schema)child);
                alreadyImportedSchemas.add(impt.getNamespace());
                res.putAll(WSDLGeneratorHelper.findImportedSchemas((Schema)child, alreadyImportedSchemas, cpt));
            }
        }
        return res;
    }

    private static boolean isRelativeUrl(String schemaLocation) {
        try {
            new URL(schemaLocation);
        }
        catch (MalformedURLException e) {
            return true;
        }
        return false;
    }

    static {
        context = new XmlContextFactory().newContext();
    }
}

