/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.model.bpmn.tools.bpmn2bpel;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElement;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELElementImpl;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.api.BPELProcess;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Activity;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Assign;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Empty;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Flow;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.If;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Invoke;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Pick;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Receive;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Reply;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Scope;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Sequence;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.Wait;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.While;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.Copy;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.From;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4assign.To;
import com.ebmwebsourcing.easybpel.model.bpel.api.activity.element.elements4pick.OnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.api.partnerLink.PartnerLink;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELElementVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.variable.BPELVariable;
import com.ebmwebsourcing.easybpel.model.bpel.api.wsdlImports.Import;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TAssign;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TBooleanExpr;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TCopy;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TEmpty;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TExpression;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFlow;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TFrom;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TIf;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TImport;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TInvoke;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TOnMessage;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TPick;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TProcess;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReceive;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TReply;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TSequence;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TTo;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TWait;
import com.ebmwebsourcing.easybpel.model.bpel.executable.TWhile;
import com.ebmwebsourcing.easybpel.model.bpel.impl.BPELProcessImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.AssignImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.EmptyImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.FlowImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.IfImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.InvokeImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.PickImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ReceiveImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.ReplyImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.SequenceImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.WaitImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.WhileImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.CopyImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.FromImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4assign.ToImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.activity.element.elements4pick.OnMessageImpl;
import com.ebmwebsourcing.easybpel.model.bpel.impl.wsdlImports.ImportImpl;
import com.ebmwebsourcing.easybpel.xpath.exp.api.BPELBooleanExpression;
import com.ebmwebsourcing.easybpel.xpath.exp.api.XPathExpressionException;
import com.ebmwebsourcing.easybpel.xpath.exp.impl.BPELBooleanExpressionImpl;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.AbstractBPMNElementImpl;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.BPMNElement;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.BPMNException;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.collaboration.Collaboration;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.collaboration.Pool;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.common.FlowElement;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.common.FlowNode;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.common.Message;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.infrastructure.Definitions;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.Process;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.activity.ReceiveTask;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.activity.SendTask;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.activity.ServiceTask;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.activity.Task;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.data.Assignement;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.data.DataAssociation;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.data.Expression;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.event.EndEvent;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.event.Event;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.event.IntermediateReceiveEvent;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.event.IntermediateSendEvent;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.event.StartEvent;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.event.definition.EventDefinition;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.gateway.ExclusiveGateway;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.gateway.Gateway;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.gateway.ParallelGateway;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.gateway.SequenceFlow;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.service.Interface;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.util.BPMNUtil;
import com.ebmwebsourcing.easybpmn.model.bpmn.jaxb.TEventDefinition;
import com.ebmwebsourcing.easybpmn.model.bpmn.jaxb.TMessageEventDefinition;
import com.ebmwebsourcing.easybpmn.model.bpmn.jaxb.TTimerEventDefinition;
import com.ebmwebsourcing.easybpmn.model.bpmn.tools.bpmn2bpel.BPELGeneratorHelper;
import com.ebmwebsourcing.easybpmn.model.bpmn.tools.bpmn2bpel.GenerationProperties;
import com.ebmwebsourcing.easybpmn.model.bpmn.tools.bpmn2bpel.WSDLGenerator;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.PartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Role;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.WSDL4BPELException;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.wsdl.api.Description;

public class BPELGenerator {
    private static Logger log = Logger.getLogger(BPELProcessImpl.class.getName());

    public List<BPELProcess> generate(Definitions def) throws BPMNException {
        System.out.println("***** definitions are: " + def.getId());
        return this.generate(def, new GenerationProperties());
    }

    public List<BPELProcess> generate(Definitions def, GenerationProperties gp) throws BPMNException {
        ArrayList<BPELProcess> res = new ArrayList<BPELProcess>();
        WSDLGenerator wsdlGen = new WSDLGenerator();
        List<Description> descs = wsdlGen.generate(def, gp);
        gp.setDescs(descs);
        for (Collaboration c : def.getCollaborations()) {
            for (Pool pool : c.getPools()) {
                BPELProcess bpel = this.generate(pool, gp);
                res.add(bpel);
            }
        }
        return res;
    }

    public BPELProcess generate(Pool pool, GenerationProperties gp) throws BPMNException {
        BPELProcessImpl res = null;
        Process p = pool.getProcess();
        res = new BPELProcessImpl(URI.create(BPELGeneratorHelper.cleanStringForURICreation(p.getName())), new TProcess(), null, null);
        res.setName(p.getName());
        res.setTargetNamespace(p.getDefinitions().getTargetNamespace());
        if (gp != null) {
            gp.setBpelProcess((BPELProcess)res);
            org.ow2.easywsdl.extensions.wsdl4bpel.api.Description artefactDesc = gp.getArtefactDesc();
            this.addDescriptionImport((BPELProcess)res, artefactDesc);
        }
        WSDLGenerator wsdlGen = new WSDLGenerator();
        PartnerLink pl = res.createPartnerLink();
        if (pool.getParticipant() != null) {
            gp.setParticipant(pool.getParticipant());
            if (pool.getParticipant().getName() != null && !pool.getParticipant().getName().isEmpty()) {
                pl.setName(pool.getParticipant().getName());
            } else {
                pl.setName(pool.getName().concat("_Participant"));
            }
        }
        if (pool.getParticipant().getPartnerRole() != null) {
            pl.setMyRole(pool.getParticipant().getPartnerRole().getName());
        }
        if (pool.getParticipant() != null && wsdlGen.getPartnerLinkTypeName(pool, pool.getParticipant()) != null) {
            pl.setPartnerLinkType(wsdlGen.getPartnerLinkTypeName(pool, pool.getParticipant()));
        }
        List<Message> msgs = this.getMessagesFromTasks(p.getTasks());
        this.generateVariablesFromMessages(msgs, gp);
        this.genrateProcess((BPELProcess)res, pool.getProcess(), gp);
        return res;
    }

    public void generateVariablesFromMessages(List<Message> msgs, GenerationProperties gp) {
        for (Message msg : msgs) {
            this.creatOrFindVariableFromMessage(msg, gp.getBpelProcess());
        }
    }

    public List<Message> getMessagesFromTasks(List<Task> tasks) {
        ArrayList<Message> msgs = new ArrayList<Message>();
        for (Task t : tasks) {
            if (t instanceof SendTask) {
                msgs.add(((SendTask)t).getMessage());
                continue;
            }
            if (t instanceof ReceiveTask) {
                msgs.add(((ReceiveTask)t).getMessage());
                continue;
            }
            if (!(t instanceof ServiceTask)) continue;
            msgs.add(((ServiceTask)t).getOperation().getMessageIn());
            msgs.add(((ServiceTask)t).getOperation().getMessageOut());
        }
        return msgs;
    }

    public void genrateProcess(BPELProcess bpel, Process bpmn, GenerationProperties gp) throws BPMNException {
        try {
            SequenceImpl seqMain = new SequenceImpl(new TSequence(), (BPELElement)bpel);
            seqMain.setName("main");
            bpel.setActivity((Activity)seqMain);
            List<ReceiveTask> receives = this.detectAllInitReceiveTasks(bpmn);
            gp.setLoopers(BPELGeneratorHelper.findLoopDivergers(bpmn, receives));
            this.generatePick((Activity)seqMain, receives, gp);
        }
        catch (BPELException e) {
            throw new BPMNException((Throwable)e);
        }
    }

    public List<ReceiveTask> detectAllInitReceiveTasks(Process bpmn) {
        ArrayList<ReceiveTask> res = new ArrayList<ReceiveTask>();
        List startEvents = bpmn.getStartEvents();
        if (startEvents.size() > 0) {
            for (StartEvent se : startEvents) {
                for (FlowElement a : se.getOutgoingActivities()) {
                    if (!(a instanceof ReceiveTask) || !((ReceiveTask)a).isInstanciate()) continue;
                    res.add((ReceiveTask)a);
                }
            }
        }
        return res;
    }

    public Pick generatePick(Activity parent, List<ReceiveTask> tasks, GenerationProperties gp) throws BPMNException {
        PickImpl res = null;
        try {
            if (tasks.size() > 0) {
                res = new PickImpl(new TPick(), (BPELElement)parent);
                this.addActivityInParent((BPELElement)res, (BPELElement)parent, gp);
                for (ReceiveTask rt : tasks) {
                    this.generateOnMessage(rt, (Pick)res, gp);
                }
            }
        }
        catch (BPELException e) {
            throw new BPMNException((Throwable)e);
        }
        return res;
    }

    public Activity generateNextActivity(FlowElement a, BPELElement parent, GenerationProperties gp) throws BPELException {
        System.out.println("************* FlowElement: " + a.getName() + " --- instance of class: " + a.getClass());
        Flow ua = null;
        if (a instanceof Task) {
            Task t = (Task)a;
            System.out.println("************* Taskes: " + t.getName());
            if (t.getOutgoingActivities().size() > 1) {
                Flow f;
                ua = f = this.generateFlow((com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.activity.Activity)a, parent, gp);
            } else if (t.getOutgoingActivities().size() == 1) {
                Sequence seq = this.generateSequence((FlowNode)((com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.activity.Activity)a), parent, gp);
                ua = seq;
            }
        } else if (a instanceof Gateway) {
            Gateway g = (Gateway)a;
            System.out.println("************* gateways: " + g.getName());
            if (g.getOutgoingActivities().size() > 1) {
                Activity f = this.generateActivityFromGateway(g, (Activity)parent, gp);
                ua = f;
            } else if (g.getOutgoingActivities().size() == 1) {
                SequenceImpl seq = new SequenceImpl(new TSequence(), parent);
                this.addActivityInParent((BPELElement)seq, parent, gp);
                ua = this.generateActivity((FlowElement)g.getOutgoingActivities().get(0), (Activity)seq, gp);
                System.out.println("ua = " + ua.getName());
            }
        } else if (a instanceof Event) {
            Event e = (Event)a;
            System.out.println("************* events: " + e.getName());
            if (e.getOutgoingActivities().size() != 0) {
                if (e.getOutgoingActivities().size() > 1) {
                    Flow f;
                    ua = f = this.generateFlow((com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.activity.Activity)a, parent, gp);
                } else if (e.getOutgoingActivities().size() == 1) {
                    SequenceImpl seq = new SequenceImpl(new TSequence(), parent);
                    this.addActivityInParent((BPELElement)seq, parent, gp);
                    ua = this.generateActivity((FlowElement)e.getOutgoingActivities().get(0), (Activity)seq, gp);
                    System.out.println("ua = " + ua.getName());
                }
            }
        }
        return ua;
    }

    public Sequence generateSequence(FlowNode a, BPELElement parent, GenerationProperties gp) throws BPELException {
        Sequence seq = null;
        System.out.println("******* Flow node is: " + a.getName());
        if (parent instanceof Sequence) {
            seq = (Sequence)parent;
        } else {
            seq = new SequenceImpl(new TSequence(), parent);
            this.addActivityInParent((BPELElement)seq, parent, gp);
        }
        System.out.println("a.getOutgoingActivities().get(0) = " + (FlowElement)a.getOutgoingActivities().get(0));
        this.generateActivity((FlowElement)a.getOutgoingActivities().get(0), (Activity)seq, gp);
        return seq;
    }

    public Flow generateFlow(com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.process.activity.Activity a, BPELElement parent, GenerationProperties gp) throws BPELException {
        FlowImpl flow = new FlowImpl(new TFlow(), parent);
        this.addActivityInParent((BPELElement)flow, (BPELElement)((Activity)parent), gp);
        for (FlowElement elmt : a.getOutgoingActivities()) {
            this.generateActivity(elmt, (Activity)flow, gp);
        }
        return flow;
    }

    public Activity generateActivity(FlowElement flowElement, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        Activity res = null;
        System.out.println("*************** flow element: " + flowElement);
        if (flowElement instanceof Task) {
            res = this.generateActivityFromTask((Task)flowElement, seqOrFlowOrScope, gp);
        } else if (flowElement instanceof Gateway) {
            res = this.generateActivityFromGateway((Gateway)flowElement, seqOrFlowOrScope, gp);
        } else if (!(flowElement instanceof EndEvent)) {
            if (flowElement instanceof IntermediateReceiveEvent) {
                res = this.generateActivityFromEvent((Event)flowElement, seqOrFlowOrScope, gp);
            } else if (flowElement instanceof IntermediateSendEvent) {
                res = this.generateActivityFromEvent((Event)flowElement, seqOrFlowOrScope, gp);
            } else {
                throw new NotImplementedException("Sorry but this element: " + flowElement.getClass() + " cannot be generated into a bpel activity");
            }
        }
        return res;
    }

    public Activity generateActivityFromEvent(Event a, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        Receive res = null;
        if (a != null) {
            Wait wait;
            TEventDefinition ted;
            EventDefinition ed;
            int i;
            List eds;
            if (a instanceof IntermediateReceiveEvent) {
                eds = ((IntermediateReceiveEvent)a).getTriggers();
                for (i = 0; i < eds.size(); ++i) {
                    ed = (EventDefinition)eds.get(i);
                    ted = (TEventDefinition)((AbstractSchemaElementImpl)ed).getModel();
                    if (ted instanceof TMessageEventDefinition) {
                        Receive receive;
                        res = receive = this.generateReceiveIntEvent((IntermediateReceiveEvent)a, seqOrFlowOrScope, gp);
                        continue;
                    }
                    if (!(ted instanceof TTimerEventDefinition)) continue;
                    wait = this.generateWaitIntEvent((IntermediateReceiveEvent)a, seqOrFlowOrScope, gp);
                    res = wait;
                }
            }
            if (a instanceof IntermediateSendEvent) {
                eds = ((IntermediateSendEvent)a).getResults();
                for (i = 0; i < eds.size(); ++i) {
                    ed = (EventDefinition)eds.get(i);
                    ted = (TEventDefinition)((AbstractSchemaElementImpl)ed).getModel();
                    if (ted instanceof TMessageEventDefinition) {
                        Reply reply = this.generateSendIntEvent((IntermediateSendEvent)a, seqOrFlowOrScope, gp);
                        res = reply;
                        continue;
                    }
                    if (!(ted instanceof TTimerEventDefinition)) continue;
                    wait = this.generateWaitIntSendEvent((IntermediateSendEvent)a, seqOrFlowOrScope, gp);
                    res = wait;
                }
            }
            this.generateNextActivity((FlowElement)a, (BPELElement)seqOrFlowOrScope, gp);
        }
        return res;
    }

    public Wait generateWaitIntSendEvent(IntermediateSendEvent a, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        WaitImpl wait = new WaitImpl(new TWait(), (BPELElement)seqOrFlowOrScope);
        this.addActivityInParent((BPELElement)wait, (BPELElement)seqOrFlowOrScope, gp);
        wait.setName(a.getName());
        return wait;
    }

    public Wait generateWaitIntEvent(IntermediateReceiveEvent a, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        WaitImpl wait = new WaitImpl(new TWait(), (BPELElement)seqOrFlowOrScope);
        this.addActivityInParent((BPELElement)wait, (BPELElement)seqOrFlowOrScope, gp);
        wait.setName(a.getName());
        return wait;
    }

    public Reply generateSendIntEvent(IntermediateSendEvent a, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        ReplyImpl reply = new ReplyImpl(new TReply(), (BPELElement)seqOrFlowOrScope);
        this.addActivityInParent((BPELElement)reply, (BPELElement)seqOrFlowOrScope, gp);
        reply.setName(a.getName());
        return reply;
    }

    public Receive generateReceiveIntEvent(IntermediateReceiveEvent a, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        ReceiveImpl receive = new ReceiveImpl(new TReceive(), (BPELElement)seqOrFlowOrScope);
        this.addActivityInParent((BPELElement)receive, (BPELElement)seqOrFlowOrScope, gp);
        receive.setName(a.getName());
        return receive;
    }

    public Activity generateActivityFromGateway(Gateway gateway, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        Flow res = null;
        if (gateway instanceof ExclusiveGateway) {
            ExclusiveGateway eg = (ExclusiveGateway)gateway;
            if (gp.getAlreadyGeneratedLoops().contains(gateway)) {
                if (gp.getAlreadyGeneratedLoopExit().contains(gateway)) {
                    return null;
                }
                gp.getAlreadyGeneratedLoopExit().add(eg);
                return this.generateActivity(gp.getLoopExit(eg), gp.getCurrentWhileParent(), gp);
            }
            if (gp.isLoopDiverger(eg)) {
                gp.getAlreadyGeneratedLoops().add(eg);
                this.generateWhile(eg, gp.getLoopingFlows(eg), seqOrFlowOrScope, gp);
            } else {
                res = this.generateIf(eg, seqOrFlowOrScope, gp);
            }
        } else if (gateway instanceof ParallelGateway) {
            res = this.generateFlow((ParallelGateway)gateway, seqOrFlowOrScope, gp);
        } else {
            throw new NotImplementedException("Sorry but this element: " + gateway.getClass() + " cannot be generated into a bpel activity");
        }
        return res;
    }

    public void generateWhile(ExclusiveGateway eg, Set<SequenceFlow> loopingFlows, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        BPELBooleanExpressionImpl cond;
        System.out.println("*************While for : " + eg);
        TWhile model = new TWhile();
        WhileImpl while_ = new WhileImpl(model, (BPELElement)seqOrFlowOrScope);
        while_.setName(eg.getName());
        gp.setCurrentWhileParent(seqOrFlowOrScope);
        TBooleanExpr expr = new TBooleanExpr();
        try {
            cond = new BPELBooleanExpressionImpl((TExpression)expr, (BPELElement)while_);
        }
        catch (XPathExpressionException e) {
            throw new BPELException((Throwable)e);
        }
        Process p = BPMNUtil.getProcess((BPMNElement)eg);
        SequenceFlow nonlooper = null;
        for (SequenceFlow sf : p.getSequenceFlows()) {
            if (!sf.getSourceNode().getId().equals(eg.getId()) || loopingFlows.contains(sf)) continue;
            nonlooper = sf;
            break;
        }
        String loopCondition = "not(" + nonlooper.getExpression().getContent() + ")";
        cond.setContent((Object)loopCondition);
        while_.setCondition((BPELBooleanExpression)cond);
        model.setCondition(expr);
        this.addActivityInParent((BPELElement)while_, (BPELElement)seqOrFlowOrScope, gp);
        try {
            this.generateWhileInsideIf(eg, loopingFlows, (While)while_, model, gp);
        }
        catch (XPathExpressionException e) {
            throw new BPELException((Throwable)e);
        }
    }

    private void generateWhileInsideIf(ExclusiveGateway eg, Collection<SequenceFlow> loopingFlows, While while_, TWhile model, GenerationProperties gp) throws BPELException, XPathExpressionException {
        TSequence sm = new TSequence();
        SequenceImpl seq = new SequenceImpl(sm, (BPELElement)while_);
        seq.setName(while_.getName() + "Seq");
        while_.setActivity((Activity)seq);
        model.setSequence(sm);
        ArrayList<FlowElement> activities = new ArrayList<FlowElement>();
        for (SequenceFlow sf : loopingFlows) {
            activities.add(sf.getTargetNode());
        }
        this.generateIf(activities, (Activity)seq, eg, gp);
    }

    public static Flow getCurrentFlow(BPELElement parent) {
        Flow res = null;
        if (parent != null) {
            res = parent instanceof Flow ? (Flow)parent : BPELGenerator.getCurrentFlow((BPELElement)((AbstractSchemaElementImpl)parent).getParent());
        }
        return res;
    }

    public static If getCurrentIf(BPELElement parent) {
        If res = null;
        if (parent != null) {
            res = parent instanceof If ? (If)parent : BPELGenerator.getCurrentIf((BPELElement)((AbstractSchemaElementImpl)parent).getParent());
        }
        return res;
    }

    public Flow generateFlow(ParallelGateway gateway, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        FlowImpl flowA = null;
        System.out.println("found gateways: " + gateway.getId());
        List activities = gateway.getOutgoingActivities();
        System.out.println("outgoing activities are: " + activities);
        if (activities.size() > 0 && gateway.getIncomingActivities().size() == 1) {
            flowA = new FlowImpl(new TFlow(), (BPELElement)seqOrFlowOrScope);
            this.addActivityInParent((BPELElement)flowA, (BPELElement)seqOrFlowOrScope, gp);
            System.out.println("flow out size = " + activities.size());
            for (FlowElement elmt : activities) {
                SequenceImpl seq = new SequenceImpl(new TSequence(), (BPELElement)flowA);
                this.addActivityInParent((BPELElement)seq, (BPELElement)flowA, gp);
                this.generateActivity(elmt, (Activity)seq, gp);
            }
        } else {
            log.finest("end of parallel gateway => end of flow");
            if (!gp.getGatewaysAlreadyGenerated().contains(gateway)) {
                gp.getGatewaysAlreadyGenerated().add((Gateway)gateway);
                this.generateNextActivity((FlowElement)gateway, (BPELElement)((BPELElementImpl)BPELGenerator.getCurrentFlow((BPELElement)seqOrFlowOrScope)).getParent(), gp);
            }
        }
        return flowA;
    }

    public If generateIf(List<FlowElement> activities, Activity seqOrFlowOrScope, ExclusiveGateway eg, GenerationProperties gp) throws BPELException, XPathExpressionException {
        IfImpl ifA = new IfImpl(new TIf(), (BPELElement)seqOrFlowOrScope);
        this.addActivityInParent((BPELElement)ifA, (BPELElement)seqOrFlowOrScope, gp);
        System.out.println("if out size = " + activities.size());
        boolean first = true;
        for (FlowElement elmt : activities) {
            SequenceFlow sf;
            BPELBooleanExpressionImpl exp;
            SequenceImpl seq = new SequenceImpl(new TSequence(), (BPELElement)ifA);
            this.addActivityInParent((BPELElement)seq, (BPELElement)ifA, gp);
            this.generateActivity(elmt, (Activity)seq, gp);
            System.out.println("elmt.getId().toString() = " + elmt.getId().toString());
            if (eg.getDefault() != null && ((SequenceFlow)eg.getDefault()).getTargetNode().getId().toString().equals(elmt.getId().toString())) {
                exp = new BPELBooleanExpressionImpl((TExpression)new TBooleanExpr(), (BPELElement)ifA);
                ifA.addElseIfActivity((BPELBooleanExpression)exp, (Activity)seq);
                continue;
            }
            if (first) {
                exp = new BPELBooleanExpressionImpl((TExpression)new TBooleanExpr(), (BPELElement)ifA);
                sf = BPMNUtil.getSequenceFlowInProcess((Process)BPMNUtil.getProcess((BPMNElement)elmt), (FlowElement)eg, (FlowElement)elmt);
                exp.setContent((Object)sf.getExpression().getContent());
                ifA.addIfActivity((BPELBooleanExpression)exp, (Activity)seq);
                first = false;
                continue;
            }
            exp = new BPELBooleanExpressionImpl((TExpression)new TBooleanExpr(), (BPELElement)ifA);
            sf = BPMNUtil.getSequenceFlowInProcess((Process)BPMNUtil.getProcess((BPMNElement)elmt), (FlowElement)eg, (FlowElement)elmt);
            exp.setContent((Object)sf.getExpression().getContent());
            ifA.addElseIfActivity((BPELBooleanExpression)exp, (Activity)seq);
        }
        return ifA;
    }

    public If generateIf(ExclusiveGateway gateway, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        try {
            System.out.println("found gateways: " + gateway.getId());
            List activities = gateway.getOutgoingActivities();
            System.out.println("outgoing activities are: " + activities);
            if (activities.size() > 0 && gateway.getIncomingActivities().size() == 1) {
                return this.generateIf(activities, seqOrFlowOrScope, gateway, gp);
            }
            log.finest("end of exclusive gateway => end of if");
            if (!gp.getGatewaysAlreadyGenerated().contains(gateway)) {
                gp.getGatewaysAlreadyGenerated().add((Gateway)gateway);
                Activity a = this.generateNextActivity((FlowElement)gateway, (BPELElement)((BPELElementImpl)BPELGenerator.getCurrentIf((BPELElement)seqOrFlowOrScope)).getParent(), gp);
            }
        }
        catch (XPathExpressionException e) {
            throw new BPELException((Throwable)e);
        }
        return null;
    }

    public Activity generateActivityFromTask(Task a, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        Invoke res = null;
        if (a != null) {
            if (a.getDataInputAssociations().size() > 0) {
                this.generateAssign(a.getName(), a.getDataInputAssociations(), seqOrFlowOrScope, gp);
            }
            if (a instanceof ServiceTask) {
                Invoke invoke;
                res = invoke = this.generateInvoke((ServiceTask)a, seqOrFlowOrScope, gp);
            } else if (a instanceof ReceiveTask) {
                Receive receive = this.generateReceive((ReceiveTask)a, seqOrFlowOrScope, gp);
                res = receive;
            } else if (a instanceof SendTask) {
                if (this.isProcessEndingSendTask((SendTask)a)) {
                    Reply reply = this.generateReply((SendTask)a, seqOrFlowOrScope, gp);
                    res = reply;
                } else {
                    res = this.generateInvoke((SendTask)a, seqOrFlowOrScope, gp);
                }
            } else {
                Empty empty = this.generateEmpty(a, seqOrFlowOrScope, gp);
                res = empty;
            }
            if (a.getDataOutputAssociations().size() > 0) {
                this.generateAssign(a.getName(), a.getDataOutputAssociations(), seqOrFlowOrScope, gp);
            }
            this.generateNextActivity((FlowElement)a, (BPELElement)seqOrFlowOrScope, gp);
        }
        return res;
    }

    private boolean isProcessEndingSendTask(SendTask st) {
        if (st.getOutgoingActivities() == null || st.getOutgoingActivities().isEmpty()) {
            return true;
        }
        boolean allEndEvent = true;
        for (FlowElement a : st.getOutgoingActivities()) {
            if (a instanceof EndEvent) continue;
            allEndEvent = false;
            break;
        }
        return allEndEvent;
    }

    public Receive generateReceive(ReceiveTask a, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        assert (a != null);
        ReceiveImpl receive = new ReceiveImpl(new TReceive(), (BPELElement)seqOrFlowOrScope);
        this.addActivityInParent((BPELElement)receive, (BPELElement)seqOrFlowOrScope, gp);
        receive.setName(a.getName());
        receive.setCreateInstance(a.isInstanciate());
        receive.setOperation(a.getOperation().getName());
        for (Interface itf : gp.getParticipant().getInterfaces()) {
            if (itf.getOperation(a.getOperation().getName()) == null) continue;
            receive.setInterface(new QName(itf.getName()));
        }
        return receive;
    }

    public Invoke generateInvoke(ServiceTask a, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        InvokeImpl invoke = new InvokeImpl(new TInvoke(), (BPELElement)seqOrFlowOrScope);
        this.addActivityInParent((BPELElement)invoke, (BPELElement)seqOrFlowOrScope, gp);
        invoke.setName(a.getName());
        if (a.getOperation() != null) {
            invoke.setOperation(a.getOperation().getName());
        }
        invoke.setPartnerLink(gp.getParticipant().getName());
        for (Interface itf : gp.getParticipant().getInterfaces()) {
            if (itf.getOperation(a.getOperation().getName()) == null) continue;
            invoke.setInterface(new QName(itf.getName()));
        }
        return invoke;
    }

    public Invoke generateInvoke(SendTask a, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        InvokeImpl invoke = new InvokeImpl(new TInvoke(), (BPELElement)seqOrFlowOrScope);
        this.addActivityInParent((BPELElement)invoke, (BPELElement)seqOrFlowOrScope, gp);
        invoke.setName(a.getName());
        invoke.setOperation(a.getOperation().getName());
        invoke.setPartnerLink(gp.getParticipant().getName());
        invoke.setInterface(new QName(((Interface)gp.getParticipant().getInterfaces().get(0)).toString()));
        return invoke;
    }

    public Empty generateEmpty(Task a, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        EmptyImpl empty = new EmptyImpl(new TEmpty(), (BPELElement)seqOrFlowOrScope);
        this.addActivityInParent((BPELElement)empty, (BPELElement)seqOrFlowOrScope, gp);
        empty.setName(a.getName());
        return empty;
    }

    public Reply generateReply(SendTask a, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        ReplyImpl reply = new ReplyImpl(new TReply(), (BPELElement)seqOrFlowOrScope);
        this.addActivityInParent((BPELElement)reply, (BPELElement)seqOrFlowOrScope, gp);
        reply.setName(a.getName());
        reply.setOperation(a.getOperation().getName());
        reply.setInterface(new QName(a.getOperation().getDefinitions().getTargetNamespace(), ((Interface)((AbstractBPMNElementImpl)a.getOperation()).getParent()).getName()));
        reply.setPartnerLink(this.findPartnerLinkFromInterface(reply.getInterface(), gp.getBpelProcess(), gp.getArtefactDesc()).getName());
        BPELVariable var = this.creatOrFindVariableFromMessage(a.getMessage(), gp.getBpelProcess());
        reply.setOutputVariable(var.getQName().getLocalPart());
        return reply;
    }

    public void addActivityInParent(BPELElement child, BPELElement seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        if (seqOrFlowOrScope instanceof Sequence) {
            ((Sequence)seqOrFlowOrScope).addActivity((Activity)child);
        } else if (seqOrFlowOrScope instanceof Flow) {
            ((Flow)seqOrFlowOrScope).addActivity((Activity)child);
        } else if (seqOrFlowOrScope instanceof OnMessage) {
            ((OnMessage)seqOrFlowOrScope).setActivity((Activity)child);
        } else if (seqOrFlowOrScope instanceof Pick) {
            ((Pick)seqOrFlowOrScope).addOnMessage((OnMessage)child);
        } else if (!(seqOrFlowOrScope instanceof If)) {
            if (seqOrFlowOrScope instanceof Scope) {
                throw new NotImplementedException();
            }
            if (seqOrFlowOrScope instanceof While) {
                ((While)seqOrFlowOrScope).setActivity((Activity)child);
            } else {
                throw new NotImplementedException();
            }
        }
    }

    public Assign generateAssign(String name, List<DataAssociation> dataAssociations, Activity seqOrFlowOrScope, GenerationProperties gp) throws BPELException {
        AssignImpl assign = null;
        if (dataAssociations.size() > 0) {
            assign = new AssignImpl(new TAssign(), (BPELElement)seqOrFlowOrScope);
            this.addActivityInParent((BPELElement)assign, (BPELElement)seqOrFlowOrScope, gp);
            assign.setName("Assign4_" + name);
            for (DataAssociation asso : dataAssociations) {
                for (Assignement ass : asso.getAssignements()) {
                    CopyImpl copy = new CopyImpl(new TCopy(), (BPELElement)assign);
                    assign.addCopy((Copy)copy);
                    FromImpl from = new FromImpl(new TFrom(), (BPELElement)copy);
                    from.setContent((Object)this.generateExpression(ass.getFrom(), gp));
                    copy.setFrom((From)from);
                    ToImpl to = new ToImpl(new TTo(), (BPELElement)copy);
                    to.setContent((Object)this.generateExpression(ass.getTo(), gp));
                    copy.setTo((To)to);
                }
            }
        }
        return assign;
    }

    public String generateExpression(Expression ex, GenerationProperties gp) throws BPELException {
        BPELVariable var;
        String res = null;
        QName element = QName.valueOf(ex.getContent());
        String rootElmtName = element.getLocalPart();
        if (rootElmtName.indexOf("/") != -1) {
            rootElmtName = rootElmtName.substring(0, rootElmtName.indexOf("/"));
        }
        if ((var = this.creatOrFindVariableFromElement(element, gp.getBpelProcess())) == null) {
            throw new BPELException("Impossible to find or create variable corresponding to element: " + element);
        }
        res = "$" + var.getQName().getLocalPart();
        return res;
    }

    public BPELVariable creatOrFindVariableFromElement(QName element, BPELProcess bpelProcess) {
        BPELVariable res = null;
        for (BPELVariable var : bpelProcess.getVariables()) {
            if (var.getElement() == null || !var.getElement().equals(element)) continue;
            res = var;
            break;
        }
        if (res == null) {
            res = bpelProcess.createBPELElementVariable(element.getLocalPart() + "Variable", element, BPELElementVariable.VariableType.ELEMENT);
        }
        return res;
    }

    public OnMessage generateOnMessage(ReceiveTask rt, Pick pick, GenerationProperties gp) throws BPMNException, BPELException {
        OnMessageImpl onMessage = new OnMessageImpl(new TOnMessage(), (BPELElementImpl)pick);
        this.addActivityInParent((BPELElement)onMessage, (BPELElement)pick, gp);
        onMessage.setOperation(rt.getOperation().getName());
        onMessage.setInterface(new QName(rt.getOperation().getDefinitions().getTargetNamespace(), ((Interface)((AbstractBPMNElementImpl)rt.getOperation()).getParent()).getName()));
        System.out.println(new QName(rt.getOperation().getDefinitions().getTargetNamespace(), ((Interface)((AbstractBPMNElementImpl)rt.getOperation()).getParent()).getName()));
        onMessage.setPartnerLink(this.findPartnerLinkFromInterface(onMessage.getInterface(), gp.getBpelProcess(), gp.getArtefactDesc()).getName());
        BPELVariable var = this.creatOrFindVariableFromMessage(rt.getMessage(), gp.getBpelProcess());
        onMessage.setInputVariable(var.getQName().getLocalPart());
        SequenceImpl seq = new SequenceImpl(new TSequence(), (BPELElement)onMessage);
        this.addActivityInParent((BPELElement)seq, (BPELElement)onMessage, gp);
        this.generateNextActivity((FlowElement)rt, (BPELElement)seq, gp);
        return onMessage;
    }

    public BPELVariable creatOrFindVariableFromMessage(Message message, BPELProcess bpelProcess) {
        BPELVariable res = null;
        res = bpelProcess.findVariable(new QName(message.getName() + "Variable"));
        if (res == null) {
            res = bpelProcess.createBPELElementVariable(message.getName() + "Variable", message.getItemDefinition().getElement().getQName(), BPELElementVariable.VariableType.ELEMENT);
        }
        return res;
    }

    public PartnerLink findPartnerLinkFromInterface(QName itf, BPELProcess process, org.ow2.easywsdl.extensions.wsdl4bpel.api.Description artefactDesc) throws BPELException {
        PartnerLink res = null;
        try {
            ArrayList<PartnerLinkType> validPLT = new ArrayList<PartnerLinkType>();
            for (PartnerLinkType plt : artefactDesc.getPartnerLinkTypes()) {
                for (Role r : plt.getRoles()) {
                    if (!r.getInterface().getQName().equals(itf)) continue;
                    validPLT.add(plt);
                }
            }
            for (PartnerLinkType plt : validPLT) {
                for (PartnerLink pl : process.getPartnerLinks()) {
                    System.out.println("pl.getPartnerLinkType().getNamespaceURI() = " + pl.getPartnerLinkType().getNamespaceURI());
                    System.out.println("plt.getQName().getNamespaceURI() = " + plt.getQName().getNamespaceURI());
                    System.out.println("pl.getPartnerLinkType().getLocalPart() = " + pl.getPartnerLinkType().getLocalPart());
                    System.out.println("plt.getQName().getLocalPart() = " + plt.getQName().getLocalPart());
                    System.out.println("found pltype = " + pl.getPartnerLinkType());
                    if (!pl.getPartnerLinkType().getNamespaceURI().equals(plt.getQName().getNamespaceURI()) || !pl.getPartnerLinkType().getLocalPart().equals(plt.getQName().getLocalPart())) continue;
                    System.out.println("found pl = " + pl.getName());
                    res = pl;
                    System.out.println("found res = " + res);
                    break;
                }
                if (res == null) continue;
                break;
            }
        }
        catch (WSDL4BPELException e) {
            throw new BPELException((Throwable)e);
        }
        return res;
    }

    public Import addDescriptionImport(BPELProcess p, org.ow2.easywsdl.extensions.wsdl4bpel.api.Description desc) {
        ImportImpl imp = new ImportImpl(new TImport(), (BPELElement)p);
        imp.setImportType(URI.create("http://schemas.xmlsoap.org/wsdl/"));
        imp.setLocation(desc.getDocumentBaseURI());
        imp.setNamespace(URI.create(desc.getTargetNamespace()));
        imp.setDescription(desc);
        p.addImport((Import)imp);
        return imp;
    }

    public Import addSchemaImport(BPELProcess p, Schema schema) {
        ImportImpl imp = new ImportImpl(new TImport(), (BPELElement)p);
        imp.setImportType(URI.create("http://www.w3.org/2001/XMLSchema"));
        imp.setLocation(schema.getDocumentURI());
        imp.setNamespace(URI.create(schema.getTargetNamespace()));
        imp.setSchema(schema);
        p.addImport((Import)imp);
        return imp;
    }
}

