/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.model.bpmn.tools.bpmn2bpel;

import com.ebmwebsourcing.easybpmn.model.bpmn.api.BPMNException;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.collaboration.Collaboration;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.collaboration.Pool;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.common.Message;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.common.Participant;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.infrastructure.Definitions;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.service.Descriptions;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.service.Interface;
import com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.service.Operation;
import com.ebmwebsourcing.easybpmn.model.bpmn.tools.bpmn2bpel.BPELGeneratorHelper;
import com.ebmwebsourcing.easybpmn.model.bpmn.tools.bpmn2bpel.GenerationProperties;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.NotImplementedException;
import org.ow2.easywsdl.extensions.wsdl4bpel.WSDL4BPELFactory;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.PartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.api.Role;
import org.ow2.easywsdl.extensions.wsdl4bpel.impl.PartnerLinkTypeImpl;
import org.ow2.easywsdl.extensions.wsdl4bpel.impl.RoleImpl;
import org.ow2.easywsdl.extensions.wsdl4bpel.org.oasis_open.docs.wsbpel._2_0.plnktype.TPartnerLinkType;
import org.ow2.easywsdl.extensions.wsdl4bpel.org.oasis_open.docs.wsbpel._2_0.plnktype.TRole;
import org.ow2.easywsdl.schema.api.Element;
import org.ow2.easywsdl.schema.api.Import;
import org.ow2.easywsdl.schema.api.Schema;
import org.ow2.easywsdl.schema.api.SchemaException;
import org.ow2.easywsdl.schema.api.absItf.AbsItfImport;
import org.ow2.easywsdl.schema.api.absItf.AbsItfSchema;
import org.ow2.easywsdl.schema.api.abstractElmt.AbstractSchemaElementImpl;
import org.ow2.easywsdl.wsdl.WSDLFactory;
import org.ow2.easywsdl.wsdl.api.Binding;
import org.ow2.easywsdl.wsdl.api.Description;
import org.ow2.easywsdl.wsdl.api.Endpoint;
import org.ow2.easywsdl.wsdl.api.Fault;
import org.ow2.easywsdl.wsdl.api.Input;
import org.ow2.easywsdl.wsdl.api.InterfaceType;
import org.ow2.easywsdl.wsdl.api.Output;
import org.ow2.easywsdl.wsdl.api.Service;
import org.ow2.easywsdl.wsdl.api.Types;
import org.ow2.easywsdl.wsdl.api.WSDLException;
import org.ow2.easywsdl.wsdl.api.WSDLImportException;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfBinding;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfDescription;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfEndpoint;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfFault;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInput;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfInterfaceType;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOutput;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfService;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfTypes;

public class WSDLGenerator {
    public List<Description> generate(Definitions def) throws BPMNException {
        return this.generate(def, new GenerationProperties());
    }

    public List<Description> generate(Definitions def, GenerationProperties gp) throws BPMNException {
        ArrayList<Description> res = new ArrayList<Description>();
        for (Collaboration c : def.getCollaborations()) {
            List<Description> descs = null;
            for (Pool pool : c.getPools()) {
                descs = this.generate(pool, gp);
                res.addAll(descs);
            }
            org.ow2.easywsdl.extensions.wsdl4bpel.api.Description artefactDesc = this.generateArtefactWSDL(c, res, gp);
            res.add((Description)artefactDesc);
            gp.setArtefactDesc(artefactDesc);
        }
        return res;
    }

    public List<Description> generate(Pool pool, GenerationProperties gp) throws BPMNException {
        ArrayList<Description> res = new ArrayList<Description>();
        Description abstractDesc = this.generateAbstractWSDL(pool.getInterface(), gp);
        Description concreteDesc = this.generateConcreteWSDL(abstractDesc, pool.getParticipant().getEndpoint(), gp);
        res.add(abstractDesc);
        res.add(concreteDesc);
        return res;
    }

    public Description generateConcreteWSDL(Description abstractDesc, List<com.ebmwebsourcing.easybpmn.model.bpmn.api.standard.service.Endpoint> endpoints, GenerationProperties gp) throws BPMNException {
        Description res = null;
        try {
            if (endpoints.size() != 0 || !gp.isAutoGenerateServiceIfNotExist()) {
                throw new NotImplementedException();
            }
            res = WSDLFactory.newInstance().newDescription(AbsItfDescription.WSDLVersionConstants.WSDL11);
            res.setTargetNamespace(abstractDesc.getTargetNamespace());
            res.setDocumentBaseURI(URI.create(abstractDesc.getQName().getLocalPart() + "Service.wsdl"));
            res.setQName(new QName(abstractDesc.getTargetNamespace(), abstractDesc.getQName().getLocalPart() + "Service"));
            org.ow2.easywsdl.wsdl.api.Import impt = (org.ow2.easywsdl.wsdl.api.Import)res.createImport();
            impt.setLocationURI(abstractDesc.getDocumentBaseURI());
            impt.setNamespaceURI(abstractDesc.getTargetNamespace());
            impt.setDescription((AbsItfDescription)abstractDesc);
            Service s = (Service)res.createService();
            s.setQName(new QName(abstractDesc.getTargetNamespace(), abstractDesc.getQName().getLocalPart() + "Service"));
            s.setInterface(abstractDesc.getInterface(abstractDesc.getQName()));
            Endpoint ep = (Endpoint)s.createEndpoint();
            s.addEndpoint((AbsItfEndpoint)ep);
            ep.setName(abstractDesc.getQName().getLocalPart() + "Endpoint");
            ep.setAddress(s.getQName() + "::" + ep.getName());
            Binding binding = (Binding)res.createDefaultSoapBinding(abstractDesc.getQName().getLocalPart() + "Binding", (AbsItfEndpoint)ep, abstractDesc.getInterface(abstractDesc.getQName()));
            res.addImport((org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfImport)impt);
            res.addBinding((AbsItfBinding)binding);
            res.addService((AbsItfService)s);
        }
        catch (WSDLException e) {
            throw new BPMNException((Throwable)e);
        }
        catch (WSDLImportException e) {
            throw new BPMNException((Throwable)e);
        }
        return res;
    }

    public Description generateAbstractWSDL(Interface itfM, GenerationProperties gp) throws BPMNException {
        Description res = null;
        try {
            res = WSDLFactory.newInstance().newDescription(AbsItfDescription.WSDLVersionConstants.WSDL11);
            if (itfM.getDefinitions() != null) {
                res.setTargetNamespace(itfM.getDefinitions().getTargetNamespace());
            }
            if (itfM.getName() != null) {
                res.setDocumentBaseURI(URI.create(itfM.getName() + ".wsdl"));
                if (itfM.getDefinitions() != null) {
                    res.setQName(new QName(itfM.getDefinitions().getTargetNamespace(), itfM.getName()));
                }
            }
            Types types = (Types)res.createTypes();
            res.setTypes((AbsItfTypes)types);
            InterfaceType itfT = (InterfaceType)res.createInterface();
            if (itfM.getDefinitions() != null) {
                itfT.setQName(new QName(itfM.getDefinitions().getTargetNamespace(), itfM.getName()));
            }
            ArrayList<Element> elmtToImports = new ArrayList<Element>();
            for (Operation opM : itfM.getOperations()) {
                org.ow2.easywsdl.wsdl.api.Operation op = (org.ow2.easywsdl.wsdl.api.Operation)itfT.createOperation();
                itfT.addOperation((AbsItfOperation)op);
                if (itfM.getDefinitions() != null && opM.getName() != null) {
                    op.setQName(new QName(itfM.getDefinitions().getTargetNamespace(), opM.getName()));
                }
                if (opM.getMessageOut() != null) {
                    op.setPattern(AbsItfOperation.MEPPatternConstants.IN_OUT);
                } else {
                    op.setPattern(AbsItfOperation.MEPPatternConstants.IN_ONLY);
                }
                Input input = (Input)op.createInput();
                op.setInput((AbsItfInput)input);
                if (opM.getMessageIn() != null) {
                    input.setName(opM.getMessageIn().getName());
                }
                if (itfM.getDefinitions() != null) {
                    input.setMessageName(new QName(itfM.getDefinitions().getTargetNamespace(), opM.getMessageIn().getName()));
                    input.setElement(opM.getMessageIn().getItemDefinition().getElement());
                    elmtToImports.add(opM.getMessageIn().getItemDefinition().getElement());
                }
                if (opM.getMessageOut() != null) {
                    Output output = (Output)op.createOutput();
                    op.setOutput((AbsItfOutput)output);
                    if (opM.getMessageOut().getName() != null) {
                        output.setName(opM.getMessageOut().getName());
                    }
                    if (itfM.getDefinitions() != null) {
                        output.setMessageName(new QName(itfM.getDefinitions().getTargetNamespace(), opM.getMessageOut().getName()));
                    }
                    if (opM.getMessageOut().getItemDefinition() != null) {
                        output.setElement(opM.getMessageOut().getItemDefinition().getElement());
                        elmtToImports.add(opM.getMessageOut().getItemDefinition().getElement());
                    }
                }
                Fault fault = (Fault)op.createFault();
                for (Message msg : opM.getErrorMessages()) {
                    fault.setName(msg.getName());
                    op.addFault((AbsItfFault)fault);
                }
            }
            res.addInterface((AbsItfInterfaceType)itfT);
            Schema schema = (Schema)types.createSchema();
            types.addSchema((AbsItfSchema)schema);
            if (itfM.getDefinitions() != null) {
                schema.setTargetNamespace(itfM.getDefinitions().getTargetNamespace());
                schema.getAllNamespaces().addNamespace("tns", itfM.getDefinitions().getTargetNamespace());
            }
            ArrayList<String> alreadyImportedSchema = new ArrayList<String>();
            for (Element elmt : elmtToImports) {
                Schema model = (Schema)((AbstractSchemaElementImpl)elmt).getSchema();
                if (alreadyImportedSchema.contains(model.getTargetNamespace())) continue;
                Import typeImport = (Import)schema.createImport();
                schema.addImport((AbsItfImport)typeImport);
                if (model.getDocumentURI() != null) {
                    typeImport.setLocationURI(model.getDocumentURI());
                }
                if (model.getTargetNamespace() != null) {
                    typeImport.setNamespaceURI(model.getTargetNamespace());
                }
                typeImport.setSchema((AbsItfSchema)model);
                alreadyImportedSchema.add(model.getTargetNamespace());
            }
        }
        catch (WSDLException e) {
            throw new BPMNException((Throwable)e);
        }
        catch (SchemaException e) {
            throw new BPMNException((Throwable)e);
        }
        return res;
    }

    private org.ow2.easywsdl.extensions.wsdl4bpel.api.Description generateArtefactWSDL(Collaboration c, List<Description> descs, GenerationProperties gp) throws BPMNException {
        org.ow2.easywsdl.extensions.wsdl4bpel.api.Description res = null;
        try {
            res = WSDL4BPELFactory.newInstance().addExtElmt2Description((AbsItfDescription)WSDLFactory.newInstance().newDescription(AbsItfDescription.WSDLVersionConstants.WSDL11));
            res.setQName(new QName(c.getDefinitions().getTargetNamespace(), c.getName() + "Artefacts"));
            res.setDocumentBaseURI(URI.create(BPELGeneratorHelper.cleanStringForURICreation(c.getName() + "Artefacts.wsdl")));
            String artefactNameSpace = this.getArtefactNamespace(c.getDefinitions().getTargetNamespace());
            res.setTargetNamespace(artefactNameSpace);
            for (Description desc : descs) {
                org.ow2.easywsdl.wsdl.api.Import impt = (org.ow2.easywsdl.wsdl.api.Import)res.createImport();
                impt.setLocationURI(desc.getDocumentBaseURI());
                impt.setNamespaceURI(desc.getTargetNamespace());
                impt.setDescription((AbsItfDescription)desc);
                res.addImport((org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfImport)impt);
            }
            for (Pool pool : c.getPools()) {
                List<Participant> participants = this.findAllParticipants(pool);
                for (Participant participant : participants) {
                    PartnerLinkTypeImpl plt = new PartnerLinkTypeImpl(new TPartnerLinkType(), (Description)res);
                    res.addPartnerLinkType((PartnerLinkType)plt);
                    plt.setQName(this.getPartnerLinkTypeName(pool, participant));
                    RoleImpl role = new RoleImpl(new TRole(), (PartnerLinkType)plt);
                    plt.addRole((Role)role);
                    role.setName(participant.getPartnerRole().getName());
                    InterfaceType itf = this.findInterface(pool.getDefinitions().getDescriptions(), descs, new QName(pool.getInterface().getDefinitions().getTargetNamespace(), pool.getInterface().getName()));
                    System.out.println("if = " + itf);
                    role.setInterface(itf);
                }
            }
        }
        catch (WSDLException e) {
            throw new BPMNException((Throwable)e);
        }
        catch (WSDLImportException e) {
            throw new BPMNException((Throwable)e);
        }
        return res;
    }

    private String getArtefactNamespace(String targetNamespace) {
        String artefactNS = null;
        artefactNS = targetNamespace.endsWith("/") ? targetNamespace + "artefefacts" : targetNamespace + "/artefefacts";
        return artefactNS;
    }

    public QName getPartnerLinkTypeName(Pool pool, Participant participant) throws BPMNException {
        QName res = null;
        if (pool.getDefinitions() != null) {
            res = participant.getPartnerEntity() != null ? new QName(this.getArtefactNamespace(pool.getDefinitions().getTargetNamespace()), participant.getPartnerEntity().getName() + "PLT") : new QName(this.getArtefactNamespace(pool.getDefinitions().getTargetNamespace()), pool.getProcess().getName() + "PLT");
        }
        return res;
    }

    private InterfaceType findInterface(Descriptions descriptions, List<Description> descs, QName name) {
        InterfaceType res;
        block1: {
            Description desc;
            res = null;
            res = (InterfaceType)descriptions.getInterface(name);
            if (res != null) break block1;
            Iterator<Description> i$ = descs.iterator();
            while (i$.hasNext() && (res = (InterfaceType)(desc = i$.next()).getInterface(name)) == null) {
            }
        }
        return res;
    }

    private List<Participant> findAllParticipants(Pool pool) throws BPMNException {
        ArrayList<Participant> participants = new ArrayList<Participant>();
        participants.add(pool.getParticipant());
        return participants;
    }
}

