/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.sabpmn20.api;

import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.SabpmnHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import junit.framework.Assert;
import org.junit.Test;

public class SabpmnHelperTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_MODEL_REFERENCE = "expectedModelReferenceHelper";

    public SabpmnHelperTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testModelReference() throws URISyntaxException {
        XmlObject object = (XmlObject)this.newObjectUnderTest();
        if (this.getTestData(EXPECTED_MODEL_REFERENCE) != null) {
            ArrayList<String> model = new ArrayList<String>();
            for (URI concept : SabpmnHelper.getModelReference((XmlObject)object)) {
                model.add(concept.toString());
            }
            Assert.assertEquals((Object)this.getTestData(EXPECTED_MODEL_REFERENCE), model);
        }
        SabpmnHelper.removeModelReference((XmlObject)object);
        Assert.assertEquals((int)0, (int)SabpmnHelper.getModelReference((XmlObject)object).length);
        URI testUri = new URI("http://test.owl#concept");
        SabpmnHelper.addModelReference((XmlObject)object, (URI[])new URI[]{testUri});
        Assert.assertEquals((int)1, (int)SabpmnHelper.getModelReference((XmlObject)object).length);
        Assert.assertEquals((Object)testUri, (Object)SabpmnHelper.getModelReference((XmlObject)object)[0]);
        SabpmnHelper.removeModelReference((XmlObject)object);
        Assert.assertEquals((int)0, (int)SabpmnHelper.getModelReference((XmlObject)object).length);
    }
}

