/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.sabpmn20.api;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.with.WithOtherAttributes;
import com.ebmwebsourcing.easybpmn.bpmn20.api.element.ExtensionElements;
import com.ebmwebsourcing.easybpmn.bpmn20.api.type.TBaseElement;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.SabpmnException;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.element.SemanticDetails;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.element.SemanticElements;
import com.ebmwebsourcing.easycommons.lang.UncheckedException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.namespace.QName;

public final class SabpmnHelper {
    private static final QName MODEL_REF_QNAME = new QName("http://www.petalslink.com/ns/2011/05/sabpmn20", "modelReference");

    private SabpmnHelper() {
    }

    public static void addModelReference(XmlObject contextObject, URI ... uris) {
        if (contextObject instanceof WithOtherAttributes) {
            if (((WithOtherAttributes)contextObject).hasOtherAttribute(MODEL_REF_QNAME)) {
                String currentModelRef = ((WithOtherAttributes)contextObject).getOtherAttribute(MODEL_REF_QNAME);
                ((WithOtherAttributes)contextObject).addOtherAttribute(MODEL_REF_QNAME, currentModelRef + " " + SabpmnHelper.urisToString(uris));
            } else {
                ((WithOtherAttributes)contextObject).addOtherAttribute(MODEL_REF_QNAME, SabpmnHelper.urisToString(uris));
            }
        } else {
            throw new UncheckedException("Impossible to add semantic annontation on " + contextObject.getXmlObjectQName());
        }
    }

    public static URI[] getModelReference(XmlObject contextObject) {
        String modelRef = null;
        if (contextObject instanceof WithOtherAttributes) {
            modelRef = ((WithOtherAttributes)contextObject).getOtherAttribute(MODEL_REF_QNAME);
        }
        if (modelRef != null) {
            return SabpmnHelper.stringToUris(modelRef);
        }
        return new URI[0];
    }

    public static void removeModelReference(XmlObject contextObject) {
        if (contextObject instanceof WithOtherAttributes) {
            ((WithOtherAttributes)contextObject).removeOtherAttribute(MODEL_REF_QNAME);
        }
    }

    public static SemanticDetails getSemanticDetails(XmlObject contextObject) {
        ExtensionElements ext;
        if (contextObject instanceof TBaseElement && (ext = ((TBaseElement)contextObject).getExtensionElements()) != null) {
            return (SemanticDetails)ext.getFirstAnyXmlObject(SemanticDetails.class);
        }
        return null;
    }

    public static void setSemanticDetails(XmlObject contextObject, SemanticDetails semanticDetails) throws SabpmnException {
        if (contextObject instanceof TBaseElement) {
            ExtensionElements ext = null;
            if (((TBaseElement)contextObject).hasExtensionElements()) {
                ext = ((TBaseElement)contextObject).getExtensionElements();
            } else {
                ext = (ExtensionElements)contextObject.getXmlContext().getXmlObjectFactory().create(ExtensionElements.class);
                ((TBaseElement)contextObject).setExtensionElements(ext);
            }
            if (ext.hasAnyXmlObject(SemanticDetails.QNAME)) {
                ext.removeAnyXmlObject(ext.getFirstAnyXmlObject(SemanticDetails.class));
            } else {
                ext.addAnyXmlObject((XmlObject)semanticDetails);
            }
        } else {
            throw new SabpmnException("Impossible to add semantic details on this element: " + contextObject.getXmlObjectQName());
        }
    }

    public static void removeSemanticDetails(XmlObject contextObject) {
        ExtensionElements ext;
        if (contextObject instanceof TBaseElement && ((TBaseElement)contextObject).hasExtensionElements() && (ext = ((TBaseElement)contextObject).getExtensionElements()).hasAnyXmlObject(SemanticDetails.QNAME)) {
            SemanticDetails semanticDetails = (SemanticDetails)ext.getFirstAnyXmlObject(SemanticDetails.class);
            ext.removeAnyXmlObject((XmlObject)semanticDetails);
            if (ext.getAnyXmlObjects().length == 0) {
                ((TBaseElement)contextObject).setExtensionElements(null);
            }
        }
    }

    public static SemanticElements getSemanticElements(XmlObject contextObject) {
        ExtensionElements ext;
        if (contextObject instanceof TBaseElement && (ext = ((TBaseElement)contextObject).getExtensionElements()) != null) {
            return (SemanticElements)ext.getFirstAnyXmlObject(SemanticElements.class);
        }
        return null;
    }

    public static void setSemanticElements(XmlObject contextObject, SemanticElements semanticElements) throws SabpmnException {
        ExtensionElements ext;
        if (contextObject instanceof TBaseElement) {
            ext = null;
            if (((TBaseElement)contextObject).hasExtensionElements()) {
                ext = ((TBaseElement)contextObject).getExtensionElements();
                if (ext.hasAnyXmlObject(SemanticElements.QNAME)) {
                    ext.removeAnyXmlObject(ext.getFirstAnyXmlObject(SemanticElements.class));
                }
            } else {
                ext = (ExtensionElements)contextObject.getXmlContext().getXmlObjectFactory().create(ExtensionElements.class);
                ((TBaseElement)contextObject).setExtensionElements(ext);
            }
        } else {
            throw new SabpmnException("Impossible to add semantic elements on this element: " + contextObject.getXmlObjectQName());
        }
        ext.addAnyXmlObject((XmlObject)semanticElements);
    }

    public static void removeSemanticElements(XmlObject contextObject) {
        ExtensionElements ext;
        if (contextObject instanceof TBaseElement && ((TBaseElement)contextObject).hasExtensionElements() && (ext = ((TBaseElement)contextObject).getExtensionElements()).hasAnyXmlObject(SemanticElements.QNAME)) {
            SemanticElements semanticElements = (SemanticElements)ext.getFirstAnyXmlObject(SemanticElements.class);
            ext.removeAnyXmlObject((XmlObject)semanticElements);
            if (ext.getAnyXmlObjects().length == 0) {
                ((TBaseElement)contextObject).setExtensionElements(null);
            }
        }
    }

    private static final URI[] stringToUris(String str) {
        ArrayList<URI> uris = new ArrayList<URI>();
        for (String uri : str.split("\\s+")) {
            try {
                uris.add(new URI(uri));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Problem in semantic annontation URIs: ", e);
            }
        }
        return uris.toArray(new URI[uris.size()]);
    }

    private static final String urisToString(URI[] uris) {
        StringBuilder urisStr = new StringBuilder();
        for (URI uri : uris) {
            if (urisStr.length() != 0) {
                urisStr.append(" ");
            }
            urisStr.append(uri.toString());
        }
        return urisStr.toString();
    }
}

