/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easybpmn.sabpmn20.api;

import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.AbstractXmlObjectTestSuite;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.element.FunctionalDescription;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.element.InternalBehavior;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.element.NonfunctionalParameters;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.element.SemanticDetails;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.element.SemanticParameter;
import com.ebmwebsourcing.easybpmn.sabpmn20.api.element.UnitActivity;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Assert;
import org.junit.Test;

public class SemanticDetailsTestSuite
extends AbstractXmlObjectTestSuite {
    public static final String EXPECTED_FUNCTIONAL_DESCRIPTION = "expectedFunctionalDescription";
    public static final String EXPECTED_INTERNAL_BEHAVIOUR = "expectedInternalBehaviour";
    public static final String EXPECTED_NONFUNCTIONAL_PARAMETERS = "expectedNonfunctionalParameters";

    public SemanticDetailsTestSuite(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    @Test
    public void testFunctionalDescription() throws URISyntaxException {
        SemanticDetails sd = (SemanticDetails)this.newObjectUnderTest();
        if (this.getTestData(EXPECTED_FUNCTIONAL_DESCRIPTION) != null) {
            Assert.assertEquals((Object)this.getTestData(EXPECTED_FUNCTIONAL_DESCRIPTION), (Object)sd.hasFunctionalDescription());
        }
        sd.removeFunctionalDescription();
        Assert.assertFalse((boolean)sd.hasFunctionalDescription());
        FunctionalDescription func = (FunctionalDescription)this.getXmlContext().getXmlObjectFactory().create(FunctionalDescription.class);
        func.setName("testName");
        func.addModelReference(new URI("http://test.owl#concept"));
        sd.setFunctionalDescription(func);
        Assert.assertTrue((boolean)sd.hasFunctionalDescription());
        Assert.assertEquals((String)"testName", (String)sd.getFunctionalDescription().getName());
        Assert.assertEquals((int)1, (int)sd.getFunctionalDescription().getModelReference().length);
        sd.removeFunctionalDescription();
        Assert.assertFalse((boolean)sd.hasFunctionalDescription());
    }

    @Test
    public void testInternalBehavior() throws URISyntaxException {
        SemanticDetails sd = (SemanticDetails)this.newObjectUnderTest();
        if (this.getTestData(EXPECTED_INTERNAL_BEHAVIOUR) != null) {
            Assert.assertEquals((Object)this.getTestData(EXPECTED_INTERNAL_BEHAVIOUR), (Object)sd.hasInternalBehavior());
        }
        sd.removeInternalBehavior();
        Assert.assertFalse((boolean)sd.hasInternalBehavior());
        InternalBehavior ib = (InternalBehavior)this.getXmlContext().getXmlObjectFactory().create(InternalBehavior.class);
        UnitActivity ua = (UnitActivity)this.getXmlContext().getXmlObjectFactory().create(UnitActivity.class);
        ua.setName("testName");
        ua.addModelReference(new URI("http://test.owl#concept"));
        ib.addUnitActivity(ua);
        sd.setInternalBehavior(ib);
        Assert.assertTrue((boolean)sd.hasInternalBehavior());
        Assert.assertEquals((int)1, (int)sd.getInternalBehavior().getUnitActivities().length);
        Assert.assertEquals((String)"testName", (String)sd.getInternalBehavior().getUnitActivities()[0].getName());
        Assert.assertEquals((int)1, (int)sd.getInternalBehavior().getUnitActivities()[0].getModelReference().length);
        sd.getInternalBehavior().removeAllUnitActivities();
        Assert.assertFalse((boolean)sd.getInternalBehavior().hasUnitActivity());
        sd.removeFunctionalDescription();
        Assert.assertFalse((boolean)sd.hasFunctionalDescription());
    }

    @Test
    public void testNonfunctionalParameters() throws URISyntaxException {
        SemanticDetails sd = (SemanticDetails)this.newObjectUnderTest();
        if (this.getTestData(EXPECTED_NONFUNCTIONAL_PARAMETERS) != null) {
            Assert.assertEquals((Object)this.getTestData(EXPECTED_NONFUNCTIONAL_PARAMETERS), (Object)sd.hasNonfunctionalParameters());
        }
        sd.removeNonfunctionalParameters();
        Assert.assertFalse((boolean)sd.hasNonfunctionalParameters());
        NonfunctionalParameters nfp = (NonfunctionalParameters)this.getXmlContext().getXmlObjectFactory().create(NonfunctionalParameters.class);
        SemanticParameter sp = (SemanticParameter)this.getXmlContext().getXmlObjectFactory().create(SemanticParameter.class);
        sp.setName("testName");
        sp.addModelReference(new URI("http://test.owl#concept"));
        nfp.addSemanticParameter(sp);
        sd.setNonfunctionalParameters(nfp);
        Assert.assertTrue((boolean)sd.hasNonfunctionalParameters());
        Assert.assertEquals((int)1, (int)sd.getNonfunctionalParameters().getSemanticParameters().length);
        Assert.assertEquals((int)1, (int)sd.getNonfunctionalParameters().getSemanticParameters()[0].getModelReference().length);
        sd.getNonfunctionalParameters().removeAllSemanticParameters();
        Assert.assertFalse((boolean)sd.getNonfunctionalParameters().hasSemanticParameter());
        sd.removeNonfunctionalParameters();
        Assert.assertFalse((boolean)sd.hasNonfunctionalParameters());
    }
}

