/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.io;

import com.ebmwebsourcing.easycommons.io.FileSystemHelper;
import com.ebmwebsourcing.easycommons.lang.reflect.ReflectionHelper;
import java.io.File;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class FileSystemHelperTest {
    private static final String FOLDER_PATH_LONG = "/root/dir1/dir2/dir3/";
    private static final String FOLDER_PATH_SHORT = "/root/dir1/";
    private static final String FILE_PATH_SHORT = "/root/dir1/pom.xml";
    private static final String FILE_PATH_LONG = "/root/dir1/dir2/dir3/pom.xml";
    private static final String NOT_RELATIVE_FILE_PATH = "/notrelative/dir1/pom.xml";
    private static final String NOT_RELATIVE_FOLDER_PATH = "/notrelative/dir1";
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test(expected=IllegalArgumentException.class)
    public void testGetRelativePathIllegalArgumentException_Deprecated() {
        FileSystemHelper.getRelativePath((String)"/root/dir1", (String)FOLDER_PATH_SHORT);
    }

    @Test
    public void testGetRelativePathFolderToFolder_Deprecated() {
        Assert.assertEquals((Object)"../../", (Object)FileSystemHelper.getRelativePath((String)FOLDER_PATH_LONG, (String)FOLDER_PATH_SHORT));
    }

    @Test
    public void testGetRelativePathFolderToFile_Deprecated() {
        Assert.assertEquals((Object)"../../pom.xml", (Object)FileSystemHelper.getRelativePath((String)FOLDER_PATH_LONG, (String)FILE_PATH_SHORT));
    }

    @Test
    public void testGetRelativePathFolderToFolderForward_Deprecated() {
        Assert.assertEquals((Object)"dir2/dir3/", (Object)FileSystemHelper.getRelativePath((String)FOLDER_PATH_SHORT, (String)FOLDER_PATH_LONG));
    }

    @Test
    public void testGetRelativePathFolderToFileForward_Deprecated() {
        Assert.assertEquals((Object)"dir2/dir3/pom.xml", (Object)FileSystemHelper.getRelativePath((String)FOLDER_PATH_SHORT, (String)FILE_PATH_LONG));
    }

    @Test
    public void testGetRelativePath_SourceIsNull() {
        String errorMsg = (String)ReflectionHelper.getPrivateFieldValue(FileSystemHelper.class, null, (String)"ILLEGAL_ARGUMENT_EXCEPTION_MSG_SRC_NULL");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(errorMsg);
        File targetFile = this.tempFolder.newFolder("target");
        FileSystemHelper.getRelativePath(null, (File)targetFile);
    }

    @Test
    public void testGetRelativePath_SourceIsNotAbsolute() {
        String errorMsg = (String)ReflectionHelper.getPrivateFieldValue(FileSystemHelper.class, null, (String)"ILLEGAL_ARGUMENT_EXCEPTION_MSG_SRC_NOT_ABSOLUTE");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(errorMsg);
        File targetFile = this.tempFolder.newFolder("target");
        FileSystemHelper.getRelativePath((File)new File("root/dir1"), (File)targetFile);
    }

    @Test
    public void testGetRelativePath_SourceIsNotDirectory() throws IOException {
        String errorMsg = (String)ReflectionHelper.getPrivateFieldValue(FileSystemHelper.class, null, (String)"ILLEGAL_ARGUMENT_EXCEPTION_MSG_SRC_NOT_DIR");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(errorMsg);
        File srcDir = this.tempFolder.newFile("source.file");
        FileSystemHelper.getRelativePath((File)srcDir, (File)new File("/root/dir1"));
    }

    @Test
    public void testGetRelativePath_TargetIsNull() throws IOException {
        String errorMsg = (String)ReflectionHelper.getPrivateFieldValue(FileSystemHelper.class, null, (String)"ILLEGAL_ARGUMENT_EXCEPTION_MSG_TARGET_NULL");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(errorMsg);
        File srcDir = this.tempFolder.newFile("source.file");
        FileSystemHelper.getRelativePath((File)srcDir, null);
    }

    @Test
    public void testGetRelativePath_TargetIsNotAbsolute() {
        String errorMsg = (String)ReflectionHelper.getPrivateFieldValue(FileSystemHelper.class, null, (String)"ILLEGAL_ARGUMENT_EXCEPTION_MSG_TARGET_NOT_ABSOLUTE");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(errorMsg);
        File srcDir = this.tempFolder.newFolder("source");
        FileSystemHelper.getRelativePath((File)srcDir, (File)new File("target"));
    }

    @Test
    public void testGetRelativePathFolderToFolder() {
        File root = this.tempFolder.newFolder("root");
        File dir1 = new File(root, "dir1");
        File dir2 = new File(dir1, "dir2");
        File dir3 = new File(dir2, "dir3");
        Assert.assertTrue((String)"Unable to create directory tree", (boolean)dir3.mkdirs());
        Assert.assertEquals((String)"Unexpected relative path", (Object)"../../", (Object)FileSystemHelper.getRelativePath((File)dir3, (File)dir1));
    }

    @Test
    public void testGetRelativePathFolderToFile() {
        File root = this.tempFolder.newFolder("root");
        File dir1 = new File(root, "dir1");
        File file = new File(dir1, "pom.xml");
        File dir2 = new File(dir1, "dir2");
        File dir3 = new File(dir2, "dir3");
        Assert.assertTrue((String)"Unable to create directory tree", (boolean)dir3.mkdirs());
        Assert.assertEquals((String)"Unexpected relative path", (Object)"../../pom.xml", (Object)FileSystemHelper.getRelativePath((File)dir3, (File)file));
    }

    @Test
    public void testGetRelativePathFolderToFolderForward() {
        File root = this.tempFolder.newFolder("root");
        File dir1 = new File(root, "dir1");
        File dir2 = new File(dir1, "dir2");
        File dir3 = new File(dir2, "dir3");
        Assert.assertTrue((String)"Unable to create directory tree", (boolean)dir3.mkdirs());
        Assert.assertEquals((String)"Unexpected relative path", (Object)"./dir2/dir3", (Object)FileSystemHelper.getRelativePath((File)dir1, (File)dir3));
    }

    @Test
    public void testGetRelativePathFolderToFileForward() {
        File root = this.tempFolder.newFolder("root");
        File dir1 = new File(root, "dir1");
        File dir2 = new File(dir1, "dir2");
        File dir3 = new File(dir2, "dir3");
        File file = new File(dir3, "pom.xml");
        Assert.assertTrue((String)"Unable to create directory tree", (boolean)dir3.mkdirs());
        Assert.assertEquals((String)"Unexpected relative path", (Object)"./dir2/dir3/pom.xml", (Object)FileSystemHelper.getRelativePath((File)dir1, (File)file));
    }

    @Test
    public void testGetRelativePathNotRelativeFile() {
        File root = this.tempFolder.newFolder("root");
        File dir1 = new File(root, "dir1");
        Assert.assertTrue((String)"Unable to create directory tree", (boolean)dir1.mkdirs());
        Assert.assertEquals((Object)NOT_RELATIVE_FILE_PATH, (Object)FileSystemHelper.getRelativePath((File)dir1, (File)new File(NOT_RELATIVE_FILE_PATH)));
    }

    @Test
    public void testGetRelativePathNotRelativeFolder() {
        File root = this.tempFolder.newFolder("root");
        File dir1 = new File(root, "dir1");
        Assert.assertTrue((String)"Unable to create directory tree", (boolean)dir1.mkdirs());
        Assert.assertEquals((Object)NOT_RELATIVE_FOLDER_PATH, (Object)FileSystemHelper.getRelativePath((File)dir1, (File)new File(NOT_RELATIVE_FOLDER_PATH)));
    }

    @Test
    public void testCreateTempDirReallyCreateADir() throws Exception {
        File tempDir = FileSystemHelper.createTempDir();
        Assert.assertTrue((boolean)tempDir.isDirectory());
    }

    @Test
    public void testCreateTempDirTwiceReturnDifferentTempDir() throws Exception {
        File tempDir = FileSystemHelper.createTempDir();
        File tempDir2 = FileSystemHelper.createTempDir();
        Assert.assertFalse((boolean)tempDir.equals(tempDir2));
    }

    @Test
    public void testCreateTempDirUsesSystemTempDirByDefault() throws Exception {
        File tempDir = FileSystemHelper.createTempDir();
        Assert.assertTrue((boolean)tempDir.getAbsolutePath().startsWith(System.getProperty("java.io.tmpdir")));
    }

    @Test(expected=IOException.class)
    public void testCreateTempDirInParentDirWhichDoesNotExist() throws Exception {
        File parentDir = new File("/this/certainly/does/not/exist");
        FileSystemHelper.createTempDir((File)parentDir, (String)"dummyPrefix");
    }

    @Test
    public void testCreateTempDirWithPrefix() throws Exception {
        String testPrefix = "testPrefix";
        File tempDir = FileSystemHelper.createTempDir((String)testPrefix);
        Assert.assertTrue((boolean)tempDir.getName().startsWith(testPrefix));
    }

    @Test
    public void testCreateTempCreateAnEmptyDir() throws Exception {
        File tempDir = FileSystemHelper.createTempDir();
        Assert.assertTrue((tempDir.list().length == 0 ? 1 : 0) != 0);
    }

    @Test(expected=IOException.class)
    public void testCleanNotExistingDirectory() throws IOException {
        File notExistingDirectory = this.createNotExistingDirectory();
        FileSystemHelper.cleanDirectory((File)notExistingDirectory);
    }

    @Test(expected=IOException.class)
    public void testCleanDirectoryThatIsntADirectory() throws IOException {
        File notADirectory = new File(FileSystemHelper.createTempDir(), "notADirectory.bin");
        FileSystemHelper.cleanDirectory((File)notADirectory);
    }

    @Test(expected=IOException.class)
    public void testCleanRestrictedDirectory() throws IOException {
        File restrictedDirectory = this.createRestrictedDirectory();
        try {
            FileSystemHelper.cleanDirectory((File)restrictedDirectory);
        }
        catch (IOException e) {
            restrictedDirectory.setReadable(true);
            restrictedDirectory.setWritable(true);
            throw e;
        }
        Assert.fail((String)"Cleaning a restricted directory isn't allowed");
    }

    private File createNotExistingDirectory() throws IOException {
        File notExistingDirectory = FileSystemHelper.createTempDir();
        notExistingDirectory.delete();
        Assert.assertFalse((boolean)notExistingDirectory.exists());
        return notExistingDirectory;
    }

    @Test
    public void testCleanEmptyDirectoryDontModifyIt() throws IOException {
        File emptyDirectory = FileSystemHelper.createTempDir();
        this.testDirectoryCleaned(emptyDirectory);
    }

    @Test
    public void testCleanDirectoryContainingNotDirectoryFiles() throws IOException {
        File directoryFullOfFiles = this.createDirectoryFullOfFiles();
        this.testDirectoryCleaned(directoryFullOfFiles);
    }

    private File createDirectoryFullOfFiles() throws IOException {
        File directoryFullOfFiles = FileSystemHelper.createTempDir();
        File subFile1 = new File(directoryFullOfFiles, "subFile1.txt");
        subFile1.createNewFile();
        File subFile2 = new File(directoryFullOfFiles, "subFile2.txt");
        subFile2.createNewFile();
        return directoryFullOfFiles;
    }

    private File createRestrictedDirectory() throws IOException {
        File directory = FileSystemHelper.createTempDir();
        directory.setReadable(false);
        directory.setWritable(false);
        return directory;
    }

    private void testDirectoryCleaned(File directory) throws IOException {
        FileSystemHelper.cleanDirectory((File)directory);
        Assert.assertTrue((boolean)directory.exists());
        Assert.assertTrue((directory.list().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCleanDirectoryContainingNonEmptyDirectories() throws IOException {
        File directoryFullOfDirectories = this.createDirectoryFullOfNotEmptyDirectories();
        this.testDirectoryCleaned(directoryFullOfDirectories);
    }

    @Test
    public void testCleanDirectoryContainingNonEmptyDirectoriesAndFiles() throws IOException {
        File directoryFullOfDirectories = this.createDirectoryFullOfNotEmptyDirectoriesAndFiles();
        this.testDirectoryCleaned(directoryFullOfDirectories);
    }

    private File createDirectoryFullOfNotEmptyDirectories() throws IOException {
        File directoryFullOfDirectories = FileSystemHelper.createTempDir();
        File subDir1 = new File(directoryFullOfDirectories, "subDir");
        subDir1.mkdir();
        File subDir2 = new File(directoryFullOfDirectories, "subDir2");
        subDir2.mkdir();
        File subFile1 = new File(subDir1, "subFile1.txt");
        subFile1.createNewFile();
        File subFile2 = new File(subDir2, "subFile2.txt");
        subFile2.createNewFile();
        return directoryFullOfDirectories;
    }

    private File createDirectoryFullOfNotEmptyDirectoriesAndFiles() throws IOException {
        File directoryFullOfDirectories = this.createDirectoryFullOfNotEmptyDirectories();
        File subFile1 = new File(directoryFullOfDirectories, "subFile1.txt");
        subFile1.createNewFile();
        File subFile2 = new File(directoryFullOfDirectories, "subFile2.txt");
        subFile2.createNewFile();
        return directoryFullOfDirectories;
    }

    @Test
    public void testForceDeleteNotExistingFile() throws IOException {
        File notExistingDirectory = this.createNotExistingDirectory();
        FileSystemHelper.forceDelete((File)notExistingDirectory);
        Assert.assertFalse((boolean)notExistingDirectory.exists());
    }

    @Test
    public void testForceDeleteEmptyDirectory() throws IOException {
        File emptyDirectory = FileSystemHelper.createTempDir();
        this.testFileDeleted(emptyDirectory);
    }

    @Test
    public void testForceDeleteDirectoryContainingNotDirectoryFiles() throws IOException {
        File directoryFullOfFiles = this.createDirectoryFullOfFiles();
        this.testFileDeleted(directoryFullOfFiles);
    }

    @Test
    public void testForceDeleteDirectoryContainingNotEmptyDirectories() throws IOException {
        File directoryFullOfNotEmptyDirectories = this.createDirectoryFullOfNotEmptyDirectories();
        this.testFileDeleted(directoryFullOfNotEmptyDirectories);
    }

    @Test
    public void testForceDeleteDirectoryContainingNotEmptyDirectoriesAndFiles() throws IOException {
        File directoryFullOfNotEmptyDirectories = this.createDirectoryFullOfNotEmptyDirectoriesAndFiles();
        this.testFileDeleted(directoryFullOfNotEmptyDirectories);
    }

    private void testFileDeleted(File file) throws IOException {
        FileSystemHelper.forceDelete((File)file);
        Assert.assertFalse((boolean)file.exists());
    }

    @Test(expected=IOException.class)
    public void testForceDeleteRestrictedDirectory() throws IOException {
        File restrictedDirectory = this.createRestrictedDirectory();
        try {
            FileSystemHelper.forceDelete((File)restrictedDirectory);
        }
        catch (IOException e) {
            restrictedDirectory.setReadable(true);
            restrictedDirectory.setWritable(true);
            throw e;
        }
        Assert.fail((String)"Deleting a restricted directory isn't allowed");
    }
}

