/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.io;

import com.ebmwebsourcing.easycommons.io.FileSystemHelper;
import com.ebmwebsourcing.easycommons.io.IOHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.junit.Assert;
import org.junit.Test;

public class IOHelperTest {
    @Test
    public void testGetLine() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("fileToRead.txt");
        File file = new File(url.toURI());
        String line = IOHelper.getLine((File)file, (int)3);
        Assert.assertEquals((Object)"---line3---", (Object)line);
    }

    @Test
    public void testGetLineWithAWrongLineNumber() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("fileToRead.txt");
        File file = new File(url.toURI());
        String line = IOHelper.getLine((File)file, (int)7);
        Assert.assertEquals(null, (Object)line);
    }

    @Test
    public void testReadEmptyFileAsBytes() throws Exception {
        File testFile = File.createTempFile("testFile", ".bin");
        Assert.assertArrayEquals((byte[])new byte[0], (byte[])IOHelper.readFileAsBytes((File)testFile));
    }

    @Test(expected=IOException.class)
    public void testReadNonExistingFileAsBytes() throws Exception {
        File testFile = File.createTempFile("testFile", ".bin");
        FileSystemHelper.forceDelete((File)testFile);
        IOHelper.readFileAsBytes((File)testFile);
    }

    @Test
    public void testReadFileAsBytes() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("binaryFileToRead.bin");
        File testFile = new File(url.toURI());
        int[] expectedBytesAsInt = new int[]{1, 105, 0, 101, 49, 10, 32, 33, 37, 70, 84, 101, 69, 33, 104, 148, 97, 86, 202, 181, 100, 97, 50, 28, 191};
        byte[] expectedBytes = new byte[expectedBytesAsInt.length];
        for (int i = 0; i < expectedBytesAsInt.length; ++i) {
            expectedBytes[i] = (byte)expectedBytesAsInt[i];
        }
        byte[] readBytes = IOHelper.readFileAsBytes((File)testFile);
        Assert.assertArrayEquals((byte[])expectedBytes, (byte[])readBytes);
    }

    @Test
    public void testReadEmptyFileAsString() throws Exception {
        File testFile = File.createTempFile("testFile", ".txt");
        Assert.assertEquals((Object)"", (Object)IOHelper.readFileAsString((File)testFile));
    }

    @Test
    public void testReadFileAsString() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("fileToRead.txt");
        File file = new File(url.toURI());
        String fileContent = IOHelper.readFileAsString((File)file);
        Assert.assertEquals((Object)"line1\n    line2   \n---line3---\nlast_line", (Object)fileContent);
    }

    @Test(expected=IOException.class)
    public void testReadNonExistingFileAsString() throws Exception {
        File testFile = File.createTempFile("testFile", ".txt");
        FileSystemHelper.forceDelete((File)testFile);
        IOHelper.readFileAsString((File)testFile);
    }

    @Test
    public void testReadFileAsStringWithEmptyLinesAtEnd() throws Exception {
        URL url = Thread.currentThread().getContextClassLoader().getResource("fileToReadWithEmptyLinesAtEnd.txt");
        File file = new File(url.toURI());
        String fileContent = IOHelper.readFileAsString((File)file);
        Assert.assertEquals((Object)"line1\n    line2   \n---line3---\nlast_line\n\n\n", (Object)fileContent);
    }
}

