/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger;

import com.ebmwebsourcing.easycommons.logger.AbstractLogDataAppenderTest;
import com.ebmwebsourcing.easycommons.logger.BasicLogDataAppender;
import com.ebmwebsourcing.easycommons.logger.LogData;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class BasicLogDataAppenderTest
extends AbstractLogDataAppenderTest {
    private static final String TEST_PREFIX = "TESTPREFIX : ";

    @Test
    public void testCanAppendNullDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", null);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendStringDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", "kltsjlfkgjskl");
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendShortDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", (short)14);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendIntegerDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", 145);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendLongDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", 145L);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendDoubleDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", 5.4);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendFloatDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", Float.valueOf(5.4f));
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendByteDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", (byte)10);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendBigIntegerDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", new BigInteger("145"));
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendBigDecimalDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", new BigDecimal(145.45));
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendCharDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", Character.valueOf('c'));
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendBooleanDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", true);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendEnumDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", (Object)TestEnum.ENUM_VAL1);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendObjectDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", new Date());
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendStringArrayDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", new String[]{"s1", "s2", "s3"});
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendIntArrayDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", new int[]{0, 1, 2});
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendIntegerArrayDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", new Integer[]{0, 1, 2});
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendObjectArrayDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", new Object[]{0, 1, 2});
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testCanAppendObjectArrayWithNullDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", new Object[]{0, null, 2});
        BasicLogDataAppender appender = new BasicLogDataAppender();
        Assert.assertTrue((boolean)appender.canAppend((Map)logData, "id"));
    }

    @Test
    public void testAppendNullDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", null);
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = null", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendStringDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", "kltsjlfkgjskl");
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = 'kltsjlfkgjskl'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendShortDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", (short)14);
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = '14'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendIntegerDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", 145);
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = '145'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendLongDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", 145L);
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = '145'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendDoubleDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", 5.44564564564);
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = '5.44564564564'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendFloatDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", Float.valueOf(5.412329f));
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = '5.412329'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendByteDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", (byte)10);
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = '10'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendBigIntegerDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", new BigInteger("187645645646456164651453123445"));
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = '187645645646456164651453123445'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendBigDecimalDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", new BigDecimal("14442545641212315.454564564231232184178941321864131965461"));
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = '14442545641212315.454564564231232184178941321864131965461'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendCharDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", Character.valueOf('c'));
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = 'c'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendBooleanDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", true);
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = 'true'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendEnumDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", (Object)TestEnum.ENUM_VAL1);
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = 'ENUM_VAL1'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendObjectDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", new Date(1L));
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = 'Thu Jan 01 01:00:00 CET 1970'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendStringArrayDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", new String[]{"s1", "s2", "s3"});
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = 's1, s2, s3'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendIntArrayDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", new int[]{0, 1, 2});
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = '0, 1, 2'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendIntegerArrayDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", new Integer[]{0, 1, 2});
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = '0, 1, 2'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendObjectArrayDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", new Object[]{0, 1, 2});
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = '0, 1, 2'", (Object)outBuffer.toString());
    }

    @Test
    public void testAppendObjectArrayWithNullDataValue() {
        LogData logData = BasicLogDataAppenderTest.newTestLogData("id", new Object[]{0, null, 2});
        StringBuffer outBuffer = new StringBuffer(TEST_PREFIX);
        BasicLogDataAppender appender = new BasicLogDataAppender();
        appender.append(outBuffer, (Map)logData, "id");
        Assert.assertEquals((Object)"TESTPREFIX : id = '0, null, 2'", (Object)outBuffer.toString());
    }

    private static enum TestEnum {
        ENUM_VAL1,
        ENUM_VAL2;

    }
}

