/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger;

import com.ebmwebsourcing.easycommons.logger.Level;
import org.junit.Assert;
import org.junit.Test;

public class LevelTest {
    @Test
    public final void testGettingDefaultLevelsReturnJDKObjects() throws Exception {
        Assert.assertSame((Object)java.util.logging.Level.OFF, (Object)Level.OFF);
        Assert.assertSame((Object)java.util.logging.Level.SEVERE, (Object)Level.SEVERE);
        Assert.assertSame((Object)java.util.logging.Level.WARNING, (Object)Level.WARNING);
        Assert.assertSame((Object)java.util.logging.Level.INFO, (Object)Level.INFO);
        Assert.assertSame((Object)java.util.logging.Level.CONFIG, (Object)Level.CONFIG);
        Assert.assertSame((Object)java.util.logging.Level.FINE, (Object)Level.FINE);
        Assert.assertSame((Object)java.util.logging.Level.FINER, (Object)Level.FINER);
        Assert.assertSame((Object)java.util.logging.Level.FINEST, (Object)Level.FINEST);
        Assert.assertSame((Object)java.util.logging.Level.ALL, (Object)Level.ALL);
    }

    @Test
    public final void testMONITLevelBetweenCONFIGandFINE() throws Exception {
        Assert.assertTrue((Level.CONFIG.intValue() > Level.MONIT.intValue() ? 1 : 0) != 0);
        Assert.assertTrue((Level.MONIT.intValue() > Level.FINE.intValue() ? 1 : 0) != 0);
    }

    @Test
    public final void testMONITMSGLevelBetweenMONITandFINE() throws Exception {
        Assert.assertTrue((Level.MONIT.intValue() > Level.MONIT_MSG.intValue() ? 1 : 0) != 0);
        Assert.assertTrue((Level.MONIT_MSG.intValue() > Level.FINE.intValue() ? 1 : 0) != 0);
    }

    @Test
    public final void testGettingMONITLevelSeveralTimesReturnSameObject() throws Exception {
        Assert.assertSame((Object)Level.MONIT, (Object)Level.MONIT);
    }

    @Test
    public final void testGettingMONITMSGLevelSeveralTimesReturnSameObject() throws Exception {
        Assert.assertSame((Object)Level.MONIT_MSG, (Object)Level.MONIT_MSG);
    }

    @Test
    public final void testCheckGetLevelsReturnOrder() throws Exception {
        java.util.logging.Level[] levels = Level.getLevels();
        java.util.logging.Level previous = null;
        for (java.util.logging.Level level : levels) {
            if (previous != null) {
                Assert.assertTrue((String)"Level list isn't correctly ordered", (previous.intValue() > level.intValue() ? 1 : 0) != 0);
            }
            previous = level;
        }
    }

    @Test
    public final void testParsingDefaultLevelsReturnJDKObjects() throws Exception {
        Assert.assertSame((Object)java.util.logging.Level.OFF, (Object)Level.parse((String)"OFF"));
        Assert.assertSame((Object)java.util.logging.Level.SEVERE, (Object)Level.parse((String)"SEVERE"));
        Assert.assertSame((Object)java.util.logging.Level.WARNING, (Object)Level.parse((String)"WARNING"));
        Assert.assertSame((Object)java.util.logging.Level.INFO, (Object)Level.parse((String)"INFO"));
        Assert.assertSame((Object)java.util.logging.Level.CONFIG, (Object)Level.parse((String)"CONFIG"));
        Assert.assertSame((Object)java.util.logging.Level.FINE, (Object)Level.parse((String)"FINE"));
        Assert.assertSame((Object)java.util.logging.Level.FINER, (Object)Level.parse((String)"FINER"));
        Assert.assertSame((Object)java.util.logging.Level.FINEST, (Object)Level.parse((String)"FINEST"));
        Assert.assertSame((Object)java.util.logging.Level.ALL, (Object)Level.parse((String)"ALL"));
    }

    @Test
    public final void testParsingMONITLevels() throws Exception {
        Assert.assertSame((Object)Level.MONIT, (Object)Level.parse((String)"MONIT"));
        Assert.assertSame((Object)Level.MONIT_MSG, (Object)Level.parse((String)"MONIT-MSG"));
    }

    @Test
    public final void testJdkParsingMONITLevels() throws Exception {
        Assert.assertSame((Object)Level.MONIT, (Object)java.util.logging.Level.parse("MONIT"));
        Assert.assertSame((Object)Level.MONIT_MSG, (Object)java.util.logging.Level.parse("MONIT-MSG"));
    }
}

