/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class TestHandler
extends Handler {
    private final List<LogRecord> records = new ArrayList<LogRecord>();

    public List<LogRecord> getAllRecords() {
        return Collections.unmodifiableList(this.records);
    }

    public List<LogRecord> getAllRecords(Level level) {
        ArrayList<LogRecord> records = new ArrayList<LogRecord>();
        for (LogRecord logRecord : this.records) {
            if (!logRecord.getLevel().equals(level)) continue;
            records.add(logRecord);
        }
        return records;
    }

    public void clearRecords() {
        this.records.clear();
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        this.records.add(record);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    public static TestHandler extractTestHandler(Logger logger) {
        Handler[] handlers = logger.getHandlers();
        if (handlers != null && handlers.length > 0) {
            for (Handler handler : handlers) {
                if (!handler.getClass().isAssignableFrom(TestHandler.class)) continue;
                return (TestHandler)handler;
            }
        }
        return null;
    }

    public static final Logger getLoggerWithTestHandler(String loggerName, TestHandler testHandler) {
        assert (loggerName != null);
        assert (testHandler != null);
        Logger logger = Logger.getLogger(loggerName);
        for (Handler h : logger.getHandlers()) {
            logger.removeHandler(h);
        }
        logger.addHandler(testHandler);
        return logger;
    }
}

