/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger.handler;

import com.ebmwebsourcing.easycommons.logger.Level;
import com.ebmwebsourcing.easycommons.logger.LogDataFormatter;
import com.ebmwebsourcing.easycommons.logger.handler.TestFileHandler;
import java.io.IOException;
import java.util.List;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFileHandlerTest {
    private String LOG_RECORD_MESSAGE = "TestFileHandler test message ";
    private TestFileHandler handler;
    private static int count = 0;

    @Before
    public void createHandler() throws IOException {
        this.handler = new TestFileHandler("test_" + count++);
        this.handler.setFormatter((Formatter)new LogDataFormatter());
    }

    @After
    public void afterTest() {
        if (this.handler != null) {
            this.handler.close();
        }
    }

    @Test
    public void testInfoHandlerWithInfoRecord() throws IOException {
        this.handler.setLevel(java.util.logging.Level.INFO);
        this.publish(java.util.logging.Level.INFO, 10);
        this.testLogEntries(this.handler.getLogEntries(), 10);
    }

    @Test
    public void testFinestHandlerWithMonitRecord() throws IOException {
        this.handler.setLevel(java.util.logging.Level.FINEST);
        this.publish(Level.MONIT, 10);
        Assert.assertTrue((this.handler.getLogEntries().size() == 10 ? 1 : 0) != 0);
        this.testLogEntries(this.handler.getLogEntries(), 10);
    }

    @Test
    public void testInfoHandlerWithFinestRecord() throws IOException {
        this.handler.setLevel(java.util.logging.Level.INFO);
        this.publish(java.util.logging.Level.FINEST, 10);
        Assert.assertTrue((this.handler.getLogEntries().size() == 0 ? 1 : 0) != 0);
    }

    private void testLogEntries(List<String> logEntries, int expectedEntry) {
        Assert.assertTrue((logEntries.size() == expectedEntry ? 1 : 0) != 0);
        for (int i = 0; i < 10; ++i) {
            Assert.assertTrue((boolean)logEntries.get(i).endsWith(this.LOG_RECORD_MESSAGE + i));
        }
    }

    private void publish(java.util.logging.Level level, int nb) {
        for (int i = 0; i < nb; ++i) {
            this.handler.publish(new LogRecord(level, this.LOG_RECORD_MESSAGE + i));
        }
    }
}

