/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easycommons.logger;

import com.ebmwebsourcing.easycommons.logger.TestHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Test;

public class TestHandlerTest {
    private final String LOG_RECORD_MSG = "TestPublishLogRecord record: ";

    @Test
    public void testGetAllRecordsAfterInit() {
        TestHandler testHandler = new TestHandler();
        Assert.assertTrue((String)"TestHandler is empty after initialization", (testHandler.getAllRecords().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetAllRecords() {
        TestHandler testHandler = new TestHandler();
        Assert.assertTrue((String)"TestHandler isn't empty after initialization", (testHandler.getAllRecords().size() == 0 ? 1 : 0) != 0);
        testHandler.publish(new LogRecord(Level.INFO, "TestPublishLogRecord record: 1"));
        Assert.assertTrue((String)"TestHandler hasn't 1 log record", (testHandler.getAllRecords().size() == 1 ? 1 : 0) != 0);
        testHandler.publish(new LogRecord(Level.INFO, "TestPublishLogRecord record: 2"));
        Assert.assertTrue((String)"TestHandler hasn't 2 log records", (testHandler.getAllRecords().size() == 2 ? 1 : 0) != 0);
        testHandler.publish(new LogRecord(Level.INFO, "TestPublishLogRecord record: 3"));
        Assert.assertTrue((String)"TestHandler hasn't 3 log records", (testHandler.getAllRecords().size() == 3 ? 1 : 0) != 0);
        testHandler.publish(new LogRecord(Level.INFO, "TestPublishLogRecord record: 4"));
        Assert.assertTrue((String)"TestHandler hasn't 4 log records", (testHandler.getAllRecords().size() == 4 ? 1 : 0) != 0);
        testHandler.publish(new LogRecord(Level.INFO, "TestPublishLogRecord record: 5"));
        Assert.assertTrue((String)"TestHandler hasn't 5 log records", (testHandler.getAllRecords().size() == 5 ? 1 : 0) != 0);
    }

    @Test
    public void testGetAllRecordsForLevel() {
        TestHandler testHandler = new TestHandler();
        Assert.assertTrue((String)"TestHandler is empty after initialization", (testHandler.getAllRecords().size() == 0 ? 1 : 0) != 0);
        testHandler.publish(new LogRecord(Level.INFO, "TestPublishLogRecord record: 1"));
        testHandler.publish(new LogRecord(Level.INFO, "TestPublishLogRecord record: 2"));
        testHandler.publish(new LogRecord(Level.INFO, "TestPublishLogRecord record: 3"));
        testHandler.publish(new LogRecord(Level.FINEST, "TestPublishLogRecord record: 4"));
        testHandler.publish(new LogRecord(Level.FINEST, "TestPublishLogRecord record: 5"));
        testHandler.publish(new LogRecord(Level.SEVERE, "TestPublishLogRecord record: 6"));
        Assert.assertTrue((String)"3 records aren't recovered for INFO log level", (testHandler.getAllRecords(Level.INFO).size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"2 records aren't recovered for INFO log level", (testHandler.getAllRecords(Level.FINEST).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"1 records aren't recovered for INFO log level", (testHandler.getAllRecords(Level.SEVERE).size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testClearRecords() {
        TestHandler testHandler = new TestHandler();
        Assert.assertTrue((String)"TestHandler isn't empty after initialization", (testHandler.getAllRecords().size() == 0 ? 1 : 0) != 0);
        testHandler.publish(new LogRecord(Level.INFO, "TestPublishLogRecord record: 1"));
        Assert.assertTrue((String)"TestHandler hasn't one log record", (testHandler.getAllRecords().size() == 1 ? 1 : 0) != 0);
        testHandler.publish(new LogRecord(Level.INFO, "TestPublishLogRecord record: 2"));
        Assert.assertTrue((String)"TestHandler hasn't two log record", (testHandler.getAllRecords().size() == 2 ? 1 : 0) != 0);
        testHandler.clearRecords();
        Assert.assertTrue((String)"TestHandler isn't empty after cleaning", (testHandler.getAllRecords().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPublishLogRecord() {
        TestHandler testHandler = new TestHandler();
        Assert.assertTrue((String)"TestHandler isn't empty after initialization", (testHandler.getAllRecords().size() == 0 ? 1 : 0) != 0);
        testHandler.publish(new LogRecord(Level.INFO, "TestPublishLogRecord record: 1"));
        Assert.assertTrue((String)"TestHandler hasn't one log record", (testHandler.getAllRecords().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"TestPublishLogRecord record:  uncorrectly published", (boolean)testHandler.getAllRecords().get(0).getMessage().equals("TestPublishLogRecord record: 1"));
    }

    @Test
    public void testPublishLogRecordLevelOFF() {
        TestHandler testHandler = new TestHandler();
        testHandler.setLevel(Level.OFF);
        testHandler.publish(new LogRecord(Level.INFO, "TestPublishLogRecord record: 1"));
        Assert.assertTrue((boolean)testHandler.getAllRecords().isEmpty());
    }

    @Test
    public void testGetLoggerWithTestHandler() {
        TestHandler testHandler = new TestHandler();
        Logger logger = TestHandler.getLoggerWithTestHandler("testLogger", testHandler);
        Assert.assertEquals((Object)"testLogger", (Object)logger.getName());
        Assert.assertEquals((long)1L, (long)logger.getHandlers().length);
        Assert.assertEquals((Object)testHandler, (Object)logger.getHandlers()[0]);
    }
}

