/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.esb.impl;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easyesb.component.bpel.impl.BPELComponentBehaviourImpl;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.SOAPListenerImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.factory.ESBCoreFactoryImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ListenerInitialisation;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.AdminServiceCreationFactory;
import com.ebmwebsourcing.easyesb.viper.behaviour.command.impl.ViperComponentCommandBehaviourImpl;
import com.ebmwebsourcing.easyesb.viper.behaviour.notification.impl.ViperComponentNotificationBehaviourImpl;
import com.ebmwebsourcing.easyesb.viper.behaviour.observation.impl.ViperComponentObservationBehaviourImpl;
import java.net.URI;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.service.api.Service;

public class ESBAddOnsFactoryImpl
extends ESBCoreFactoryImpl
implements ESBFactory {
    private static Logger log = Logger.getLogger(ESBAddOnsFactoryImpl.class.getName());
    protected AdminEndpoint<?> adminEndpoint = null;

    public ESBAddOnsFactoryImpl(String ... factoryToExclude) {
        super(factoryToExclude);
    }

    public Node createNode(QName name, Configuration conf) throws ESBException {
        EndpointAddress epr;
        Node node = super.createNode(name, conf);
        URI bpelComponentURI = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(new QName(node.getQName().getNamespaceURI(), "BPELEngine"), null, new QueryParam[0]));
        Component bpelComponent = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getComponent(bpelComponentURI);
        bpelComponent.addBehaviourClass(ViperComponentObservationBehaviourImpl.class);
        bpelComponent.addBehaviourClass(ViperComponentCommandBehaviourImpl.class);
        bpelComponent.addBehaviourClass(ViperComponentNotificationBehaviourImpl.class);
        QName endpointQName = new QName(bpelComponent.getQName().getNamespaceURI(), "BPELAdminExternalEndpoint");
        ListenerInitialisation listener = (ListenerInitialisation)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(ListenerInitialisation.class);
        listener.setClassName(SOAPListenerImpl.class.getName());
        listener.setServerName(SoapServer.DEFAULT_NAME);
        ClientProxyEndpoint cpe = (ClientProxyEndpoint)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(endpointQName, ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, (EndpointInitialContext)null, new ListenerInitialisation[]{listener});
        cpe.addBehaviourClass(ClientProxyBehaviourImpl.class);
        QName endpointServiceName = new QName(node.getQName().getNamespaceURI(), ((Service)((BPELComponentBehaviourImpl)bpelComponent.findBehaviour(BPELComponentBehaviourImpl.class)).getEndpoint().getDescription().getServices().iterator().next()).getQName().getLocalPart());
        URI reference = ((BPELComponentBehaviourImpl)bpelComponent.findBehaviour(BPELComponentBehaviourImpl.class)).getEndpoint().getReference();
        cpe.setProviderServiceName(endpointServiceName);
        try {
            epr = ESBUtil.analyzeURI((URI)reference);
        }
        catch (SOAException e) {
            epr = null;
        }
        assert (epr != null);
        String endpointName = epr.getEndpointname();
        cpe.setProviderEndpointName(endpointName);
        AdminServiceCreationFactory adminFactory = (AdminServiceCreationFactory)this.servicesFactory.get("admin-service-factory");
        adminFactory.exposeAdminService(node);
        return node;
    }

    @Override
    public AdminEndpoint<?> getAdminEndpoint() {
        if (this.adminEndpoint == null) {
            AdminServiceCreationFactory adminFactory = (AdminServiceCreationFactory)this.servicesFactory.get("admin-service-factory");
            this.adminEndpoint = adminFactory.getAdminEndpoint();
        }
        return this.adminEndpoint;
    }
}

