/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.bpel.behaviour.notification.test;

import com.ebmwebsourcing.easycommons.xml.DocumentBuilderHelper;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.bpel.behaviour.command.impl.BPELComponentCommandBehaviourImpl;
import com.ebmwebsourcing.easyesb.bpel.behaviour.notification.impl.BPELComponentNotificationBehaviourImpl;
import com.ebmwebsourcing.easyesb.bpel.behaviour.notification.test.SubscribeComparator;
import com.ebmwebsourcing.easyesb.bpel.behaviour.observation.impl.BPELComponentObservationBehaviourImpl;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELComponent;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELComponentBehaviour;
import com.ebmwebsourcing.easyesb.component.bpel.impl.BPELComponentBehaviourImpl;
import com.ebmwebsourcing.easyesb.component.bpel.impl.BPELComponentImpl;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Body;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageIn;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.SOAPListenerImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.SOAPSenderImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.behaviour.proxy.SoapProviderProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServerConfig;
import com.ebmwebsourcing.easyesb.soa.ESBKernelFactoryImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.ComponentBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderProxyEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.external.ExternalServer;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.soa.api.util.SOAUtil;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.BusinessServiceImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.technical.service.registry.RegistryServiceBehaviourImpl;
import com.ebmwebsourcing.easyesb.technical.service.registry.RegistryServiceImpl;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyviper.administration.GetProcessInstancesNames;
import com.ebmwebsourcing.easyviper.administration.GetProcessInstancesNamesResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.logging.LogManager;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.oasis_open.docs.wsn.bw_2.NotificationConsumer_NotificationConsumerPort_Server;
import org.w3c.dom.Document;
import petals.ow2.org.demo.travelagency.airline.AirLineBook_AirLineBook_Server;

public class BPELComponentNotificationBehaviourTest {
    private EndpointInitialContext context = null;
    private ClientEndpoint clientEndpoint = null;
    private BPELComponent component = null;
    private Node node = null;
    private List<ProviderEndpointType> endpoints = null;
    private SoapServer soapServer = null;
    private NotificationConsumer_NotificationConsumerPort_Server notifConsumerPartner = null;
    private ProviderProxyEndpoint providerEndpoint = null;

    private Node createNode(QName name, boolean explorer, String host, int port) throws ESBException {
        ESBKernelFactoryImpl factory = new ESBKernelFactoryImpl();
        this.soapServer = new SoapServer(new SoapServerConfig(8085));
        ConfigurationImpl conf = new ConfigurationImpl(explorer, host, port, new ExternalServer[]{this.soapServer});
        conf.setRegistryServiceClass(RegistryServiceImpl.class);
        conf.setRegistryServiceBehaviourClass(RegistryServiceBehaviourImpl.class);
        this.node = factory.createNode(name, (Configuration)conf);
        return this.node;
    }

    @Before
    public void setUp() {
        boolean explorer = false;
        try {
            this.context = (EndpointInitialContext)SOAUtil.getInstance().getXmlObjectFactory().create(EndpointInitialContext.class);
            this.context.setNumberOfThreads(5);
            this.node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), explorer, "localhost", 9001);
            this.component = (BPELComponent)((NodeBehaviour)this.node.findBehaviour(NodeBehaviour.class)).createComponent(new QName("http://com.ebmwebsourcing.easyesb", "BPELEngine"), BPELComponentImpl.class);
            this.component.addBehaviourClass(BPELComponentObservationBehaviourImpl.class);
            this.component.addBehaviourClass(BPELComponentBehaviourImpl.class);
            this.component.addBehaviourClass(BPELComponentCommandBehaviourImpl.class);
            this.component.addBehaviourClass(BPELComponentNotificationBehaviourImpl.class);
            this.clientEndpoint = ((NodeBehaviour)this.node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName("http://org.petalslink.easyesb/bpel/client", "myBPELComponentClient"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, this.context);
            URL bpel = Thread.currentThread().getContextClassLoader().getResource("travelagency/processforNotifTest.bpel");
            this.endpoints = ((BPELComponentBehaviour)this.component.findBehaviour(BPELComponentBehaviour.class)).store(bpel);
            ClientProxyEndpoint travelAgencyProxyClientEndpoint = (ClientProxyEndpoint)((NodeBehaviour)this.node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName("http://org.ow2.petals/demo/travelagency/agency/", "travelAgencyServiceProxyEndpoint"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, this.context);
            travelAgencyProxyClientEndpoint.addBehaviourClass(ClientProxyBehaviourImpl.class);
            travelAgencyProxyClientEndpoint.setProviderServiceName(this.endpoints.get(0).getService());
            travelAgencyProxyClientEndpoint.setProviderEndpointName(this.endpoints.get(0).getName());
            SOAPListenerImpl soapListener = new SOAPListenerImpl(travelAgencyProxyClientEndpoint, this.soapServer);
            travelAgencyProxyClientEndpoint.getExternalListeners().put("SOAP", soapListener);
            AirLineBook_AirLineBook_Server airLinePartner = new AirLineBook_AirLineBook_Server();
            this.notifConsumerPartner = new NotificationConsumer_NotificationConsumerPort_Server();
            Service providerService = ((ComponentBehaviour)this.node.findBehaviour(ComponentBehaviour.class)).createService(new QName("http://www.ebmwebsourcing.com/wsstar/wsn/NotificationConsumer", "NotificationConsumerService"), BusinessServiceImpl.class);
            this.providerEndpoint = (ProviderProxyEndpoint)((ServiceBehaviour)providerService.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint("NotificationConsumerPort", ProviderProxyEndpointImpl.class, this.context);
            this.providerEndpoint.addBehaviourClass(SoapProviderProxyBehaviourImpl.class);
            this.providerEndpoint.setExternalAddress("http://localhost:9666/NotificationConsumerEndpoint");
            this.providerEndpoint.setWSDLDescriptionAddress(Thread.currentThread().getContextClassLoader().getResource("notificationPartner/NotificationConsumer.wsdl").toURI());
            this.providerEndpoint.getExternalSenders().put("soap", new SOAPSenderImpl());
            URL url = Thread.currentThread().getContextClassLoader().getResource("notificationPartner/NotificationConsumer.wsdl");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @After
    public void tearDown() {
        try {
            if (this.node != null) {
                this.node.stop();
            }
            if (this.soapServer != null) {
                this.soapServer.stop();
            }
        }
        catch (TransportException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testSubscribe() {
        try {
            Exchange exchangeGetInstance = this.clientEndpoint.createExchange();
            exchangeGetInstance.setDestination(this.component.getQName());
            exchangeGetInstance.setPattern(PatternType.IN_OUT);
            exchangeGetInstance.setStatus(StatusType.ACTIVE);
            exchangeGetInstance.setOperation(new QName("http://ebmwebsourcing.com/easyviper/observation", "getProcessInstancesNames").toString());
            SOAUtil.getInstance().createInMessageStructure(exchangeGetInstance);
            GetProcessInstancesNames instanceIn = new GetProcessInstancesNames();
            instanceIn.setProcessDefinitionNameDataModel(new QName("http://org.ow2.petals/demo/travelagency/agency/", "travelAgency"));
            exchangeGetInstance.getMessageIn().getBody().setPayload(SOAJAXBContext.unmarshallAnyElement((Object)instanceIn));
            Exchange responseGetInstances = this.clientEndpoint.sendSync(exchangeGetInstance, 0L);
            GetProcessInstancesNamesResponse res = (GetProcessInstancesNamesResponse)SOAJAXBContext.marshallAnyType((Document)responseGetInstances.getMessageOut().getBody().getPayload(), GetProcessInstancesNamesResponse.class);
            String instanceName = (String)res.getProcessDefinitionName().get(0);
            Exchange exchange = this.clientEndpoint.createExchange();
            exchange.setDestination(this.component.getQName());
            exchange.setPattern(PatternType.IN_OUT);
            exchange.setStatus(StatusType.ACTIVE);
            exchange.setOperation(new QName("http://ebmwebsourcing.com/easyviper/notification", "Subscribe").toString());
            SOAUtil.getInstance().createInMessageStructure(exchange);
            Document subDom = DocumentBuilderHelper.getNamespaceDocumentBuilder().parse(new File(Thread.currentThread().getContextClassLoader().getResource("subscription/subscribe.xml").toURI()));
            exchange.getMessageIn().getBody().setPayload(subDom);
            Exchange resStop = this.clientEndpoint.sendSync(exchange, 0L);
            Document subresDom = resStop.getMessageOut().getBody().getPayload();
            Assert.assertNotNull((Object)subresDom);
            System.out.println("##### Subscribe response ########");
            System.out.println(XMLPrettyPrinter.prettyPrint((Document)subresDom));
            System.out.println("#################################");
            String expectedSubRes = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><wsnt:SubscribeResponse xmlns:wsnt=\"http://docs.oasis-open.org/wsn/b-2\"><wsnt:SubscriptionReference><wsa:Address xmlns:wsa=\"http://www.w3.org/2005/08/addressing\">{http://www.ebmwebsourcing.com/wsstar/wsn/NotificationConsumer}NotificationProducerService::NotificationConsumerPort</wsa:Address><wsa:ReferenceParameters xmlns:wsa=\"http://www.w3.org/2005/08/addressing\"><ebm:SOAParameter xmlns:ebm=\"http://www.ebmwebsourcing.com/wsnotification/specificTypes\"><ebm:InterfaceName xmlns=\"http://www.ebmwebsourcing.com/default\">SubscriptionManager</ebm:InterfaceName><ebm:ServiceName xmlns=\"http://www.ebmwebsourcing.com/default\">SubscriptionManagerService</ebm:ServiceName><ebm:Endpoint>http://www.ebmwebsourcing.com/subscriptionManager/default</ebm:Endpoint></ebm:SOAParameter><ebm:ResourceUuidList xmlns:ebm=\"http://www.ebmwebsourcing.com/wsnotification/specificTypes\"><ebm:Uuid>c3b6de3b-f045-4503-b428-fb6a1c196cbd</ebm:Uuid></ebm:ResourceUuidList></wsa:ReferenceParameters></wsnt:SubscriptionReference><wsnt:TerminationTime xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:nil=\"true\"/></wsnt:SubscribeResponse>";
            String actualSubRes = XMLPrettyPrinter.prettyPrint((Document)subresDom);
            System.out.println(SubscribeComparator.isSimilar(expectedSubRes, actualSubRes));
            Assert.assertTrue((boolean)SubscribeComparator.isSimilar(expectedSubRes, actualSubRes));
            System.out.println("endpoints created: " + this.endpoints);
            Assert.assertEquals((long)1L, (long)this.endpoints.size());
            Assert.assertEquals((Object)"travelAgencyServiceEndpoint", (Object)this.endpoints.get(0).getName().getLocalPart());
            ProviderEndpointType providerEndpointType = this.endpoints.get(0);
            Exchange exchangeTravel = this.clientEndpoint.createExchange();
            exchangeTravel.setDestination(providerEndpointType.getName());
            exchangeTravel.setInterfaceName(new QName("http://org.ow2.petals/demo/travelagency/agency/", "travelAgency"));
            exchangeTravel.setPattern(PatternType.IN_OUT);
            exchangeTravel.setStatus(StatusType.ACTIVE);
            exchangeTravel.setOperation(new QName("http://org.ow2.petals/demo/travelagency/agency/", "process").toString());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            String fileName = new File(".") + "/src/test/resources/travelagency/messages/ProcessRequest.xml";
            Document doc = factory.newDocumentBuilder().parse(new File(fileName));
            MessageIn msgIn = (MessageIn)SOAUtil.getInstance().getXmlObjectFactory().create(MessageIn.class);
            Body body = (Body)SOAUtil.getInstance().getXmlObjectFactory().create(Body.class);
            msgIn.setBody(body);
            exchangeTravel.setMessageIn(msgIn);
            exchangeTravel.getMessageIn().getBody().setPayload(doc);
            Exchange response = this.clientEndpoint.sendSync(exchangeTravel, 0L);
            String responseMsg = XMLPrettyPrinter.prettyPrint((Document)response.getMessageOut().getBody().getPayload());
            boolean istimeout = false;
            long begin = System.currentTimeMillis();
            long timeout = 4000L;
            while (this.notifConsumerPartner.getNotifications().size() < 6 && !istimeout) {
                System.out.println("Waiting for all notifications to be sent ..." + this.notifConsumerPartner.getNotifications().size());
                Thread.sleep(200L);
                System.out.println(System.currentTimeMillis() - begin);
                istimeout = System.currentTimeMillis() - begin > timeout;
            }
            System.out.println(this.notifConsumerPartner.getNotifications().size());
            Assert.assertTrue((this.notifConsumerPartner.getNotifications().size() == 6 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (IOException ex) {
            System.out.println("WARNING: Could not open configuration file");
            System.out.println("WARNING: Logging not configured (console output only)");
        }
    }
}

