/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.component.bpel.test;

import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELComponent;
import com.ebmwebsourcing.easyesb.component.bpel.api.BPELComponentBehaviour;
import com.ebmwebsourcing.easyesb.component.bpel.impl.BPELComponentBehaviourImpl;
import com.ebmwebsourcing.easyesb.component.bpel.impl.BPELComponentImpl;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Body;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageIn;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.factory.ESBCoreFactoryImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.easyesb.soa10.api.element.ListenerInitialisation;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import petals.ow2.org.demo.travelagency.airline.AirLineBook_AirLineBook_Server;
import petals.ow2.org.demo.travelagency.car.Car_CarSOAP_Server;
import petals.ow2.org.demo.travelagency.hotel.Hotel_HotelSOAP_Server;

public class BPELComponentTest {
    private Logger log = Logger.getLogger(BPELComponentTest.class.getName());
    private SoapServer soapServer = null;
    private EndpointInitialContext context = (EndpointInitialContext)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);

    public BPELComponentTest() throws Exception {
        this.context.setNumberOfThreads(5);
    }

    private Node createNode(QName name, boolean explorer, String host, int port) throws ESBException {
        ESBCoreFactoryImpl factory = new ESBCoreFactoryImpl(new String[0]);
        ConfigurationImpl conf = new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, "8095");
            }
        });
        Node node = factory.createNode(name, (Configuration)conf);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTravelAgency() throws Exception {
        boolean explorer = false;
        AirLineBook_AirLineBook_Server airLinePartner = null;
        Hotel_HotelSOAP_Server hotelPartner = null;
        Car_CarSOAP_Server carPartner = null;
        Node node = null;
        try {
            airLinePartner = new AirLineBook_AirLineBook_Server();
            hotelPartner = new Hotel_HotelSOAP_Server();
            carPartner = new Car_CarSOAP_Server();
            node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), explorer, "localhost", 9001);
            System.out.println("node: " + (NodeBehaviour)node.findBehaviour(NodeBehaviour.class));
            BPELComponent component = (BPELComponent)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createComponent("BPELEngine", BPELComponentImpl.class);
            component.addBehaviourClass(BPELComponentBehaviourImpl.class);
            URL bpel = Thread.currentThread().getContextClassLoader().getResource("travelagency/travelagency.bpel");
            List endpoints = ((BPELComponentBehaviour)component.findBehaviour(BPELComponentBehaviour.class)).store(bpel).getEndpointList();
            System.out.println("endpoints created: " + endpoints);
            Assert.assertEquals((int)1, (int)endpoints.size());
            Assert.assertEquals((String)"travelAgencyServiceEndpoint", (String)((ProviderEndpointType)endpoints.get(0)).getName());
            ProviderEndpointType providerEndpointType = (ProviderEndpointType)endpoints.get(0);
            ClientEndpoint clientEndpoint = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createClientEndpoint(new QName("http://com.ebmwebsourcing.easyesb/bpel", "travelAgencyClientEndpoint"), ClientProxyEndpointImpl.class, ClientProxyBehaviourImpl.class, this.context, new ListenerInitialisation[0]);
            Exchange exchange = clientEndpoint.createExchange();
            exchange.setDestinationReference(providerEndpointType.getReference());
            exchange.setInterfaceName(new QName("http://org.ow2.petals/demo/travelagency/agency/", "travelAgency"));
            exchange.setPattern(PatternType.IN_OUT);
            exchange.setStatus(StatusType.ACTIVE);
            exchange.setOperation(new QName("http://org.ow2.petals/demo/travelagency/agency/", "bookTravel").toString());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document doc = factory.newDocumentBuilder().parse(Thread.currentThread().getContextClassLoader().getResourceAsStream("travelagency/messages/ProcessRequest.xml"));
            MessageIn msgIn = (MessageIn)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageIn.class);
            Body body = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
            msgIn.setBody(body);
            exchange.setMessageIn(msgIn);
            exchange.getMessageIn().getBody().setPayload(doc);
            Exchange response = clientEndpoint.sendSync(exchange, 0L);
            String responseMsg = XMLPrettyPrinter.prettyPrint((Document)response.getMessageOut().getBody().getPayload());
            System.out.println("response = " + responseMsg);
            String expectedMessage = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<bookTravelResponse xmlns=\"http://org.ow2.petals/demo/travelagency/agency/\">\n  <validated>true</validated>\n  <airLineReservationId>1</airLineReservationId>\n  <hotelReservationId>true</hotelReservationId>\n  <carReservationId>true</carReservationId>\n</bookTravelResponse>";
            Assert.assertEquals((String)expectedMessage.trim(), (String)responseMsg.trim());
        }
        finally {
            if (node != null) {
                node.stop();
            }
            if (this.soapServer != null) {
                this.soapServer.stop();
            }
            if (airLinePartner != null) {
                airLinePartner.shutdown();
            }
            if (hotelPartner != null) {
                hotelPartner.shutdown();
            }
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
        }
        catch (IOException ex) {
            System.out.println("WARNING: Could not open configuration file");
            System.out.println("WARNING: Logging not configured (console output only)");
        }
    }
}

