/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.component.bpel.impl.env;

import com.ebmwebsourcing.easybpel.model.bpel.api.BPELException;
import com.ebmwebsourcing.easybpel.model.bpel.impl.exception.UserDefinedException;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easyesb.component.bpel.impl.message.ESBContextImpl;
import com.ebmwebsourcing.easyesb.component.bpel.thread.NotifySenderCallable;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Body;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageError;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageIn;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageOut;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.env.Sender;
import com.ebmwebsourcing.easyviper.core.api.soa.Partner;
import com.ebmwebsourcing.easyviper.core.api.soa.message.Message;
import com.ebmwebsourcing.easyviper.core.impl.engine.ProcessImpl;
import com.ebmwebsourcing.easyviper.core.impl.env.AbstractSenderImpl;
import com.ebmwebsourcing.easyviper.core.impl.soa.message.MessageImpl;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.DOMBuilder;
import org.jdom.output.DOMOutputter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

@Scope(value="COMPOSITE")
@Service(value={Sender.class}, names={"service"})
@PolicySets(value={"frascati:scaEasyPrimitive"})
public class ESBSenderImpl
extends AbstractSenderImpl
implements Sender {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ESBSenderImpl.class.getName());
    private ExecutorService executorService = Executors.newFixedThreadPool(2);

    public void sendTo(Message message, String address, Map<Partner, Map<String, ExternalContext>> context, boolean isReply) throws CoreException {
        ESBContextImpl esbContext = (ESBContextImpl)ProcessImpl.getFirstExternalContext(context);
        try {
            log.finest("Asynchronous send: PROVIDER ENDPOINT NAME: " + address);
            if (message != null) {
                log.finest("MESSAGE SENT BY BPEL ENGINE: \n" + message);
            } else {
                MessageImpl messageNull = new MessageImpl("dummyOperation");
                Document doc = new Document();
                Element nullElement = new Element("null");
                doc.addContent((Content)nullElement);
                messageNull.getBody().setPayload(nullElement);
                log.finest("MESSAGE SENT BY BPEL ENGINE: \n" + messageNull);
            }
            if (!isReply) {
                if (message.getEndpoint() == null && message.getService() == null && address != null) {
                    DOMOutputter converter = new DOMOutputter();
                    org.w3c.dom.Document domDocument = converter.output(message.getBody().getPayload().getDocument());
                    NotifySenderCallable callable = new NotifySenderCallable(domDocument, address, null);
                    this.executorService.submit(callable);
                } else {
                    log.finest("send to partner: " + address);
                    ProviderEndpoint providerEp = esbContext.getProviderEndpoint();
                    Exchange ex = providerEp.createExchange();
                    ex.setDestinationReference(ESBUtil.generateURI((EndpointAddress)new EndpointAddress(message.getService(), message.getEndpoint(), new QueryParam[0])));
                    ex.setOperation(new QName(message.getInterface().getNamespaceURI(), message.getOperationName()).toString());
                    ex.setInterfaceName(message.getInterface());
                    ex.setPattern(PatternType.IN_ONLY);
                    MessageIn msgIn = (MessageIn)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageIn.class);
                    Body body = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
                    msgIn.setBody(body);
                    ex.setMessageIn(msgIn);
                    DOMOutputter converter = new DOMOutputter();
                    org.w3c.dom.Document domDocument = converter.output(message.getBody().getPayload().getDocument());
                    ex.getMessageIn().getBody().setPayload(domDocument);
                    providerEp.send(ex);
                }
            } else {
                log.finest("send response to client");
                Exchange exchange = esbContext.getInitialExchange();
                if (exchange.getMessageOut() == null) {
                    MessageOut msgOut = (MessageOut)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageOut.class);
                    exchange.setMessageOut(msgOut);
                }
                if (exchange.getMessageOut().getBody() == null) {
                    Body body = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
                    exchange.getMessageOut().setBody(body);
                }
                DOMOutputter converter = new DOMOutputter();
                org.w3c.dom.Document domDocument = converter.output(message.getBody().getPayload().getDocument());
                exchange.getMessageOut().getBody().setPayload(domDocument);
                exchange.setStatus(StatusType.DONE);
                ProviderEndpoint providerEp = esbContext.getProviderEndpoint();
                providerEp.sendResponseToClient(exchange);
            }
        }
        catch (BPELException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException((Throwable)e);
        }
        catch (ExchangeException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException((Throwable)e);
        }
        catch (TransportException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException((Throwable)e);
        }
        catch (JDOMException e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException((Throwable)e);
        }
    }

    public Message sendSyncTo(Message message, String address, Map<Partner, Map<String, ExternalContext>> context) throws CoreException {
        ESBContextImpl esbContext = (ESBContextImpl)ProcessImpl.getFirstExternalContext(context);
        try {
            log.finest("Synchronous send: PROVIDER ENDPOINT NAME: " + address);
            if (message != null) {
                log.finest("MESSAGE SENT SYNC BY BPEL engine: \n" + message);
            } else {
                MessageImpl messageNull = new MessageImpl("dummyOperation");
                Document doc = new Document();
                Element nullElement = new Element("null");
                doc.addContent((Content)nullElement);
                messageNull.getBody().setPayload(nullElement);
                log.finest("MESSAGE SENT SYNC BY BPEL engine: \n" + messageNull);
            }
            ProviderEndpoint providerEp = esbContext.getProviderEndpoint();
            Exchange ex = providerEp.createExchange();
            ex.setDestinationReference(ESBUtil.generateURI((EndpointAddress)new EndpointAddress(message.getService(), message.getEndpoint(), new QueryParam[0])));
            ex.setOperation(new QName(message.getService().getNamespaceURI(), message.getOperationName()).toString());
            ex.setInterfaceName(message.getInterface());
            ex.setPattern(PatternType.IN_OUT);
            MessageIn msgIn = (MessageIn)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageIn.class);
            Body body = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
            msgIn.setBody(body);
            ex.setMessageIn(msgIn);
            DOMOutputter converter = new DOMOutputter();
            org.w3c.dom.Document domDocument = converter.output(message.getBody().getPayload().getDocument());
            ex.getMessageIn().getBody().setPayload(domDocument);
            ex = providerEp.sendSync(ex, new Long(0L).longValue());
            if (ex.getMessageError() == null || ex.getMessageError().getBody() == null || ex.getMessageError().getBody().getPayload() == null) {
                MessageImpl responseMessage = new MessageImpl(message.getOperationName());
                responseMessage.setEndpoint(message.getEndpoint());
                responseMessage.setService(message.getService());
                DOMBuilder builder = new DOMBuilder();
                Document jdomDocument = builder.build(ex.getMessageOut().getBody().getPayload());
                responseMessage.getBody().setPayload(jdomDocument.getRootElement());
                log.finest("MESSAGE RECEIVED BY BPEL engine: \n" + responseMessage);
                return responseMessage;
            }
            MessageImpl faultMsg = new MessageImpl(ex.getOperation());
            DOMBuilder builder = new DOMBuilder();
            if (ex.getMessageError().getBody().getPayload() != null) {
                Document faultJDoc = builder.build(ex.getMessageError().getBody().getPayload());
                log.finest("fault on bpel send: \n" + new XMLOutputter(Format.getPrettyFormat()).outputString(faultJDoc));
                faultMsg.getBody().setPayload(faultJDoc.getRootElement());
            }
            EndpointAddress epr = ESBUtil.analyzeURI((URI)ex.getDestinationReference());
            faultMsg.setEndpoint(epr.getEndpointname());
            faultMsg.setService(message.getService());
            CoreException userEx = new CoreException();
            userEx.setFault((Message)faultMsg);
            throw userEx;
        }
        catch (Exception e) {
            log.warning("Error on invoke: " + e.getMessage());
            throw new CoreException((Throwable)e);
        }
    }

    public void sendTo(CoreException e, Map<Partner, Map<String, ExternalContext>> context) throws CoreException {
        try {
            ESBContextImpl esbContext = (ESBContextImpl)ProcessImpl.getFirstExternalContext(context);
            Exchange exchange = esbContext.getInitialExchange();
            log.warning("Send error: " + exchange.getPattern());
            if (PatternType.IN_OUT.equals((Object)exchange.getPattern())) {
                if (e instanceof UserDefinedException) {
                    log.warning("Send business fault: \n" + e);
                } else {
                    log.warning("Send technical fault: \n" + e);
                    e.printStackTrace();
                }
                Element internalMsg = null;
                log.warning("mmmmmmmmmm e.getFault(): \n" + e.getFault());
                if (e.getFault() != null) {
                    internalMsg = e.getFault().getBody().getPayload();
                }
                DOMOutputter converter = new DOMOutputter();
                log.warning("internalMsg = " + internalMsg);
                if (internalMsg != null) {
                    org.w3c.dom.Document domDocument = converter.output(internalMsg.getDocument());
                    log.warning("fault on bpel send 2: \n" + new XMLOutputter(Format.getPrettyFormat()).outputString(internalMsg));
                    if (exchange.getMessageError() == null) {
                        MessageError msgError = (MessageError)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(MessageError.class);
                        exchange.setMessageError(msgError);
                    }
                    if (exchange.getMessageError().getBody() == null) {
                        Body body = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasyESBFramework.getInstance()).getXmlObjectFactory().create(Body.class);
                        exchange.getMessageError().setBody(body);
                    }
                    exchange.getMessageError().getBody().setPayload(domDocument);
                }
                ProviderEndpoint providerEp = esbContext.getProviderEndpoint();
                log.finest("providerEp = " + providerEp);
                exchange.setStatus(StatusType.FAULT);
                providerEp.sendResponseToClient(exchange);
            }
        }
        catch (JDOMException e1) {
            throw new CoreException((Throwable)e1);
        }
        catch (TransportException e1) {
            throw new CoreException((Throwable)e1);
        }
    }
}

