/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.esb.impl.test;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImplSOAP;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.esb.impl.test.util.EchoBehaviour;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentImpl;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ClientProxyEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.ProviderEndpointImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.ClientProxyBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.BusinessServiceImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.BasicNodeInformationsType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ClientEndpointType;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyesb.ws.echo.EchoResponse;
import com.ebmwebsourcing.easyesb.ws.echo.Echo_Type;
import com.ebmwebsourcing.easyesb.ws.echo.ObjectFactory;
import com.ebmwebsourcing.easyesb.ws.echo.test.Echo_EchoSOAP_Server;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbBasicNodeInformationsType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbClientEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbEndpointType;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbSenderInitialisationType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbBpelReport;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbDeployementReport;
import easyesb.petalslink.com.data.admin._1.AddNeighBourNode;
import easyesb.petalslink.com.data.admin._1.AddNeighBourNodeResponse;
import easyesb.petalslink.com.data.admin._1.GetBusinessEndpoints;
import easyesb.petalslink.com.data.admin._1.GetBusinessEndpointsResponse;
import easyesb.petalslink.com.data.admin._1.GetNodeInformations;
import easyesb.petalslink.com.data.admin._1.GetNodeInformationsResponse;
import easyesb.petalslink.com.data.admin._1.MoveEnpointToNode;
import easyesb.petalslink.com.data.admin._1.MoveEnpointToNodeResponse;
import easyesb.petalslink.com.data.admin._1.ServiceInfoResType;
import easyesb.petalslink.com.data.admin._1.ServiceInfoType;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ESBBaseAdminTest {
    private static final String HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT = "http://localhost:8095/services/adminExternalEndpoint";
    private Logger log = Logger.getLogger(ESBBaseAdminTest.class.getName());
    private static ESBFactory factory = new ESBFactoryImpl(new String[0]);

    private Node createNode(QName name, String host, int port, final int soap_port) throws ESBException {
        Node node = factory.createNode(name, (Configuration)new ConfigurationImpl(host, port, (Map)new HashMap<String, String>(){
            {
                this.put(SoapServer.PORT_PROPERTY_NAME, String.valueOf(soap_port));
            }
        }));
        try {
            node.start();
        }
        catch (TransportException e) {
            throw new ESBException((Throwable)e);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminEndpoint_CreateComponent() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            this.createComponent();
        }
        finally {
            node.stop();
        }
    }

    private void createComponent() throws ManagementException {
        Holder componentName = new Holder((Object)new String("MyComponent"));
        AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
        client.createComponent(componentName, ComponentImpl.class.getName());
        Assert.assertEquals((Object)"MyComponent", (Object)componentName.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminEndpoint_CreateService() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            this.createService();
        }
        finally {
            node.stop();
        }
    }

    private void createService() throws ManagementException {
        Holder serviceName = new Holder((Object)new QName("http://com.ebmwebsourcing.easyesb", "MyService"));
        AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
        client.createService(null, serviceName, BusinessServiceImpl.class.getName());
        Assert.assertEquals((Object)new QName("http://com.ebmwebsourcing.easyesb", "MyService"), (Object)serviceName.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminEndpoint_CreateClientEndpoint() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            this.createComponent();
            this.createClientEndpoint();
        }
        finally {
            node.stop();
        }
    }

    private void createClientEndpoint() throws ManagementException {
        Holder endpointName = new Holder((Object)new QName("http://com.ebmwebsourcing.easyesb", "MyClientEndpoint"));
        AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
        client.createClientEndpoint(endpointName, ClientProxyEndpointImpl.class.getName(), ClientProxyBehaviourImpl.class.getName(), null);
        Assert.assertEquals((Object)new QName("http://com.ebmwebsourcing.easyesb", "MyClientEndpoint"), (Object)endpointName.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminEndpoint_CreateProviderEndpoint() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            this.createComponent();
            this.createService();
            this.createProviderEndpoint();
        }
        finally {
            node.stop();
        }
    }

    private void createProviderEndpoint() throws ManagementException {
        Holder providerEndpointName = new Holder((Object)"MyProviderEndpoint");
        AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
        client.createProviderEndpoint(new QName("http://com.ebmwebsourcing.easyesb", "MyService"), providerEndpointName, ProviderEndpointImpl.class.getName(), EchoBehaviour.class.getName(), "classpath://wsdl/echo.wsdl", null);
        Assert.assertEquals((Object)"MyProviderEndpoint", (Object)providerEndpointName.value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminEndpoint_ExposeServiceEndpointInSoap() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            this.createComponent();
            this.createService();
            this.createProviderEndpoint();
            this.exposeServiceEndpointInSoap();
        }
        finally {
            node.stop();
        }
    }

    private void exposeServiceEndpointInSoap() throws ManagementException {
        AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
        String res = client.exposeServiceEndpointInSoap(new QName("http://com.ebmwebsourcing.easyesb", "MyService"), "MyProviderEndpoint");
        Assert.assertEquals((Object)"http://localhost:8095/services/MyProviderEndpointClientProxyEndpoint", (Object)res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminEndpoint_CreateServiceEndpoint() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            this.createServiceEndpoint();
        }
        finally {
            node.stop();
        }
    }

    private void createServiceEndpoint() throws ManagementException {
        AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
        String res = client.createServiceEndpoint(null, new QName("http://com.ebmwebsourcing.easyesb", "MyService"), BusinessServiceImpl.class.getName(), "MyProviderEndpoint", ProviderEndpointImpl.class.getName(), EchoBehaviour.class.getName(), "classpath://wsdl/echo.wsdl", null);
        Assert.assertEquals((Object)"MyProviderEndpoint", (Object)res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminEndpoint_ImportSoapEndpoint() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        Echo_EchoSOAP_Server server = new Echo_EchoSOAP_Server();
        System.out.println("Server ready...");
        try {
            this.importSoapEndpoint();
        }
        finally {
            node.stop();
            server.shutdown();
        }
    }

    private void importSoapEndpoint() throws ManagementException {
        AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
        String res = client.importSoapEndpoint("http://localhost:9001/echo", "classpath://wsdl/echo.wsdl");
        Assert.assertEquals((Object)"esb://http://ws.easyesb.ebmwebsourcing.com/echo/::echo@echoSOAP?type=ProviderProxyEndpoint", (Object)res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminEndpoint_WrapSoapEndpoint() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        Echo_EchoSOAP_Server server = new Echo_EchoSOAP_Server();
        System.out.println("Server ready...");
        try {
            URL echoUrl = Thread.currentThread().getContextClassLoader().getResource("wsdl/echo.wsdl");
            long start = GregorianCalendar.getInstance().getTimeInMillis();
            this.wrapSoapEndpoint();
            long end = GregorianCalendar.getInstance().getTimeInMillis();
            long creationTime = end - start;
            start = GregorianCalendar.getInstance().getTimeInMillis();
            SOAPSender sender = new SOAPSender();
            Echo_Type echo = new Echo_Type();
            echo.setIn("Hello world!!!");
            Document response = sender.sendSoapRequest(SOAPSender.createSOAPMessageRequest((Document)SOAJAXBContext.getInstance().unmarshallAnyElement((Object)echo)), "http://localhost:8095/services/echoSOAPClientProxyEndpoint", "http://ws.easyesb.ebmwebsourcing.com/echo");
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            doc.appendChild((Element)doc.importNode(DOMUtil.getInstance().getFirstElement(SOAPHandler.getBody((Document)response)), true).cloneNode(true));
            System.out.println("payload = " + XMLPrettyPrinter.prettyPrint((Document)doc));
            EchoResponse businessReponse = (EchoResponse)SOAJAXBContext.getInstance().marshallAnyType(doc, EchoResponse.class);
            Assert.assertEquals((Object)"Hello world!!!", (Object)businessReponse.getOut());
            end = GregorianCalendar.getInstance().getTimeInMillis();
            long invocationTime = end - start;
            System.out.println("TIME of creation: " + creationTime);
            System.out.println("TIME of Invocation: " + invocationTime);
        }
        finally {
            node.stop();
            server.shutdown();
        }
    }

    private void wrapSoapEndpoint() throws ManagementException {
        String soapAddress = "http://localhost:9001/echo";
        AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
        String consumerSoapAddress = client.wrapSoapEndpoint(soapAddress, Thread.currentThread().getContextClassLoader().getResource("wsdl/echo.wsdl").toExternalForm(), null);
        Assert.assertEquals((Object)"http://localhost:8095/services/echoSOAPClientProxyEndpoint", (Object)consumerSoapAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminEndpoint_DeployBpel() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
            File f = new File("./src/test/resources/bpel/travelagency/process.bpel");
            this.log.finest("f exists? " + f.exists());
            this.log.finest("f url: " + f.toURI().toURL());
            EJaxbDeployementReport businessReponse = client.deploy(new File("./src/test/resources/bpel/travelagency/process.bpel").toURI().toURL());
            Assert.assertNotNull((Object)businessReponse.getAny());
            EJaxbBpelReport report = (EJaxbBpelReport)businessReponse.getAny();
            Assert.assertEquals((long)1L, (long)report.getExternalEndpointsAddressesCreated().size());
            Assert.assertEquals((Object)"http://localhost:8095/services/travelAgencyServiceEndpoint_proxy", report.getExternalEndpointsAddressesCreated().get(0));
        }
        finally {
            node.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminEndpoint_GetNodeInformationsOnFactorialBpel() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
            EJaxbDeployementReport businessReponse = client.deploy(Thread.currentThread().getContextClassLoader().getResource("bpel/factorial/factorial.bpel"));
            Assert.assertNotNull((Object)businessReponse.getAny());
            EJaxbBpelReport report = (EJaxbBpelReport)businessReponse.getAny();
            Assert.assertEquals((long)1L, (long)report.getExternalEndpointsAddressesCreated().size());
            Assert.assertEquals((Object)"http://localhost:8095/services/factorialPort_proxy", report.getExternalEndpointsAddressesCreated().get(0));
            GetNodeInformationsResponse res = client.getNodeInformations(new GetNodeInformations());
            Assert.assertNotNull((Object)res);
            Assert.assertNotNull((Object)res.getNode());
            Assert.assertEquals((Object)"node0", (Object)res.getNode().getName());
            Assert.assertNotNull((Object)res.getNode().getRegistry());
            Assert.assertNotNull((Object)res.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup());
            Assert.assertEquals((long)11L, (long)res.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup().size());
        }
        finally {
            node.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminManagement_getServiceInfo() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
            Echo_EchoSOAP_Server server = new Echo_EchoSOAP_Server();
            String rr = client.importSoapEndpoint("http://localhost:9001/echo", "http://localhost:9001/echo?wsdl");
            ServiceInfoType serviceInfo = new ServiceInfoType();
            serviceInfo.setServInfoDM(rr);
            ServiceInfoResType res = client.getServiceInformation(serviceInfo);
            System.out.println(((EJaxbSenderInitialisationType)res.getProviderProxyEndpoint().getSenderInitialisation().get(0)).getExternalProviderAddress());
            Assert.assertEquals((Object)"http://localhost:9001/echo", (Object)((EJaxbSenderInitialisationType)res.getProviderProxyEndpoint().getSenderInitialisation().get(0)).getExternalProviderAddress());
        }
        finally {
            node.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminEndpoint_GetNodeInformationsOnTravelAgencyBpel() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node1"), "localhost", 9010, 8095);
        try {
            AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
            EJaxbDeployementReport businessReponse = client.deploy(Thread.currentThread().getContextClassLoader().getResource("bpel/travelagency/process.bpel"));
            Assert.assertNotNull((Object)businessReponse.getAny());
            EJaxbBpelReport report = (EJaxbBpelReport)businessReponse.getAny();
            Assert.assertEquals((long)1L, (long)report.getExternalEndpointsAddressesCreated().size());
            Assert.assertEquals((Object)"http://localhost:8095/services/travelAgencyServiceEndpoint_proxy", report.getExternalEndpointsAddressesCreated().get(0));
            GetNodeInformationsResponse res = client.getNodeInformations(new GetNodeInformations());
            Assert.assertNotNull((Object)res);
            Assert.assertNotNull((Object)res.getNode());
            Assert.assertEquals((String)"http://com.ebmwebsourcing.easyesb", (Object)"node1", (Object)res.getNode().getName());
            Assert.assertNotNull((Object)res.getNode().getRegistry());
            Assert.assertNotNull((Object)res.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup());
            Assert.assertEquals((long)15L, (long)res.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup().size());
        }
        finally {
            node.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminEndpoint_AdminFault() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            this.adminFault();
            Assert.fail();
        }
        catch (ManagementException managementException) {
        }
        finally {
            node.stop();
        }
    }

    private void adminFault() throws ManagementException, MalformedURLException {
        AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
        client.deploy(URI.create("file:///wrong.bpel").toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminEndpoint_AddNeighbourNode() throws Exception {
        AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        Node node1 = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node1"), "localhost", 9011, 8086);
        try {
            AddNeighBourNode payload = new AddNeighBourNode();
            payload.setNeighbourNode((EJaxbBasicNodeInformationsType)node1.getModel().getBasicNodeInformations().getModelObject());
            AddNeighBourNodeResponse businessReponse = client.addNeighBourNode(payload);
            Assert.assertTrue((boolean)businessReponse.isOut());
            GetNodeInformationsResponse res = client.getNodeInformations(new GetNodeInformations());
            Assert.assertNotNull((Object)res);
            Assert.assertNotNull((Object)res.getNode());
            Assert.assertEquals((Object)"node0", (Object)res.getNode().getName());
            Assert.assertNotNull((Object)res.getNode().getRegistry());
            Assert.assertNotNull((Object)res.getNode().getRegistry().getNeighbourNode());
            Assert.assertEquals((long)1L, (long)res.getNode().getRegistry().getNeighbourNode().size());
            Assert.assertNotNull((Object)res.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup());
            Assert.assertEquals((long)8L, (long)res.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup().size());
        }
        finally {
            node.stop();
            node1.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminEndpoint_MoveEndpointToNode() throws Exception {
        AdminClientImplSOAP client = null;
        Node node1 = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node1"), "localhost", 9011, 8181);
        Node node2 = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node2"), "localhost", 9012, 8182);
        try {
            client = new AdminClientImplSOAP("http://localhost:8181/services/adminExternalEndpoint");
            URL bpelUrl = Thread.currentThread().getContextClassLoader().getResource("bpel/travelagency/process.bpel");
            EJaxbDeployementReport businessReponse = client.deploy(bpelUrl);
            Assert.assertNotNull((Object)businessReponse.getAny());
            EJaxbBpelReport report = (EJaxbBpelReport)businessReponse.getAny();
            Assert.assertEquals((long)1L, (long)report.getExternalEndpointsAddressesCreated().size());
            Assert.assertEquals((Object)"http://localhost:8181/services/travelAgencyServiceEndpoint_proxy", report.getExternalEndpointsAddressesCreated().get(0));
            GetNodeInformationsResponse resOnNode1 = client.getNodeInformations(new GetNodeInformations());
            Assert.assertNotNull((Object)resOnNode1);
            Assert.assertNotNull((Object)resOnNode1.getNode());
            Assert.assertEquals((Object)"node1", (Object)resOnNode1.getNode().getName());
            Assert.assertNotNull((Object)resOnNode1.getNode().getRegistry());
            Assert.assertNotNull((Object)resOnNode1.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup());
            Assert.assertEquals((long)15L, (long)resOnNode1.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup().size());
            for (EJaxbClientEndpointType ep : resOnNode1.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup()) {
                if (!(ep instanceof ProviderEndpointType) && !(ep instanceof ClientEndpointType) || ep.getReference().contains("adminEndpoint_node1") || ep.getReference().contains("adminExternalEndpoint") || ep.getReference().contains("travelAgencyServiceEndpoint")) continue;
                System.out.println("Endpoint to move: " + ep.getReference());
                System.out.println("Node on move: " + node2.getModel().getBasicNodeInformations().getNodeName());
                System.out.println("avant resOnNode1.getNode().getRegistry().getLocalEndpoint().size() = " + resOnNode1.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup().size());
                MoveEnpointToNodeResponse moveResponse = this.moveToNode((EJaxbEndpointType)ep, (BasicNodeInformationsType)node2.getModel().getBasicNodeInformations().getModelObject(), true);
                System.out.println("apres resOnNode1.getNode().getRegistry().getLocalEndpoint().size() = " + resOnNode1.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup().size());
            }
            resOnNode1 = client.getNodeInformations(new GetNodeInformations());
            Assert.assertNotNull((Object)resOnNode1);
            Assert.assertNotNull((Object)resOnNode1.getNode());
            Assert.assertNotNull((Object)resOnNode1.getNode().getRegistry());
            Assert.assertNotNull((Object)resOnNode1.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup());
            Assert.assertEquals((long)15L, (long)resOnNode1.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup().size());
            client = new AdminClientImplSOAP("http://localhost:8182/services/adminExternalEndpoint");
            GetNodeInformationsResponse resOnNode2 = client.getNodeInformations(new GetNodeInformations());
            Assert.assertNotNull((Object)resOnNode2);
            Assert.assertNotNull((Object)resOnNode2.getNode());
            Assert.assertNotNull((Object)resOnNode2.getNode().getRegistry());
            Assert.assertNotNull((Object)resOnNode2.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup());
            Assert.assertEquals((long)8L, (long)resOnNode2.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup().size());
        }
        finally {
            node1.stop();
            node2.stop();
        }
    }

    private MoveEnpointToNodeResponse moveToNode(EJaxbEndpointType ep, BasicNodeInformationsType basicNodeInformations, boolean b) throws ManagementException {
        AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
        MoveEnpointToNode payload = new MoveEnpointToNode();
        payload.setEndpointReference(ep.getReference());
        payload.setBasicNodeInformations((EJaxbBasicNodeInformationsType)basicNodeInformations.getModelObject());
        payload.setAddConnectionIfNotExist(b);
        return client.moveEnpointToNode(payload);
    }

    @Test
    public void testAdminEndpoint_Stop() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
        try {
            client.stop();
            node.stop();
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore(value="This test does'nt work in shell command")
    public void testAdminEndpoint_GetBusinessEndpoints() throws Exception {
        Node node = this.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node0"), "localhost", 9010, 8095);
        try {
            AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
            EJaxbDeployementReport businessReponse = client.deploy(Thread.currentThread().getContextClassLoader().getResource("bpel/travelagency/process.bpel"));
            Assert.assertNotNull((Object)businessReponse.getAny());
            EJaxbBpelReport report = (EJaxbBpelReport)businessReponse.getAny();
            Assert.assertEquals((long)1L, (long)report.getExternalEndpointsAddressesCreated().size());
            Assert.assertEquals((Object)"http://localhost:8095/services/travelAgencyServiceEndpoint_proxy", report.getExternalEndpointsAddressesCreated().get(0));
            GetBusinessEndpointsResponse getBusinessEndpointsResponse = this.getBusinessEndpoints();
            Assert.assertEquals((long)3L, (long)getBusinessEndpointsResponse.getEndpointInformation().size());
        }
        finally {
            node.stop();
        }
    }

    private GetBusinessEndpointsResponse getBusinessEndpoints() throws Exception {
        AdminClientImplSOAP client = new AdminClientImplSOAP(HTTP_LOCALHOST_8095_SERVICES_ADMIN_EXTERNAL_ENDPOINT);
        return client.getBusinessEndpoints(new GetBusinessEndpoints());
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (IOException ex) {
            System.err.println("WARNING: Could not open configuration file");
            System.err.println("WARNING: Logging not configured (console output only)");
        }
        catch (SOAException e) {
            e.printStackTrace();
        }
    }
}

