/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.esb.impl.test;

import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.admin.client.impl.AdminClientImplSOAP;
import com.ebmwebsourcing.easyesb.cdk.ESBHelper;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.esb.impl.test.util.EchoBehaviour;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.impl.config.ConfigurationImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.NodeType;
import com.ebmwebsourcing.easyesb.ws.echo.ObjectFactory;
import easybox.easyesb.petalslink.com.soa.model.datatype._1.EJaxbClientEndpointType;
import easyesb.petalslink.com.data.admin._1.GetNodeInformations;
import easyesb.petalslink.com.data.admin._1.GetNodeInformationsResponse;
import esstar.petalslink.com.service.management._1_0.ManagementException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;

public class ESBConfigTest {
    private Logger log = Logger.getLogger(ESBConfigTest.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfigFromFile() throws Exception {
        ESBFactoryImpl factory = new ESBFactoryImpl(new String[0]);
        Node node1 = null;
        Node node2 = null;
        try {
            ConfigurationImpl.setCONFIG((String)(new File(".") + "/src/test/resources/config/config1.properties"));
            node1 = factory.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node1"), (Configuration)new ConfigurationImpl());
            Assert.assertEquals((Object)"9005", (Object)node1.getModel().getBasicNodeInformations().getPort());
            ConfigurationImpl.setCONFIG((String)(new File(".") + "/src/test/resources/config/config2.properties"));
            node2 = factory.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node2"), (Configuration)new ConfigurationImpl());
            Assert.assertEquals((Object)"9006", (Object)node2.getModel().getBasicNodeInformations().getPort());
            AdminClientImplSOAP client1 = new AdminClientImplSOAP("http://localhost:8095/services/adminExternalEndpoint");
            GetNodeInformationsResponse res8095 = client1.getNodeInformations(new GetNodeInformations());
            AdminClientImplSOAP client2 = new AdminClientImplSOAP("http://localhost:8086/services/adminExternalEndpoint");
            GetNodeInformationsResponse res8086 = client2.getNodeInformations(new GetNodeInformations());
            Assert.assertNotNull((Object)res8095);
            Assert.assertNotNull((Object)res8095.getNode());
            Assert.assertNotNull((Object)res8095.getNode().getBasicNodeInformations());
            Assert.assertEquals((Object)"9005", (Object)res8095.getNode().getBasicNodeInformations().getPort());
            Assert.assertEquals((Object)"node1", (Object)res8095.getNode().getName());
            Assert.assertNotNull((Object)res8095.getNode().getRegistry());
            Assert.assertNotNull((Object)res8095.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup());
            for (EJaxbClientEndpointType ep : res8095.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup()) {
                this.log.finest("GGGGGGGGGGGGGGGGGGGG client ep name = " + ep.getName());
            }
            Assert.assertEquals((long)8L, (long)res8095.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup().size());
            Assert.assertNotNull((Object)res8086);
            Assert.assertNotNull((Object)res8086.getNode());
            Assert.assertNotNull((Object)res8086.getNode().getBasicNodeInformations());
            Assert.assertEquals((Object)"9006", (Object)res8086.getNode().getBasicNodeInformations().getPort());
            Assert.assertEquals((Object)"node2", (Object)res8086.getNode().getName());
            Assert.assertNotNull((Object)res8086.getNode().getRegistry());
            Assert.assertNotNull((Object)res8086.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup());
            Assert.assertEquals((long)8L, (long)res8086.getNode().getRegistry().getLocalEndpointsGroupList().getEndpointGroup().size());
        }
        finally {
            if (node1 != null) {
                node1.stop();
            }
            if (node2 != null) {
                node2.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfigFromJava() throws Exception {
        ESBFactoryImpl factory = new ESBFactoryImpl(new String[0]);
        Node node1 = null;
        Node node2 = null;
        try {
            node1 = factory.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node1"), (Configuration)new ConfigurationImpl("localhost", 9005, (Map)new HashMap<String, String>(){
                {
                    this.put(SoapServer.PORT_PROPERTY_NAME, "8095");
                }
            }));
            Assert.assertEquals((Object)"9005", (Object)node1.getModel().getBasicNodeInformations().getPort());
            node2 = factory.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node2"), (Configuration)new ConfigurationImpl("localhost", 9006, (Map)new HashMap<String, String>(){
                {
                    this.put(SoapServer.PORT_PROPERTY_NAME, "8086");
                }
            }));
            Assert.assertEquals((Object)"9006", (Object)node2.getModel().getBasicNodeInformations().getPort());
            AdminClientImplSOAP client1 = new AdminClientImplSOAP("http://localhost:8095/services/adminExternalEndpoint");
            GetNodeInformationsResponse res8095 = client1.getNodeInformations(new GetNodeInformations());
            AdminClientImplSOAP client2 = new AdminClientImplSOAP("http://localhost:8086/services/adminExternalEndpoint");
            GetNodeInformationsResponse res8086 = client2.getNodeInformations(new GetNodeInformations());
        }
        finally {
            if (node1 != null) {
                node1.stop();
            }
            if (node2 != null) {
                node2.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShortExample() throws Exception {
        ESBFactoryImpl factory = new ESBFactoryImpl(new String[0]);
        Node node1 = null;
        try {
            node1 = factory.createNode(new QName("http://com.ebmwebsourcing.easyesb", "node1"), (Configuration)new ConfigurationImpl("localhost", 9005, (Map)new HashMap<String, String>(){
                {
                    this.put(SoapServer.PORT_PROPERTY_NAME, "8095");
                }
            }));
            Assert.assertEquals((Object)"9005", (Object)node1.getModel().getBasicNodeInformations().getPort());
            ESBConfigTest.example((Node<? extends NodeType>)node1);
        }
        finally {
            if (node1 != null) {
                node1.stop();
            }
        }
    }

    public static void example(Node<? extends NodeType> node) throws ManagementException {
        try {
            URI providerEndpointReference = ESBHelper.createProviderEndpoint(node, (QName)new QName("http://org.easyesb", "myFirstService"), (String)"myFirstFirstProviderEndpoint", EchoBehaviour.class);
            ClientEndpoint clientEndpoint = ESBHelper.createClientEndpoint(node, (QName)new QName("http://org.easyesb", "myFirstClientEndpoint"));
            Exchange exchange = clientEndpoint.createExchange();
            exchange.setOperation("echo");
            exchange.setDestinationReference(providerEndpointReference);
            exchange.getMessageIn().getBody().setPayload(DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream("<text>Hello World!!!!</text>".getBytes())));
            clientEndpoint.sendSync(exchange, 0L);
            System.out.println("Response: " + XMLPrettyPrinter.prettyPrint((Document)exchange.getMessageOut().getBody().getPayload()));
        }
        catch (Exception e) {
            throw new ManagementException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        try {
            InputStream configFile = Thread.currentThread().getContextClassLoader().getResourceAsStream("easycommons-logging.properties");
            LogManager.getLogManager().readConfiguration(configFile);
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
        }
        catch (IOException ex) {
            System.err.println("WARNING: Could not open configuration file");
            System.err.println("WARNING: Logging not configured (console output only)");
        }
        catch (SOAException e) {
            System.err.println("WARNING: Could not open configuration file");
            System.err.println("WARNING: Logging not configured (console output only)");
        }
    }
}

