/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.rawreport.interceptor.report;

import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.rawreport.interceptor.report.AbstractReportInterceptor;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.interceptors.ClientEndpointInvocationInterceptor;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import java.util.logging.Logger;

public class ClientReportInterceptor
extends AbstractReportInterceptor
implements ClientEndpointInvocationInterceptor {
    private static Logger log = Logger.getLogger(ClientReportInterceptor.class.getName());
    private Configuration conf;

    public ClientReportInterceptor(Configuration conf, Endpoint endpoint) throws ESBException {
        super(endpoint);
        this.conf = conf;
    }

    public void processingExchangeAfterReceiving(Exchange exchange) throws TransportException {
        log.finest("t4: report interception to be sent for exchange " + exchange.getUuid());
        if (exchange != null) {
            log.finest("t4: report exchange not null");
            ReportList reports = this.createReportListFromExchangeT3T4(exchange);
            log.finest("t4: reports created ");
            if (reports.getReports().length > 0) {
                log.finest("t4: reports sent ...");
                try {
                    this.sendReport((XmlObject)reports, AbstractReportInterceptor.RAWREPORT_TOPIC);
                }
                catch (ESBException e) {
                    e.printStackTrace();
                }
            }
        } else {
            log.severe("ERROR: TIMEOUT => Impossible to create report");
        }
    }

    public void processingExchangeBeforeSending(Exchange exchange) throws TransportException {
    }
}

