/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.cli.impl.command;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPSender;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.esstar.management.UserManagementClientSOAP;
import java.io.ByteArrayInputStream;
import java.util.List;
import org.w3c.dom.Document;

public class SendSoapRequestCommand
extends AbstractCommand<UserManagementClientSOAP> {
    private String soapAction;
    private String request;
    private SOAPSender sender = new SOAPSender();

    public SendSoapRequestCommand(UserManagementClientSOAP client) throws ESBException {
        super(client);
        this.setName("SendSoapRequest");
        this.setDescription("Send Soap Request");
        this.setShortcut("ss");
    }

    @Override
    public void execute() {
        try {
            Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().parse(new ByteArrayInputStream(this.request.getBytes()));
            System.out.println("Soap request sent to: " + ((UserManagementClientSOAP)this.getClient()).getAddress());
            System.out.println("Soap request to send:\n" + XMLPrettyPrinter.prettyPrint((Document)doc));
            Document res = this.sender.sendSoapRequest(doc, ((UserManagementClientSOAP)this.getClient()).getAddress(), this.soapAction);
            System.out.println("-------------- res = " + res);
            if (res != null) {
                this.setResult(XMLPrettyPrinter.prettyPrint((Document)res));
            }
            this.resultCode = 1;
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.setResult(e.getLocalizedMessage());
            this.resultCode = -1;
        }
    }

    @Override
    protected int doProcess(List<String> args) {
        this.request = args.get(0);
        this.soapAction = args.get(1);
        this.execute();
        return this.resultCode;
    }

    @Override
    protected boolean validateArgs(List<String> args) {
        return args.size() == 2;
    }

    public String toString() {
        return "ss <request> <soapAction> \t\t\t\t\t{Send Soap Request}";
    }
}

