/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyschema10.api;

import com.ebmwebsourcing.easybox.api.ModelObjectFinder;
import com.ebmwebsourcing.easybox.api.ModelObjectIdBasedFinder;
import com.ebmwebsourcing.easybox.api.ObjectUnderTestFactory;
import com.ebmwebsourcing.easybox.api.TestData;
import com.ebmwebsourcing.easybox.api.TestXmlContext;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectUnderTestFactory;
import java.util.Iterator;
import java.util.ServiceLoader;

public abstract class AbstractXmlObjectTest
extends com.ebmwebsourcing.easybox.api.AbstractXmlObjectTest {
    private static final ModelObjectFinder MODEL_OBJECT_FINDER;

    public AbstractXmlObjectTest(String label, ObjectUnderTestFactory objectUnderTestFactory, TestData testData) {
        super(label, objectUnderTestFactory, testData);
    }

    protected static XmlObjectUnderTestFactory newXmlObjectUnderTestFactory(String testResourcePath, String searchCriterion, Class<? extends XmlObject> xmlObjectClass) {
        return new XmlObjectUnderTestFactory(TestXmlContext.DEFAULT_XML_CONTEXT, MODEL_OBJECT_FINDER, testResourcePath, searchCriterion, xmlObjectClass);
    }

    private static void initializeExpectedXmlObjects() {
        for (String id : new String[]{"schema0", "import0", "include0", "annotation0", "attribute0", "attribute1", "simpleType0", "restriction0", "minInclusive0", "maxInclusive0", "fractionDigits0", "totalDigits0", "pattern0", "enumeration0", "complexType0", "attribute2", "attributeGroup0", "attribute3", "attribute4", "attributeGroup1", "attributeGroup2", "attribute5", "element0", "element1", "simpleType1", "list0", "simpleType2", "restriction1", "minLength0", "maxLength0", "simpleType3", "restriction3", "length0", "group0", "all0", "element8", "element9", "complexType1", "sequence0", "element2", "element3", "attribute6", "attribute7", "attributeGroup3", "complexType2", "all1", "element4", "element5", "complexType3", "choice0", "element6", "element7", "element11", "complexType4", "group1", "complexType5", "complexContent0", "extension0", "anyAttribute0", "complexType6", "simpleContent0", "extension1", "attribute8", "element10", "complexType7", "complexContent1", "restriction2", "sequence1", "element12", "element13"}) {
            AbstractXmlObjectTest.addExpectedObject((String)"/schema4test.xsd", (String)id, (Object)AbstractXmlObjectTest.newExpectedXmlObject("/schema4test.xsd", id));
        }
        for (String id : new String[]{"schema0", "import0", "include0/", "annotation0", "attribute0", "attribute1", "simpleType0", "restriction0", "minInclusive0", "maxInclusive0", "fractionDigits0", "totalDigits0", "pattern0", "enumeration0", "complexType0", "attribute2", "attributeGroup0", "attribute3", "attribute4", "attributeGroup1", "attributeGroup2", "attribute5", "element0", "element1", "simpleType1", "list0", "simpleType2", "restriction1", "minLength0", "maxLength0", "simpleType3", "restriction3", "length0", "group0", "all0", "element8", "element9", "complexType1", "sequence0", "element2", "element3", "attribute6", "attribute7", "attributeGroup3", "complexType2", "all1", "element4", "element5", "complexType3", "choice0", "element6", "element7", "element11", "complexType4", "group1", "complexType5", "complexContent0", "extension0", "anyAttribute0", "complexType6", "simpleContent0", "extension1", "attribute8", "element10", "complexType7", "complexContent1", "restriction2", "sequence1", "element12", "element13"}) {
            AbstractXmlObjectTest.addExpectedObject((String)"/schema4test-invalid.xsd", (String)id, (Object)AbstractXmlObjectTest.newExpectedXmlObject("/schema4test-invalid.xsd", id));
        }
        for (String id : new String[]{"schema1"}) {
            AbstractXmlObjectTest.addExpectedObject((String)"/schema4test-import.xsd", (String)id, (Object)AbstractXmlObjectTest.newExpectedXmlObject("/schema4test-import.xsd", id));
        }
        for (String id : new String[]{"schema2"}) {
            AbstractXmlObjectTest.addExpectedObject((String)"/schema4test-include.xsd", (String)id, (Object)AbstractXmlObjectTest.newExpectedXmlObject("/schema4test-include.xsd", id));
        }
        for (String id : new String[]{"schema3", "import0"}) {
            AbstractXmlObjectTest.addExpectedObject((String)"/schema4test-circularimport0.xsd", (String)id, (Object)AbstractXmlObjectTest.newExpectedXmlObject("/schema4test-circularimport0.xsd", id));
        }
        for (String id : new String[]{"schema4", "import1"}) {
            AbstractXmlObjectTest.addExpectedObject((String)"/schema4test-circularimport1.xsd", (String)id, (Object)AbstractXmlObjectTest.newExpectedXmlObject("/schema4test-circularimport1.xsd", id));
        }
    }

    private static final XmlObjectNode newExpectedXmlObject(String anyTestResourcePath, String anyXmlObjectSearchCriterion) {
        return TestXmlContext.DEFAULT_XML_CONTEXT.getXmlObjectFactory().wrap(MODEL_OBJECT_FINDER.find(anyTestResourcePath, anyXmlObjectSearchCriterion));
    }

    static {
        ServiceLoader<ModelObjectIdBasedFinder> sl = ServiceLoader.load(ModelObjectIdBasedFinder.class);
        Iterator<ModelObjectIdBasedFinder> it = sl.iterator();
        assert (it.hasNext()) : "No ModelObjectIdBasedFinder implementation found in classpath.";
        MODEL_OBJECT_FINDER = (ModelObjectFinder)it.next();
        MODEL_OBJECT_FINDER.setXmlContext(TestXmlContext.DEFAULT_XML_CONTEXT);
        AbstractXmlObjectTest.initializeExpectedXmlObjects();
    }
}

