/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.test.behaviour;

import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.Process;
import com.ebmwebsourcing.easyviper.core.api.engine.Scope;
import com.ebmwebsourcing.easyviper.core.api.engine.configuration.ConfigurationEngine;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.Expression;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.LongExpression;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.EmptyBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal.WaitBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.impl.engine.configuration.ConfigurationEngineImpl;
import com.ebmwebsourcing.easyviper.core.impl.test.util.GenericFactory;
import com.ebmwebsourcing.easyviper.tools.MemoryReceiverImpl;
import com.ebmwebsourcing.easyviper.tools.SysoutSenderImpl;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.objectweb.fractal.api.NoSuchInterfaceException;

public class WaitBehaviourTest {
    @Test
    @Ignore(value="Unpredictible test: the result of this test change following the memory OS capacity")
    public void testWait() throws CoreException, NoSuchInterfaceException, InterruptedException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("waitProcess"), null);
        HashMap<String, LongExpressionImpl> context = new HashMap<String, LongExpressionImpl>();
        context.put("date", new LongExpressionImpl(new Long(5000L)));
        Node initial = process.createNode("wait", WaitBehaviourImpl.class, context);
        process.setInitialNode(initial);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        long begin = System.currentTimeMillis();
        process.run();
        long end = System.currentTimeMillis();
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
        long time = end - begin;
        System.out.println("time = " + time);
        Assert.assertTrue((time > 5000L ? 1 : 0) != 0);
    }

    @Test
    public void testWaitAndTransition() throws CoreException, NoSuchInterfaceException, InterruptedException {
        boolean explorer = false;
        Core core = GenericFactory.getInstance().createCore((ConfigurationEngine)new ConfigurationEngineImpl(), 0, MemoryReceiverImpl.class, 0, SysoutSenderImpl.class, null);
        Process process = core.getEngine().createNewEmptyProcessInstance(new QName("waitProcess"), null);
        HashMap<String, LongExpressionImpl> context = new HashMap<String, LongExpressionImpl>();
        context.put("time", new LongExpressionImpl(new Long(5000L)));
        Node initial = process.createNode("wait", WaitBehaviourImpl.class, context);
        process.setInitialNode(initial);
        Node finalNode = process.createNode("empty", EmptyBehaviourImpl.class, null);
        process.linkedBrotherNodes(initial, finalNode);
        System.out.println("/////////////////////// DEMARRAGE DE L'EXECUTION: ");
        long start = System.currentTimeMillis();
        process.run();
        while (process.getState() != Process.State.PROCESS_ENDED) {
            Thread.sleep(200L);
        }
        Assert.assertTrue((System.currentTimeMillis() - start > 5000L ? 1 : 0) != 0);
        Assert.assertEquals((Object)finalNode, (Object)process.getParentExecution().getCurrentTarget());
        Assert.assertEquals((Object)Execution.State.ENDED, (Object)process.getParentExecution().getState());
    }

    public class LongExpressionImpl
    implements LongExpression<String> {
        private Long l = null;

        public LongExpressionImpl(Long l) {
            this.l = l;
        }

        public void setLog(Logger logger) {
        }

        public Long evaluate(Scope scope) throws CoreException {
            return this.l;
        }

        public String getContent() {
            return null;
        }

        public void setContent(String content) {
        }

        public Expression<String, Long> copypaste() {
            return null;
        }
    }
}

