/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.LoopBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.expression.ConditionalExpression;
import java.util.List;
import java.util.logging.Logger;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;

@Scope(value="COMPOSITE")
@Service(value={LoopBehaviour.class}, names={"service"})
public class LoopBehaviourImpl
extends AbstractBehaviourImpl
implements LoopBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(LoopBehaviourImpl.class.getName());
    @Property(name="condition", required=true)
    private ConditionalExpression condition;
    @Property(name="applyConditionAtBegin", required=true)
    private boolean applyConditionAtBegin = true;

    private void whileExecution() throws CoreException {
        Boolean cond = (Boolean)this.condition.evaluate(this.getNode().getExecution().getParentScope());
        if (cond != null && cond.booleanValue()) {
            List childs = this.node.getChildNodes();
            if (childs != null && childs.size() > 0) {
                this.getNode().getExecution().setNextExecutableElements((SCAComponent)this, (Node)childs.get(0));
            }
        } else {
            this.log.finest("end while behaviour on node: " + this.node.getName());
            this.state = Behaviour.State.ACTIVITY_ENDED;
        }
    }

    private void repeatUntilExecution(boolean first) throws CoreException {
        List childs;
        Boolean cond;
        boolean ok = true;
        if (!(first || (cond = (Boolean)this.condition.evaluate(this.getNode().getExecution().getParentScope())) != null && cond.booleanValue())) {
            this.log.finest("end repeat until behaviour on node: " + this.node.getName());
            this.state = Behaviour.State.ACTIVITY_ENDED;
            ok = false;
        }
        if (ok && (childs = this.node.getChildNodes()) != null && childs.size() > 0) {
            this.getNode().getExecution().setNextExecutableElements((SCAComponent)this, (Node)childs.get(0));
        }
    }

    public String toString() {
        return "Sequence";
    }

    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    protected void executeOnEnded() throws CoreException {
    }

    protected void executeOnInactive() throws CoreException {
        this.state = Behaviour.State.ACTIVITY_STARTED;
        if (this.applyConditionAtBegin) {
            this.log.finest("start while behaviour on node: " + this.node.getName());
            this.whileExecution();
        } else {
            this.log.finest("start repeat until behaviour on node: " + this.node.getName());
            this.repeatUntilExecution(true);
        }
    }

    protected void executeOnStarted() throws CoreException {
        if (this.applyConditionAtBegin) {
            this.whileExecution();
        } else {
            this.repeatUntilExecution(false);
        }
    }
}

