/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyviper.core.impl.engine.behaviour.functionnal;

import com.ebmwebsourcing.easycommons.sca.helper.api.SCAComponent;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Execution;
import com.ebmwebsourcing.easyviper.core.api.engine.Node;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.AbstractBehaviourImpl;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.Behaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.behaviour.functionnal.ReceiverBehaviour;
import com.ebmwebsourcing.easyviper.core.api.engine.variable.Variable;
import com.ebmwebsourcing.easyviper.core.api.env.ExternalContext;
import com.ebmwebsourcing.easyviper.core.api.soa.Endpoint;
import com.ebmwebsourcing.easyviper.core.api.soa.correlation.CorrelationMatcher;
import com.ebmwebsourcing.easyviper.core.api.soa.message.InternalMessage;
import com.ebmwebsourcing.easyviper.core.api.soa.message.MessageMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.osoa.sca.annotations.Property;

@Scope(value="COMPOSITE")
@Service(value={ReceiverBehaviour.class}, names={"service"})
public class ReceiverBehaviourImpl
extends AbstractBehaviourImpl
implements ReceiverBehaviour {
    private static final long serialVersionUID = 1L;
    private Logger log = Logger.getLogger(ReceiverBehaviourImpl.class.getName());
    private InternalMessage<?> message;
    @Property(name="variableNames", required=true)
    private List<QName> variableNames = new ArrayList<QName>();
    @Property(name="messageMatcher", required=true)
    private MessageMatcher messageMatcher = null;
    @Property(name="correlationsMatcher", required=true)
    private List<CorrelationMatcher> correlationsMatcher = new ArrayList<CorrelationMatcher>();
    @Property(name="providerEndpointKey", required=false)
    private Object providerEndpointKey;
    private Node childNodeSelected = null;
    private boolean isSuspended = false;

    public String toString() {
        return "Receive Behaviour";
    }

    public boolean accept(InternalMessage<?> message, ExternalContext context) throws CoreException {
        boolean accept = false;
        this.log.finest("Message received on node: " + this.node.getName());
        com.ebmwebsourcing.easyviper.core.api.engine.Scope scope = this.node.getExecution().getParentScope();
        int cptChild = 0;
        for (QName variableName : this.variableNames) {
            Variable v = scope.findVariable(variableName);
            if (v == null) {
                throw new CoreException("Impossible to find in process, the variable used in the received : " + this.getName());
            }
            boolean check = false;
            if (this.messageMatcher != null) {
                check = this.messageMatcher.match(v, message);
            } else {
                this.log.warning("no matcher found");
                check = true;
            }
            if (!check) {
                this.log.finest("message not valid for variable: " + variableName);
            } else {
                boolean correlationOK = false;
                if (this.correlationsMatcher != null && this.correlationsMatcher.size() > 0) {
                    this.log.finest("Correlation found: execute correlation for receiver: " + this.getName());
                    for (CorrelationMatcher corr : this.correlationsMatcher) {
                        correlationOK = corr.match(scope, variableName, message);
                        if (!correlationOK) {
                            continue;
                        }
                        break;
                    }
                } else {
                    this.log.finest("No correlation ");
                    correlationOK = true;
                }
                if (check && correlationOK) {
                    v.setValue(message);
                    accept = true;
                    this.log.finest("Message accepted on receive by variable: " + variableName);
                    if (this.node.getChildNodes().size() <= 0) break;
                    this.childNodeSelected = (Node)this.node.getChildNodes().get(cptChild);
                    break;
                }
            }
            ++cptChild;
        }
        return accept;
    }

    public void setMessage(InternalMessage<?> message) {
        this.message = message;
    }

    public InternalMessage<?> getMessage() {
        return this.message;
    }

    public void setLog(Logger logger) {
        super.setLog(logger);
        this.log = logger;
    }

    public Node getChildNodeSelected() {
        return this.childNodeSelected;
    }

    private final void executeOnSuspended() throws CoreException {
        this.isSuspended = false;
        this.log.finest("execute receive behaviour on node: " + this.node.getName());
        this.state = Behaviour.State.ACTIVITY_STARTED;
        if (this.message != null) {
            Endpoint endpoint = this.getNode().getExecution().getParentScope().findEndpoint(this.providerEndpointKey);
            ExternalContext context = this.getNode().getExecution().getParentScope().getProcess().getExternalContext(endpoint, this.message.getOperationName());
            boolean accept = this.accept(this.message, context);
            if (accept) {
                this.log.finest("Message accepted by the receive activity: " + this.getName());
                if (this.getChildNodeSelected() != null) {
                    this.getNode().getExecution().setNextExecutableElements((SCAComponent)this, this.getChildNodeSelected());
                }
                this.state = Behaviour.State.ACTIVITY_ENDED;
                this.notifyParentBehaviour();
            } else {
                this.getNode().getExecution().setStateRecursively(Execution.State.SUSPENDED);
                this.isSuspended = true;
                this.log.finest("Message does not correspond - execution suspended: " + this.getNode().getExecution().getState());
            }
            this.message = null;
        } else {
            this.getNode().getExecution().setStateRecursively(Execution.State.SUSPENDED);
            this.isSuspended = true;
            this.log.finest("No Message - execution suspended: " + this.getNode().getExecution().getState());
        }
    }

    protected void executeOnEnded() throws CoreException {
    }

    protected void executeOnInactive() throws CoreException {
        this.executeOnSuspended();
    }

    protected void executeOnStarted() throws CoreException {
        if (this.isSuspended) {
            this.executeOnSuspended();
        } else {
            this.log.finest("end receive behaviour on node: " + this.node.getName());
            this.state = Behaviour.State.ACTIVITY_ENDED;
            this.log.finest("received activity ended");
            this.setMessage(null);
            this.childNodeSelected = null;
        }
    }

    public void clean() {
        super.clean();
        this.message = null;
    }
}

